/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.xsql.XSQLPageRequest;
import org.xml.sax.SAXParseException;

public final class XSQLErrorWriter {
    String[] message = new String[4];
    int messages = -1;
    XSQLPageRequest env = null;

    public XSQLErrorWriter(String string, Throwable throwable, XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
        this.addMessage(string);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        this.addMessage(stringWriter.toString());
    }

    public XSQLErrorWriter(String string, XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
        this.addMessage(string);
    }

    public XSQLErrorWriter(String string, String string2, XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
        this.addMessage(string);
        this.addMessage(string2);
    }

    public XSQLErrorWriter(String string, String string2, SAXParseException sAXParseException, XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
        this.addMessage(string);
        this.addMessage(string2);
        this.xmlError(sAXParseException);
    }

    public XSQLErrorWriter(String string, SAXParseException sAXParseException, XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
        this.addMessage(string);
        this.xmlError(sAXParseException);
    }

    public XSQLErrorWriter(SAXParseException sAXParseException, XSQLPageRequest xSQLPageRequest) {
        this.env = xSQLPageRequest;
        this.xmlError(sAXParseException);
    }

    public void print() {
        if (this.env.useHTMLErrors()) {
            this.env.setContentType("text/html");
        } else {
            this.env.setContentType("text/plain");
        }
        PrintWriter printWriter = this.env.getErrorWriter();
        if (this.env.useHTMLErrors()) {
            if (!this.env.printedErrorHeader()) {
                printWriter.println("<H2>" + XSQLErrorWriter.versionMessage(this.env) + "</H2>");
                this.env.setPrintedErrorHeader(true);
            }
            for (int i = 0; i <= this.messages; ++i) {
                if (this.message[i] == null || this.message[i].equals("")) continue;
                printWriter.println("<font size='-1' face='monospace'>" + this.crlfToBr(this.message[i]) + "</font><BR>");
            }
        } else {
            if (!this.env.printedErrorHeader()) {
                printWriter.println(XSQLErrorWriter.versionMessage(this.env));
                this.env.setPrintedErrorHeader(true);
            }
            for (int i = 0; i <= this.messages; ++i) {
                if (this.message[i] == null || this.message[i].equals("")) continue;
                printWriter.println(this.message[i]);
            }
        }
        printWriter.flush();
    }

    private String crlfToBr(String string) {
        int n = 0;
        boolean bl = false;
        while ((n = string.indexOf("\n")) >= 0) {
            string = string.substring(0, n) + "<BR>" + string.substring(n + 1);
        }
        return string;
    }

    private void xmlError(SAXParseException sAXParseException) {
        int n = sAXParseException.getLineNumber();
        int n2 = sAXParseException.getColumnNumber();
        String string = sAXParseException.getSystemId();
        String string2 = sAXParseException.getMessage();
        this.addMessage("XML parse error at line " + n + ", char " + n2);
        this.addMessage(string2);
    }

    private static String versionMessage(XSQLPageRequest xSQLPageRequest) {
        return XMLParser.getReleaseVersion();
    }

    private void addMessage(String string) {
        this.message[++this.messages] = string;
    }

    public static String getXSQLVersionMessage(XSQLPageRequest xSQLPageRequest) {
        return XSQLErrorWriter.versionMessage(xSQLPageRequest);
    }
}

