/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import oracle.xml.parser.v2.XMLDOMImplementation;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;

public class XSQLError {
    private boolean hasErrorCode = false;
    private int errorCode;
    private String message;
    private String[] errorMessageArgs;
    private Object[] supplementalErrorInfo;
    private String[] messages;

    XSQLError(String string) {
        this.hasErrorCode = false;
        this.message = string;
    }

    XSQLError(int n, String[] stringArray, Object[] objectArray) {
        this.hasErrorCode = true;
        this.errorCode = n;
        this.errorMessageArgs = stringArray;
        this.supplementalErrorInfo = objectArray;
    }

    public String getMessage() {
        if (this.hasErrorCode) {
            return Res.format(this.errorCode, this.errorMessageArgs);
        }
        return this.message;
    }

    public Object[] getSupplementalErrorInfo() {
        return this.supplementalErrorInfo;
    }

    public String getErrorXML() {
        if (this.messages == null) {
            this.fillMessages();
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("<Error xsql-version='" + XSQLRequest.getPageProcessorVersion() + "'" + (this.hasErrorCode ? " code='" + this.errorCode + "'" : "") + ">");
        for (int i = 0; i < this.messages.length; ++i) {
            if (this.messages[i] == null || this.messages[i].equals("")) continue;
            printWriter.println("<Message>" + this.messages[i] + "</Message>");
        }
        printWriter.println("</Error>");
        printWriter.flush();
        return stringWriter.toString();
    }

    private void fillMessages() {
        int n;
        Vector<Object> vector = new Vector<Object>(4);
        vector.addElement(this.getMessage());
        if (this.supplementalErrorInfo != null) {
            for (n = 0; n < this.supplementalErrorInfo.length; ++n) {
                Object object = this.supplementalErrorInfo[n];
                if (object == null) continue;
                if (object instanceof String) {
                    vector.addElement(object);
                    continue;
                }
                if (object instanceof SAXParseException) {
                    vector.addElement(this.xmlErrorLineInfo((SAXParseException)object));
                    vector.addElement(this.xmlErrorMessage((SAXParseException)object));
                    continue;
                }
                if (object instanceof Throwable) {
                    vector.addElement(this.dumpThrowableToString((Throwable)object));
                    continue;
                }
                String string = null;
                try {
                    string = object.toString();
                }
                catch (Throwable throwable) {
                    vector.addElement(Res.getString(25124));
                }
                vector.addElement(string == null ? "(null)" : string);
            }
        }
        n = vector.size();
        this.messages = new String[n];
        for (int i = 0; i < n; ++i) {
            this.messages[i] = (String)vector.elementAt(i);
        }
    }

    public Document getErrorXMLDocument() {
        XMLDOMImplementation xMLDOMImplementation = new XMLDOMImplementation();
        Document document = xMLDOMImplementation.createDocument("", "Error", null);
        Element element = document.getDocumentElement();
        element.setAttribute("xsql-version", XSQLRequest.getPageProcessorVersion());
        if (this.hasErrorCode) {
            element.setAttribute("code", new Integer(this.errorCode).toString());
        }
        if (this.messages == null) {
            this.fillMessages();
        }
        for (int i = 0; i < this.messages.length; ++i) {
            if (this.messages[i] == null || this.messages[i].equals("")) continue;
            element.appendChild(document.createElement("Message").appendChild(document.createTextNode(this.messages[i])));
        }
        return document;
    }

    public Integer getErrorCode() {
        if (this.hasErrorCode) {
            return new Integer(this.errorCode);
        }
        return null;
    }

    private String xmlErrorLineInfo(SAXParseException sAXParseException) {
        int n = sAXParseException.getLineNumber();
        int n2 = sAXParseException.getColumnNumber();
        String string = sAXParseException.getSystemId();
        return "XML parse error at line " + n + ", char " + n2;
    }

    private String xmlErrorMessage(SAXParseException sAXParseException) {
        return sAXParseException.getMessage();
    }

    private String dumpThrowableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

