/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import oracle.xml.xsql.XSQLConnectionManagerFactory;
import oracle.xml.xsql.XSQLPage;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLPageRequestImpl;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

final class XSQLCustomPageRequest
extends XSQLPageRequestImpl {
    private URL baseURL = null;
    private Document postedXML = null;
    private XSQLPage page = null;

    public XSQLCustomPageRequest(XSQLPage xSQLPage, URL uRL, Dictionary dictionary, PrintWriter printWriter) {
        this.baseURL = uRL;
        this.parameters = dictionary;
        this.page = xSQLPage;
        this.err = printWriter;
    }

    public XSQLCustomPageRequest(XSQLConnectionManagerFactory xSQLConnectionManagerFactory, XSQLPage xSQLPage, URL uRL, Dictionary dictionary, PrintWriter printWriter) {
        this.connFactory = xSQLConnectionManagerFactory;
        this.baseURL = uRL;
        this.parameters = dictionary;
        this.page = xSQLPage;
        this.err = printWriter;
    }

    public XSQLCustomPageRequest(XSQLPage xSQLPage, URL uRL, Dictionary dictionary, OutputStream outputStream, PrintWriter printWriter) {
        this.baseURL = uRL;
        this.parameters = dictionary;
        this.page = xSQLPage;
        if (outputStream != null) {
            this.outStream = outputStream;
        }
        this.err = printWriter;
    }

    public XSQLCustomPageRequest(XSQLConnectionManagerFactory xSQLConnectionManagerFactory, XSQLPage xSQLPage, URL uRL, Dictionary dictionary, OutputStream outputStream, PrintWriter printWriter) {
        this.connFactory = xSQLConnectionManagerFactory;
        this.baseURL = uRL;
        this.parameters = dictionary;
        this.page = xSQLPage;
        if (outputStream != null) {
            this.outStream = outputStream;
        }
        this.err = printWriter;
    }

    public XSQLCustomPageRequest(XSQLPage xSQLPage, URL uRL, Dictionary dictionary, PrintWriter printWriter, PrintWriter printWriter2) {
        this.baseURL = uRL;
        this.parameters = dictionary;
        this.page = xSQLPage;
        if (printWriter != null) {
            this.out = printWriter;
        }
        this.err = printWriter2;
    }

    public XSQLCustomPageRequest(XSQLConnectionManagerFactory xSQLConnectionManagerFactory, XSQLPage xSQLPage, URL uRL, Dictionary dictionary, PrintWriter printWriter, PrintWriter printWriter2) {
        this.connFactory = xSQLConnectionManagerFactory;
        this.baseURL = uRL;
        this.parameters = dictionary;
        this.page = xSQLPage;
        if (printWriter != null) {
            this.out = printWriter;
        }
        this.err = printWriter2;
    }

    private XSQLCustomPageRequest(URL uRL, Dictionary dictionary, PrintWriter printWriter, OutputStream outputStream, PrintWriter printWriter2) {
        this.baseURL = uRL;
        this.pageurl = XSQLUtil.safeURLAsString(uRL);
        this.parameters = dictionary;
        this.page = this.page;
        if (printWriter != null) {
            this.out = printWriter;
        } else if (outputStream != null) {
            this.outStream = outputStream;
        }
        this.err = printWriter2;
    }

    @Override
    public String getParameter(String string) {
        String string2 = super.getParameter(string);
        if (string2 != null) {
            return string2;
        }
        if (!(this.parameters == null || string.equals("xml-stylesheet") && this.isIncluded)) {
            return XSQLUtil.stringParamValue(this.parameters.get(string));
        }
        return null;
    }

    @Override
    public String[] getParameterValues(String string) {
        String[] stringArray = super.getParameterValues(string);
        if (stringArray != null) {
            return stringArray;
        }
        if (!(this.parameters == null || string.equals("xml-stylesheet") && this.isIncluded)) {
            return XSQLUtil.stringParamValues(this.parameters.get(string));
        }
        return null;
    }

    private void setupPageURL() {
    }

    @Override
    protected void setupWriter() {
    }

    @Override
    protected void setupOutputStream() {
    }

    @Override
    protected void setupErrorWriter() {
    }

    @Override
    public String translateURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(this.baseURL, string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return uRL.toExternalForm();
    }

    @Override
    public String getRequestType() {
        return "Custom";
    }

    @Override
    public Document getPostedDocument() {
        return this.postedXML;
    }

    @Override
    public void setPostedDocument(Document document) {
        this.postedXML = document;
    }

    @Override
    public XSQLPageRequest createNestedRequest(String string, URL uRL, Dictionary dictionary, PrintWriter printWriter, OutputStream outputStream) {
        Object object;
        Object object2;
        Dictionary dictionary2 = null;
        if (this.parameters != null) {
            if (dictionary == null) {
                dictionary2 = this.parameters;
            } else {
                object2 = this.parameters.keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (dictionary.get(object) != null) continue;
                    dictionary.put(object, this.parameters.get(object));
                }
                dictionary2 = dictionary;
            }
        } else {
            dictionary2 = dictionary;
        }
        object2 = this.getTopRequest();
        object = new XSQLCustomPageRequest(uRL, dictionary2, printWriter, outputStream, this.err);
        ((XSQLPageRequestImpl)object).setTopRequest((XSQLPageRequest)(object2 != null ? object2 : this));
        return object;
    }

    @Override
    public XSQLPage getXSQLPage() throws SAXParseException, FileNotFoundException {
        if (this.page != null) {
            return this.page;
        }
        return super.getXSQLPage();
    }
}

