/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xmldbaccess;

import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.xdb.XMLType;
import oracle.xml.dbaccess.DBAccess;

public class XMLDBAccess
extends DBAccess {
    private static final short STRING = 1;
    private static final short CLOB = 2;

    public boolean isXMLTypeTable(Connection connection, String string) throws Exception {
        ResultSet resultSet = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        string = string.toUpperCase();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT COLUMN_NAME,DATA_TYPE FROM USER_TAB_COLUMNS WHERE TABLE_NAME= ?");
        preparedStatement.setString(1, string);
        resultSet = preparedStatement.executeQuery();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet.add("FILENAME");
        hashSet.add("CHAR");
        hashSet.add("FILEDATA");
        hashSet.add("XMLTYPE");
        if (resultSet.next()) {
            hashSet2.clear();
            string2 = resultSet.getString(1);
            string3 = resultSet.getString(2);
            hashSet2.add(string2);
            hashSet2.add(string3);
            if (resultSet.next()) {
                string4 = resultSet.getString(1);
                string5 = resultSet.getString(2);
                hashSet2.add(string4);
                hashSet2.add(string5);
            }
            resultSet.close();
            preparedStatement.close();
            return hashSet.equals(hashSet2);
        }
        resultSet.close();
        preparedStatement.close();
        return false;
    }

    public String[] getXMLTypeTableNames(Connection connection, String string) throws Exception {
        ResultSet resultSet = null;
        Vector<String> vector = new Vector<String>(10);
        int n = 0;
        string = string.toUpperCase();
        Statement statement = connection.createStatement();
        resultSet = statement.executeQuery("SELECT TABLE_NAME FROM USER_TABLES");
        while (resultSet.next()) {
            String string2 = resultSet.getString(1);
            boolean bl = false;
            if (string != null && string.length() > 0) {
                bl = true;
            }
            if ((!bl || !string2.startsWith(string)) && bl || !this.isXMLTypeTable(connection, string2)) continue;
            vector.addElement(string2);
        }
        String[] stringArray = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        resultSet.close();
        statement.close();
        return stringArray;
    }

    public boolean createXMLTypeTable(Connection connection, String string) throws Exception {
        string = string.toUpperCase();
        String string2 = "CREATE TABLE " + string + " (FILENAME CHAR( " + this.nameSize + " ) UNIQUE, FILEDATA sys.XMLType) ";
        try {
            Statement statement = connection.createStatement();
            statement.execute(string2);
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public boolean insertXMLTypeData(Connection connection, String string, String string2, String string3) throws SQLException, IOException, NoClassDefFoundError {
        OraclePreparedStatement oraclePreparedStatement = null;
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        if ((string2 = string2.trim()).length() > this.nameSize) {
            string2 = string2.substring(0, this.nameSize);
        }
        try {
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement("insert into " + string + " values(?, ?)");
            oraclePreparedStatement.setString(1, string2);
            XMLType xMLType = XMLType.createXML((Connection)connection, (String)string3);
            oraclePreparedStatement.setObject(2, (Object)xMLType);
            oraclePreparedStatement.execute();
            oraclePreparedStatement.close();
            return true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
    }

    public boolean replaceXMLTypeData(Connection connection, String string, String string2, String string3) throws Exception, NoClassDefFoundError {
        boolean bl = this.deleteXMLName(connection, string, string2);
        return this.insertXMLTypeData(connection, string, string2, string3);
    }

    public String getXMLTypeData(Connection connection, String string, String string2) throws SQLException {
        return (String)this.getXMLType(connection, string, string2, (short)1);
    }

    public Clob getXMLTypeClob(Connection connection, String string, String string2) throws SQLException {
        return (Clob)this.getXMLType(connection, string, string2, (short)2);
    }

    private Object getXMLType(Connection connection, String string, String string2, short s) throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        String string3 = null;
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        try {
            if (s == 1) {
                oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement("SELECT e.FILEDATA.getStringVal() FROM " + string + " e WHERE FILENAME=" + "'" + string2 + "'");
            } else if (s == 2) {
                oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement("SELECT e.FILEDATA.getCLOBVal() FROM " + string + " e WHERE FILENAME=" + "'" + string2 + "'");
            }
            oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
            oracleResultSet.next();
            if (s == 1) {
                string3 = oracleResultSet.getString(1);
            } else if (s == 2) {
                string3 = oracleResultSet.getCLOB(1);
            }
            oraclePreparedStatement.close();
            oracleResultSet.close();
            return string3;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    public String getXMLTypeXPathTextData(Connection connection, String string, String string2, String string3) throws SQLException {
        return (String)this.getXMLTypeXPath(connection, string, string2, string3, (short)1);
    }

    public Clob getXMLTypeXPathCLOB(Connection connection, String string, String string2, String string3) throws SQLException {
        return (Clob)this.getXMLTypeXPath(connection, string, string2, string3, (short)2);
    }

    private Object getXMLTypeXPath(Connection connection, String string, String string2, String string3, short s) throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        Object object = null;
        try {
            if (s == 1) {
                oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement("SELECT e.FILEDATA.extract('" + string3 + "').getStringVal() FROM " + string + " e WHERE FILENAME=" + "'" + string2 + "'");
            } else if (s == 2) {
                oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement("SELECT e.FILEDATA.extract('" + string3 + "').getCLOBVal() FROM " + string + " e WHERE FILENAME=" + "'" + string2 + "'");
            }
            oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
            oracleResultSet.next();
            if (s == 1) {
                object = oracleResultSet.getString(1);
            } else if (s == 2) {
                object = oracleResultSet.getClob(1);
            }
            oraclePreparedStatement.close();
            oracleResultSet.close();
            return object;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }
}

