/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transx;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Vector;
import oracle.xml.transx.DuplicateException;
import oracle.xml.transx.Options;
import oracle.xml.transx.TransX;
import oracle.xml.transx.TransXImpl;
import oracle.xml.transx.TxuErrMsg;
import oracle.xml.util.PasswordField;

public class loader {
    Options m_options;
    int m_trace = 0;
    String m_constr;
    String m_usr;
    String m_pwd;
    Vector m_datasources = new Vector();

    public loader() {
        this.m_options = new Options();
    }

    public static void main(String[] stringArray) throws Exception {
        loader loader2 = new loader();
        loader2.parseArgs(stringArray);
        try {
            if (loader2.m_options.get(4)) {
                loader2.validate();
            } else if (loader2.m_options.get(6)) {
                loader2.unload();
            } else {
                loader2.load();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
        }
        catch (DuplicateException duplicateException) {
            System.err.println("oracle.xml.transx.DuplicateException: " + duplicateException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            System.err.println(runtimeException.getMessage());
        }
    }

    void validate() throws Exception {
        TransX transX = loader.getLoader(this.m_options);
        for (int i = 0; i < this.m_datasources.size(); ++i) {
            Object object;
            String string = (String)this.m_datasources.elementAt(i);
            File file = new File(string);
            if (file != null && file.canRead()) {
                transX.validate(string);
                continue;
            }
            try {
                URL uRL = new URL(string);
                object = null;
                object = uRL.openConnection();
                if (object == null) {
                    throw new RuntimeException("Bad datasource: " + string + "\n");
                }
                object = null;
                transX.validate(uRL);
                continue;
            }
            catch (Exception exception) {
                object = TxuErrMsg.getMessage(300, string);
                System.err.println((String)object);
            }
        }
    }

    int load() throws Exception {
        TransX transX = loader.getLoader(this.m_options);
        transX.open(this.m_constr, this.m_usr, this.m_pwd);
        transX.setLoadingMode(this.m_options.getLoadingMode());
        transX.setValidationMode(this.m_options.get(3));
        int n = 0;
        for (int i = 0; i < this.m_datasources.size(); ++i) {
            Object object;
            String string = (String)this.m_datasources.elementAt(i);
            File file = new File(string);
            if (file.canRead()) {
                n += transX.load(string);
                continue;
            }
            try {
                URL uRL = new URL(string);
                object = null;
                object = uRL.openConnection();
                if (object != null) {
                    object = null;
                    n += transX.load(uRL);
                    continue;
                }
                throw new RuntimeException("Bad datasource: " + string + "\n");
            }
            catch (Exception exception) {
                object = TxuErrMsg.getMessage(300, string);
                System.err.println((String)object);
            }
        }
        transX.close();
        return n;
    }

    void unload() throws Exception {
        String[] stringArray;
        TransX transX = loader.getLoader(this.m_options);
        transX.open(this.m_constr, this.m_usr, this.m_pwd);
        String string = this.m_options.getFileName();
        Writer writer = string == null ? new PrintWriter(System.out) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF8"));
        writer.write("<?xml version=\"1.0\" ?>");
        writer.write(System.getProperty("line.separator"));
        String string2 = this.m_options.getTableName();
        Vector vector = this.m_options.getColumnNames();
        if (vector == null) {
            stringArray = null;
        } else {
            stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
        }
        transX.unload(string2, stringArray, writer);
        writer.flush();
        transX.close();
    }

    void parseArgs(String[] stringArray) {
        if (stringArray.length < 2) {
            loader.usage();
            System.exit(0);
        }
        if (stringArray[0].equals("-v")) {
            this.m_options.set(4, true);
            for (int i = 1; i < stringArray.length; ++i) {
                this.m_datasources.addElement(stringArray[i]);
            }
            return;
        }
        if (stringArray[0].equals("-x") || stringArray[0].equals("-s")) {
            if (stringArray.length < 5 || stringArray[0].equals("-s") && stringArray.length < 6) {
                loader.usage();
                System.exit(0);
            }
            this.m_constr = stringArray[1];
            this.m_usr = stringArray[2];
            this.m_pwd = this.checkPassword(stringArray[3]);
            int n = 4;
            if (stringArray[0].equals("-s")) {
                this.m_options.setFileName(stringArray[n++]);
            }
            this.m_options.setTableName(stringArray[n++]);
            while (n < stringArray.length) {
                this.m_options.addColumnName(stringArray[n++]);
            }
            this.m_options.set(6, true);
            return;
        }
        if (stringArray.length < 4) {
            loader.usage();
            System.exit(0);
        }
        block12: for (int i = 0; i < stringArray.length; ++i) {
            if (!(stringArray[i].charAt(0) != '-' || stringArray[i].length() != 2 && stringArray[i].length() != 3 || "-pw".equals(stringArray[i]))) {
                char c = Character.toLowerCase(stringArray[i].charAt(1));
                char c2 = '\u0000';
                if (stringArray[i].length() == 3) {
                    c2 = Character.toLowerCase(stringArray[i].charAt(2));
                }
                switch (c) {
                    case 'u': {
                        this.m_options.setLoadingMode(1);
                        break;
                    }
                    case 'e': {
                        this.m_options.setLoadingMode(2);
                        break;
                    }
                    case 'p': {
                        this.m_options.set(0, true);
                        break;
                    }
                    case 't': {
                        this.m_options.set(1, true);
                        break;
                    }
                    case 's': {
                        this.m_options.set(2, true);
                        break;
                    }
                    case 'o': {
                        this.m_options.set(3, false);
                        break;
                    }
                    case 'w': {
                        this.m_options.set(5, true);
                        break;
                    }
                    case 'l': {
                        if (c2 == '\u0000') continue block12;
                        if (c2 == 's') {
                            this.m_options.setLangTagStyle(1);
                            break;
                        }
                        if (c2 == 'u') {
                            this.m_options.setLangTagStyle(2);
                            break;
                        }
                        if (c2 != 'l') continue block12;
                        this.m_options.setLangTagStyle(3);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unrecognized option -" + c);
                    }
                }
                continue;
            }
            if (this.m_constr == null) {
                this.m_constr = stringArray[i];
                continue;
            }
            if (this.m_usr == null) {
                this.m_usr = stringArray[i];
                continue;
            }
            if (this.m_pwd == null) {
                this.m_pwd = this.checkPassword(stringArray[i]);
                continue;
            }
            this.m_datasources.addElement(stringArray[i]);
        }
    }

    String checkPassword(String string) {
        String string2 = string;
        if ("-pw".equals(string)) {
            try {
                string2 = String.valueOf(PasswordField.getPassword((InputStream)System.in, (String)TxuErrMsg.getText(520)));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return string2;
    }

    public static TransX getLoader() {
        return new TransXImpl();
    }

    static TransX getLoader(Options options) {
        return new TransXImpl(options);
    }

    static void usage() {
        TxuErrMsg txuErrMsg = new TxuErrMsg();
        System.err.println("transx: " + TxuErrMsg.getText(500));
        System.err.println("Usage:");
        System.err.println("> java oracle.xml.transx.loader [<option>...]");
        System.err.print("  [<connect_string> <username> <password>] ");
        System.err.println("[<datasource>...]");
        System.err.println(TxuErrMsg.getText(501));
        System.err.println(" connect_string ... " + TxuErrMsg.getText(502));
        System.err.println("\t" + TxuErrMsg.getText(503));
        System.err.println("\t" + TxuErrMsg.getText(504));
        System.err.println(" username       ... " + TxuErrMsg.getText(505));
        System.err.println(" password | -pw ... " + TxuErrMsg.getText(506));
        System.err.println(" datasource     ... " + TxuErrMsg.getText(507));
        System.err.println(TxuErrMsg.getText(508));
        System.err.println(" -u ... " + TxuErrMsg.getText(509));
        System.err.println(" -e ... " + TxuErrMsg.getText(510));
        System.err.println(" -x ... " + TxuErrMsg.getText(511));
        System.err.println(" -s ... " + TxuErrMsg.getText(512));
        System.err.println(" -p ... " + TxuErrMsg.getText(513));
        System.err.println(" -t ... " + TxuErrMsg.getText(514));
        System.err.println(" -o ... " + TxuErrMsg.getText(515));
        System.err.println(" -v ... " + TxuErrMsg.getText(516));
        System.err.println(" -w ... " + TxuErrMsg.getText(517));
        System.err.println(" -ls / -lu / -ll ... " + TxuErrMsg.getText(519));
        System.err.println(TxuErrMsg.getText(518));
        System.err.print("> java oracle.xml.transx.loader \"myhost:1521:mydb\"");
        System.err.println(" scott -pw foo.xml ");
        System.err.print("> java oracle.xml.transx.loader \"jdbc:oracle:oci:@mydb\"");
        System.err.println(" scott -pw foo.xml ");
        System.err.println("> java oracle.xml.transx.loader -v foo.xml ");
        System.err.print("> java oracle.xml.transx.loader -s \"myhost:1521:mydb\"");
        System.err.println(" scott -pw emp.xml emp");
        System.err.print("> java oracle.xml.transx.loader -x \"myhost:1521:mydb\"");
        System.err.println(" scott -pw emp ename job");
    }
}

