/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transx;

import java.util.Vector;
import oracle.xml.transx.TxuErrMsg;

class Options {
    boolean m_fPrintXSUDoc = false;
    boolean m_fPrintXSUDoc4Update = false;
    boolean m_fPrintSource = false;
    boolean m_fValidation = true;
    boolean m_fValidationOnly = false;
    boolean m_fPreserveWhitespace = false;
    boolean m_fUnload = false;
    String m_filename;
    String m_tablename;
    Vector m_colnames;
    int m_loadingMode = 0;
    int m_LangTagStyle = 0;
    static final int PRINT_XSU_DOC = 0;
    static final int PRINT_UPD_DOC = 1;
    static final int PRINT_SRC_DOC = 2;
    static final int VARIDATING = 3;
    static final int VARIDATION_ONLY = 4;
    static final int PRESERVE_WHITESPACE = 5;
    static final int UNLOAD = 6;

    void setLoadingMode(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.m_loadingMode = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Loading Mode " + n + "\n");
            }
        }
    }

    int getLoadingMode() {
        return this.m_loadingMode;
    }

    void setLangTagStyle(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.m_LangTagStyle = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid casing style '" + n + "' for the language identifier\n");
            }
        }
    }

    int getLangTagStyle() {
        return this.m_LangTagStyle;
    }

    void set(int n, boolean bl) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                this.m_fPrintXSUDoc = bl;
                break;
            }
            case 1: {
                this.m_fPrintXSUDoc4Update = bl;
                break;
            }
            case 2: {
                this.m_fPrintSource = bl;
                break;
            }
            case 3: {
                this.m_fValidation = bl;
                break;
            }
            case 4: {
                this.m_fValidationOnly = bl;
                break;
            }
            case 5: {
                this.m_fPreserveWhitespace = bl;
                break;
            }
            case 6: {
                this.m_fUnload = bl;
                break;
            }
            default: {
                String string = TxuErrMsg.getMessage(402, new Integer(n).toString());
                throw new IllegalArgumentException(string);
            }
        }
    }

    boolean get(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return this.m_fPrintXSUDoc;
            }
            case 1: {
                return this.m_fPrintXSUDoc4Update;
            }
            case 2: {
                return this.m_fPrintSource;
            }
            case 3: {
                return this.m_fValidation;
            }
            case 4: {
                return this.m_fValidationOnly;
            }
            case 5: {
                return this.m_fPreserveWhitespace;
            }
            case 6: {
                return this.m_fUnload;
            }
        }
        String string = TxuErrMsg.getMessage(402, new Integer(n).toString());
        throw new IllegalArgumentException(string);
    }

    void setFileName(String string) {
        this.m_filename = string;
    }

    String getFileName() {
        return this.m_filename;
    }

    void setTableName(String string) {
        this.m_tablename = string;
    }

    String getTableName() {
        return this.m_tablename;
    }

    void setColumnNames(Vector vector) {
        this.m_colnames = vector;
    }

    Vector getColumnNames() {
        return this.m_colnames;
    }

    void addColumnName(String string) {
        if (this.m_colnames == null) {
            this.m_colnames = new Vector();
        }
        this.m_colnames.addElement(string);
    }
}

