/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.differ;

import oracle.xml.differ.DiffTreeNode;
import oracle.xml.parser.v2.XMLDeclPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

class NodeUtility {
    private short mode;
    static final int AVG_XPATH_LEN = 100;
    static final short CURR_NODE = 0;
    static final short PREV_SIB = 1;
    static final short NEXT_SIB = 2;
    static final short PARENT_NODE = 3;

    NodeUtility() {
    }

    static String getElementText(Node node, String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = NodeUtility.getIndentStr(string, n);
        switch (node.getNodeType()) {
            case 1: 
            case 9: {
                if (string != null && n2 != 2) {
                    stringBuffer.append("<xsl:text>\n" + string2 + "</xsl:text>");
                }
                stringBuffer.append("<" + node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    if (string != null) {
                        stringBuffer.append("\n" + string2 + string + namedNodeMap.item(i).getNodeName() + "=" + "\"" + namedNodeMap.item(i).getNodeValue() + "\"");
                        continue;
                    }
                    stringBuffer.append(" " + namedNodeMap.item(i).getNodeName() + "=" + "\"" + namedNodeMap.item(i).getNodeValue() + "\"");
                }
                stringBuffer.append(">");
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    stringBuffer.append(NodeUtility.getElementText(nodeList.item(i), string, n + 1, 0));
                }
                if (string != null && nodeList.getLength() >= 1 && nodeList.item(0).getNodeType() != 3) {
                    stringBuffer.append("<xsl:text>\n" + string2 + "</xsl:text>");
                }
                stringBuffer.append("</" + node.getNodeName() + ">");
                if (string == null) break;
                if (n2 == 2) {
                    stringBuffer.append("<xsl:text>\n" + string2 + "</xsl:text>");
                    break;
                }
                if (n2 != 3 || node.getNextSibling() != null) break;
                stringBuffer.append("<xsl:text>\n" + NodeUtility.getIndentStr(string, n - 1) + "</xsl:text>");
                break;
            }
            case 3: {
                return NodeUtility.handleSpecialChars(node.getNodeValue());
            }
            case 8: {
                return NodeUtility.handleSpecialChars("<!--" + node.getNodeValue() + "-->");
            }
            case 7: {
                return NodeUtility.handleSpecialChars("<?" + node.getNodeName() + " " + node.getNodeValue() + "?>");
            }
        }
        return stringBuffer.toString();
    }

    static String getIndentStr(String string, int n) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            while (--n > 0) {
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    static String getAttrNameText(Attr attr) {
        return NodeUtility.handleSpecialChars(attr.getNodeName());
    }

    static String getAttrValueText(Attr attr) {
        return NodeUtility.handleSpecialChars(attr.getNodeValue());
    }

    static String getCommentText(Comment comment) {
        return NodeUtility.handleSpecialChars(comment.getNodeValue());
    }

    static String getPINameText(ProcessingInstruction processingInstruction) {
        return NodeUtility.handleSpecialChars(processingInstruction.getNodeName());
    }

    static String getPIValueText(ProcessingInstruction processingInstruction) {
        return NodeUtility.handleSpecialChars(processingInstruction.getNodeValue());
    }

    static String handleSpecialChars(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == '&') {
                stringBuffer.append("&#38;");
                continue;
            }
            if (cArray[i] == '<') {
                stringBuffer.append("&#60;");
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    String getXPath(DiffTreeNode diffTreeNode, short s) {
        StringBuffer stringBuffer = new StringBuffer(100);
        Node node = diffTreeNode.getNodeObject();
        String string = node.getNodeName();
        short s2 = node.getNodeType();
        short s3 = diffTreeNode.getDiffType();
        DiffTreeNode diffTreeNode2 = null;
        switch (s2) {
            case 9: {
                return stringBuffer.toString();
            }
            case 2: {
                DiffTreeNode diffTreeNode3 = (DiffTreeNode)diffTreeNode.getParent();
                return this.getXPath(diffTreeNode3, (short)0) + stringBuffer;
            }
        }
        if (s == 0) {
            short s4;
            int n = 1;
            for (DiffTreeNode diffTreeNode4 = (DiffTreeNode)diffTreeNode.getPreviousSibling(); diffTreeNode4 != null && (s4 = diffTreeNode4.getNodeObject().getNodeType()) != 10; diffTreeNode4 = (DiffTreeNode)diffTreeNode4.getPreviousSibling()) {
                s3 = diffTreeNode4.getDiffType();
                if (s3 != 0 && s3 != 1 && s3 != 4 || s4 == 2) {
                    n += 0;
                    continue;
                }
                if (diffTreeNode4.getNodeObject().getNodeName() != string && (s2 != diffTreeNode4.getNodeObject().getNodeType() || (s2 != 7 || diffTreeNode4.getNodeObject() instanceof XMLDeclPI) && s2 != 8)) continue;
                ++n;
            }
            if (s2 == 8) {
                string = "comment()";
            } else if (s2 == 7) {
                string = "processing-instruction()";
            } else if (s2 == 3) {
                string = "text()";
            }
            stringBuffer.append("/" + string + "[" + String.valueOf(n) + "]");
            diffTreeNode2 = (DiffTreeNode)diffTreeNode.getParent();
        } else if (s == 1) {
            diffTreeNode2 = (DiffTreeNode)diffTreeNode.getPreviousSibling();
            if (diffTreeNode2 == null || diffTreeNode2.getNodeObject() instanceof XMLDeclPI) {
                return null;
            }
            short s5 = diffTreeNode2.getNodeObject().getNodeType();
            s3 = diffTreeNode2.getDiffType();
            while (diffTreeNode2 != null && (s3 != 0 && s3 != 1 || s5 == 2)) {
                if ((diffTreeNode2 = (DiffTreeNode)diffTreeNode2.getPreviousSibling()) == null || diffTreeNode2.getNodeObject() instanceof XMLDeclPI) {
                    return null;
                }
                s5 = diffTreeNode2.getNodeObject().getNodeType();
                s3 = diffTreeNode2.getDiffType();
            }
            this.mode = 1;
        } else if (s == 2) {
            diffTreeNode2 = (DiffTreeNode)diffTreeNode.getNextSibling();
            if (diffTreeNode2 == null) {
                return null;
            }
            short s6 = diffTreeNode2.getNodeObject().getNodeType();
            s3 = diffTreeNode2.getDiffType();
            while (diffTreeNode2 != null && (s3 != 0 && s3 != 1 || s6 == 2)) {
                if ((diffTreeNode2 = (DiffTreeNode)diffTreeNode2.getNextSibling()) == null) {
                    return null;
                }
                s6 = diffTreeNode2.getNodeObject().getNodeType();
                s3 = diffTreeNode2.getDiffType();
            }
            this.mode = (short)2;
        } else {
            diffTreeNode2 = (DiffTreeNode)diffTreeNode.getParent();
            this.mode = (short)3;
        }
        if ((this.mode == 1 || this.mode == 2) && diffTreeNode.getDiffType() == 4) {
            this.mode = 0;
            diffTreeNode2 = diffTreeNode;
        }
        return this.getXPath(diffTreeNode2, (short)0) + stringBuffer;
    }
}

