/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.diff;

import java.util.HashMap;
import org.w3c.dom.Node;

public abstract class DiffOp
implements Comparable<DiffOp> {
    Name operationName;
    Node parentNode;
    Node siblingNode;
    Node currentNode;
    Node newNode;
    int siteNodeId;
    int newNodeId;
    int textNodeNumber;
    int generationId;
    boolean hasOriginalTextNodes;
    int deleteOpNumber;
    String pathToNode;
    HashMap<String, String> prefixToNamespace;

    public abstract Name getOpName();

    public abstract Node getCurrent() throws Exception;

    public abstract Node getNew() throws Exception;

    public abstract Node getSibling() throws Exception;

    public abstract Node getParent() throws Exception;

    public abstract String getParentXPath() throws Exception;

    public abstract String getSiblingXPath() throws Exception;

    public abstract String getCurrentXPath() throws Exception;

    abstract String getNewXPath() throws Exception;

    public HashMap<String, String> getPrefixToNamespace() {
        return this.prefixToNamespace;
    }

    void setPrefixToNamespace(HashMap<String, String> hashMap) {
        this.prefixToNamespace = hashMap;
    }

    void setPath(String string) {
        this.pathToNode = string;
    }

    abstract void setNew(Node var1) throws Exception;

    int getSiteNodeId() {
        return this.siteNodeId;
    }

    @Override
    public int compareTo(DiffOp diffOp) {
        if (this.getSiteNodeId() < diffOp.getSiteNodeId()) {
            return -1;
        }
        if (this.getSiteNodeId() == diffOp.getSiteNodeId()) {
            if (this.getOpName() == Name.DELETE && diffOp.getOpName() == Name.INSERT_BEFORE_NODE) {
                return 1;
            }
            if (this.getOpName() == Name.INSERT_BEFORE_NODE && diffOp.getOpName() == Name.DELETE) {
                return -1;
            }
            if (this.generationId < diffOp.generationId) {
                return -1;
            }
            return 1;
        }
        return 1;
    }

    public static enum Name {
        DELETE,
        INSERT_BY_APPENDING,
        INSERT_BEFORE_NODE;

    }
}

