/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.transform.URIResolver;
import javax.xml.xpath.XPathVariableResolver;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLTContext;
import oracle.xml.scalable.BinaryNav;
import oracle.xml.scalable.PageManagerPool;
import oracle.xml.xpath.BinaryNode;
import oracle.xml.xpath.StreamingSequence;
import oracle.xml.xpath.XPathContext;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.functions.OXMLCollator;
import oracle.xml.xqxp.functions.OXMLCollatorResolver;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNamespace;
import oracle.xml.xslt.XSLSourceContext;

public class XPathRuntimeContext
extends XSLTContext
implements OXMLFunctionContext,
XSLConstants {
    protected boolean debug = false;
    private boolean isDebugMode = false;
    private boolean streaming = true;
    private boolean createNode = false;
    private boolean enableException = false;
    private XPathItem firstFreeItem;
    private XPathItem lastFreeItem;
    private Locale dfLocale = Locale.US;
    private DecimalFormat numberFormat;
    private DecimalFormatSymbols DFS;
    protected XMLNode contextNode;
    protected XMLNode currentNode;
    protected OXMLItem contextItem;
    protected int contextSize;
    protected int contextPos;
    protected GregorianCalendar contextDateTime;
    protected XPathContext jxContext;
    protected XMLSchema schema;
    protected XPathSequence[] varValues;
    protected int varValuesIndex;
    private HashMap<XSLExprBase, StreamingSequence> streamValues;
    private URL baseUrl;
    private BinaryNav binNav;
    int ctxForm;
    long ctxIdx;
    private Hashtable sourceContext = new Hashtable(20);
    private HashMap<String, XMLElement> knownDocs = new HashMap(20);
    private HashMap<String, OXMLCollator> knownCollators = new HashMap(20);
    private int numSourceContext;
    private XSLSourceContext onlySourceContext;
    private XMLElement onlySrcRoot;
    protected OXMLSequence[] valueStack = new XPathSequence[this.valueStackSize];
    private int valueStackSize = 10;
    protected int valueStackIndex = -1;
    private XPathVariableResolver varResolver;
    private URIResolver uriResolver;
    private OXMLCollatorResolver collatorResolver;
    protected int version;
    protected boolean bkwdCompFlag;
    protected boolean fwdCompFlag;
    protected String defaultcollation = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    private Hashtable nsTable;
    private OXMLSequence curNodeList;
    private OXMLSequence altNodeList;
    private NSResolver nsResolver;
    private HashMap cachedValues;
    static OXMLCollator caseblindCollator = new CaseblindCollator();
    protected static final TimeZone contextTimeZone;
    public static String caseblindString;
    static final int NODE = 0;
    static final int ITEM = 1;
    static final int INDEX = 2;

    public XPathRuntimeContext() {
        for (int i = 0; i < this.valueStackSize; ++i) {
            this.valueStack[i] = new XPathSequence(this);
        }
        this.varValuesIndex = 0;
        this.baseUrl = null;
        this.streamValues = new HashMap(64);
        this.firstFreeItem = this.lastFreeItem = new XPathItem();
        this.firstFreeItem.setContext(this);
    }

    public void setDecimalFormatLocale(Locale locale) {
        this.dfLocale = locale;
        this.setNumberFormat(locale);
    }

    Locale getDecimalFormatLocale() {
        return this.dfLocale;
    }

    DecimalFormatSymbols getDecimalFormatSymbols() {
        if (this.DFS != null) {
            return this.DFS;
        }
        this.DFS = new DecimalFormatSymbols(this.dfLocale);
        this.DFS.setNaN("NaN");
        this.DFS.setInfinity("Infinity");
        return this.DFS;
    }

    void setNumberFormat(Locale locale) {
        this.numberFormat = (DecimalFormat)DecimalFormat.getInstance(locale);
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMaximumFractionDigits(100);
    }

    public DecimalFormat getNumberFormat() {
        if (this.numberFormat == null) {
            this.numberFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
            this.numberFormat.setGroupingUsed(false);
            this.numberFormat.setMaximumFractionDigits(100);
        }
        return this.numberFormat;
    }

    @Override
    public XMLNode getContextNode() throws XSLException {
        if (this.ctxForm == 0) {
            return this.contextNode;
        }
        if (this.ctxForm == 1) {
            return this.contextItem.getNode();
        }
        if (this.ctxForm == 2) {
            return new BinaryNode(this.ctxIdx, this.binNav);
        }
        return null;
    }

    void setBinaryNav(BinaryNav binaryNav) {
        this.binNav = binaryNav;
    }

    BinaryNav getBinaryNav() {
        return this.binNav;
    }

    long getContextIndex() {
        return this.ctxIdx;
    }

    int getCtxForm() {
        return this.ctxForm;
    }

    int getXSLTVersion() {
        return this.version;
    }

    public XMLNode getJDWPContextNode() throws XSLException {
        return this.contextNode;
    }

    XPathContext getXPathContext() {
        return this.jxContext;
    }

    void setXPathContext(XPathContext xPathContext) {
        this.jxContext = xPathContext;
    }

    @Override
    public int getContextSize() {
        return this.contextSize;
    }

    @Override
    public int getContextPosition() {
        return this.contextPos;
    }

    public void setVarResolver(XPathVariableResolver xPathVariableResolver) {
        this.varResolver = xPathVariableResolver;
    }

    public void setXMLSchema(XMLSchema xMLSchema) {
        this.schema = xMLSchema;
    }

    public XMLSchema getXMLSchema() {
        return this.schema;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public void setOXMLCollatorResolver(OXMLCollatorResolver oXMLCollatorResolver) {
        this.collatorResolver = oXMLCollatorResolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    protected Object getVariable(NSName nSName) {
        if (this.varResolver != null) {
            return this.varResolver.resolveVariable(new QName(nSName.getNamespace(), nSName.getLocalName()));
        }
        return null;
    }

    public OXMLSequence getVariable(NSName nSName, int n) {
        if (n >= 0) {
            return this.varValues[this.varValuesIndex - n];
        }
        return null;
    }

    public OXMLSequence getCurNodeList() {
        if (this.curNodeList == null) {
            this.curNodeList = new XPathSequence(this);
        }
        return this.curNodeList;
    }

    public OXMLSequence getAltNodeList() {
        if (this.altNodeList == null) {
            this.altNodeList = new XPathSequence(this);
        }
        return this.altNodeList;
    }

    @Override
    public OXMLSequence createSequence() {
        return new XPathSequence(this);
    }

    @Override
    public OXMLItem createItem() {
        return this.allocItem();
    }

    @Override
    public String getDBCharSet() {
        return null;
    }

    @Override
    public String getBaseURI() {
        if (this.baseUrl == null) {
            return null;
        }
        return this.baseUrl.toString();
    }

    @Override
    public String getDefaultCollation() {
        return this.defaultcollation;
    }

    public String setDefaultCollation(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint") && this.knownCollators.get(string) == null) continue;
            this.defaultcollation = string2;
            return string2;
        }
        return null;
    }

    @Override
    public String getInScopeNamespace(String string) {
        return null;
    }

    public String resolveNamespacePrefix(String string) {
        if (this.nsResolver != null) {
            return this.nsResolver.resolveNamespacePrefix(string);
        }
        return null;
    }

    public void setNSResolver(NSResolver nSResolver) {
        this.nsResolver = nSResolver;
    }

    @Override
    public GregorianCalendar getDateTime() {
        if (this.contextDateTime == null) {
            this.contextDateTime = new GregorianCalendar(contextTimeZone);
        }
        return this.contextDateTime;
    }

    @Override
    public TimeZone getImplicitTimezone() {
        return contextTimeZone;
    }

    @Override
    public OXMLItem getContextItem() {
        if (this.ctxForm == 1) {
            return this.contextItem;
        }
        this.contextItem = this.allocItem();
        if (this.ctxForm == 0) {
            this.contextItem.setNode(this.contextNode);
        } else if (this.ctxForm == 2) {
            this.contextNode = new BinaryNode(this.ctxIdx, this.binNav);
            this.contextItem.setNode(this.contextNode);
        }
        return this.contextItem;
    }

    public void setContextItem(OXMLItem oXMLItem) {
        this.contextItem = oXMLItem;
        this.ctxForm = 1;
    }

    @Override
    public void attachExternalObject(Object object) {
    }

    @Override
    public Object retrieveExternalObject() {
        return null;
    }

    public void init() {
        this.sourceContext.clear();
        this.knownDocs.clear();
        this.knownCollators.put(caseblindString, caseblindCollator);
        this.varValuesIndex = 0;
        this.valueStackIndex = -1;
        this.nsTable = null;
    }

    public void reset() {
        this.valueStackSize = 10;
        this.valueStackIndex = -1;
        this.valueStack = new XPathSequence[this.valueStackSize];
        for (int i = 0; i < this.valueStackSize; ++i) {
            this.valueStack[i] = new XPathSequence(this);
        }
        this.streamValues.clear();
        this.knownCollators.clear();
        if (this.curNodeList != null) {
            try {
                this.curNodeList.reset();
            }
            catch (XQException xQException) {
                // empty catch block
            }
        }
        if (this.altNodeList != null) {
            try {
                this.altNodeList.reset();
            }
            catch (XQException xQException) {
                // empty catch block
            }
        }
        if (this.cachedValues != null) {
            this.cachedValues.clear();
        }
        this.firstFreeItem = this.lastFreeItem = new XPathItem();
        this.firstFreeItem.setContext(this);
        this.currentNode = null;
        this.contextNode = null;
        this.contextDateTime = null;
        this.streaming = true;
        this.onlySourceContext = null;
        this.onlySrcRoot = null;
        this.curNodeList = null;
        this.altNodeList = null;
        this.numSourceContext = 0;
        this.init();
    }

    public OXMLSequence peekExprValue() {
        return this.valueStack[this.valueStackIndex];
    }

    public OXMLSequence peekExprValue(int n) {
        return this.valueStack[this.valueStackIndex - n];
    }

    public OXMLSequence popExprValue() {
        return this.valueStack[this.valueStackIndex--];
    }

    public void popExprValue(int n) {
        this.valueStackIndex -= n;
    }

    public OXMLSequence pushExprValue() {
        if (this.valueStackSize == ++this.valueStackIndex) {
            this.enlargeValueStackSize();
        }
        OXMLSequence oXMLSequence = this.valueStack[this.valueStackIndex];
        try {
            oXMLSequence.reset();
        }
        catch (XQException xQException) {
            // empty catch block
        }
        return oXMLSequence;
    }

    public void pushExprValue(OXMLSequence oXMLSequence) {
        ++this.valueStackIndex;
        if (this.valueStackSize == this.valueStackIndex) {
            this.enlargeValueStackSize();
        }
        if (oXMLSequence != this.valueStack[this.valueStackIndex]) {
            try {
                this.valueStack[this.valueStackIndex].reset();
            }
            catch (XQException xQException) {
                // empty catch block
            }
        }
        this.valueStack[this.valueStackIndex] = oXMLSequence;
    }

    public URL getBaseURL() {
        return this.baseUrl;
    }

    public void setBaseURL(URL uRL) {
        this.baseUrl = uRL;
    }

    protected XMLElement getSrcRoot(XMLNode xMLNode) {
        if (this.numSourceContext == 1) {
            return this.onlySrcRoot;
        }
        return xMLNode.getSrcRoot();
    }

    protected XMLElement getSrcRoot() throws XSLException {
        if (this.numSourceContext == 1) {
            return this.onlySrcRoot;
        }
        return this.contextNode.getSrcRoot();
    }

    public XSLSourceContext getSrcContext(XMLNode xMLNode) {
        if (this.numSourceContext == 1) {
            return this.onlySourceContext;
        }
        XMLElement xMLElement = xMLNode.getSrcRoot();
        if (xMLElement == null) {
            return null;
        }
        XSLSourceContext xSLSourceContext = (XSLSourceContext)this.sourceContext.get(xMLElement);
        if (xSLSourceContext != null) {
            return xSLSourceContext;
        }
        XMLDocument xMLDocument = xMLElement.getNodeType() == 9 ? (XMLDocument)xMLElement : (XMLDocument)xMLElement.getOwnerDocument();
        this.addSourceContext(xMLElement, xMLDocument);
        return (XSLSourceContext)this.sourceContext.get(xMLElement);
    }

    int compareDocument(XMLNode xMLNode, XMLNode xMLNode2) {
        if (xMLNode == xMLNode2) {
            return 0;
        }
        return this.getSrcContext(xMLNode).compareTo(this.getSrcContext(xMLNode2));
    }

    int compareDocOrder(XMLNode xMLNode, XMLNode xMLNode2) {
        int n = this.compareDocument(this.getSrcRoot(xMLNode), this.getSrcRoot(xMLNode2));
        if (n == 0) {
            return xMLNode.compareDocOrder(xMLNode2);
        }
        return n;
    }

    @Override
    public OXMLCollator getCollator(String string) {
        if (string == null || string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return OXMLCollator.CODE_POINT_COLLATOR;
        }
        OXMLCollator oXMLCollator = this.knownCollators.get(string);
        if (oXMLCollator == null) {
            if (this.collatorResolver != null) {
                oXMLCollator = this.collatorResolver.resolveCollator(string, this.getBaseURI());
            }
            if (oXMLCollator != null) {
                this.knownCollators.put(string, oXMLCollator);
            }
        }
        return oXMLCollator;
    }

    public XMLElement getDocument(String string) {
        return this.knownDocs.get(string);
    }

    public void addDocument(String string, XMLElement xMLElement) {
        this.knownDocs.put(string, xMLElement);
    }

    public void addSourceContext(XMLElement xMLElement, XMLDocument xMLDocument) {
        XSLSourceContext xSLSourceContext = new XSLSourceContext(xMLElement, xMLDocument);
        xSLSourceContext.setOrderId(this.numSourceContext);
        if (this.numSourceContext == 0) {
            this.onlySourceContext = xSLSourceContext;
            this.onlySrcRoot = xMLElement;
        }
        ++this.numSourceContext;
        this.sourceContext.put(xMLElement, xSLSourceContext);
    }

    public void setContextNode(XMLNode xMLNode) {
        this.contextNode = xMLNode;
        this.ctxForm = 0;
    }

    void setContextIndex(long l) {
        this.ctxIdx = l;
        this.ctxForm = 2;
    }

    public int setContextSize(int n) {
        int n2 = this.contextSize;
        this.contextSize = n;
        return n2;
    }

    public void setContextPosition(int n) {
        this.contextPos = n;
    }

    public void setCurrentNode(XMLNode xMLNode) {
        this.currentNode = xMLNode;
    }

    public XMLNode getCurrentNode() {
        return this.currentNode;
    }

    public void pushVariable(OXMLSequence oXMLSequence) {
        if (this.varValues == null) {
            this.varValues = new XPathSequence[256];
        }
        if (this.varValuesIndex == this.varValues.length) {
            XPathSequence[] xPathSequenceArray = new XPathSequence[this.varValues.length * 2];
            System.arraycopy(this.varValues, 0, xPathSequenceArray, 0, this.varValues.length);
            this.varValues = xPathSequenceArray;
        }
        this.varValues[this.varValuesIndex++] = (XPathSequence)oXMLSequence;
    }

    public void popVariable(int n) {
        this.varValuesIndex -= n;
    }

    public XMLNode[] getNSNodes(XMLElement xMLElement) {
        XSLNamespace xSLNamespace;
        XMLNode[] xMLNodeArray;
        if (this.nsTable == null) {
            this.nsTable = new Hashtable(20);
        }
        if ((xMLNodeArray = (XSLNamespace[])this.nsTable.get(xMLElement)) != null) {
            return xMLNodeArray;
        }
        String string = xMLElement.resolveNamespacePrefix("#default");
        Hashtable hashtable = xMLElement.getAllNamespaceAttrs();
        XMLDocument xMLDocument = xMLElement.getDocument();
        int n = hashtable.size() + 1;
        long l = (long)(xMLElement.getDocOrderId() + 1) << 32;
        int n2 = 0;
        if (string != null && !string.equals("")) {
            xMLNodeArray = new XSLNamespace[n + 1];
            xSLNamespace = new XSLNamespace(xMLDocument);
            xSLNamespace.init("", string, xMLElement);
            xSLNamespace.setNodeId(l);
            xMLNodeArray[n2++] = xSLNamespace;
        } else {
            xMLNodeArray = new XSLNamespace[n];
        }
        xSLNamespace = new XSLNamespace(xMLDocument);
        xSLNamespace.init("xml", "http://www.w3.org/XML/1998/namespace", xMLElement);
        xSLNamespace.setNodeId(l);
        xMLNodeArray[n2++] = xSLNamespace;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)hashtable.get(string2);
                xSLNamespace = new XSLNamespace(xMLDocument);
                xSLNamespace.init(string2, string3, xMLElement);
                xSLNamespace.setNodeId(l);
                xMLNodeArray[n2++] = xSLNamespace;
            }
        }
        this.nsTable.put(xMLElement, xMLNodeArray);
        return xMLNodeArray;
    }

    private int getFreeListLength() {
        int n = 0;
        XPathItem xPathItem = this.firstFreeItem;
        while (xPathItem != this.lastFreeItem) {
            ++n;
            xPathItem = xPathItem.nextItem;
        }
        return n;
    }

    public XPathItem allocItem() {
        if (this.firstFreeItem == this.lastFreeItem) {
            XPathItem xPathItem = new XPathItem();
            xPathItem.setContext(this);
            xPathItem.setCompatibilityFlags(this.version, this.bkwdCompFlag, this.fwdCompFlag);
            return xPathItem;
        }
        XPathItem xPathItem = this.firstFreeItem;
        xPathItem.setCompatibilityFlags(this.version, this.bkwdCompFlag, this.fwdCompFlag);
        this.firstFreeItem = this.firstFreeItem.nextItem;
        xPathItem.nextItem = null;
        xPathItem.prevItem = null;
        return xPathItem;
    }

    public void freeItem(XPathItem xPathItem) {
        this.lastFreeItem.nextItem = xPathItem;
        this.lastFreeItem = xPathItem;
    }

    public void freeItem(XPathItem xPathItem, XPathItem xPathItem2) {
        this.lastFreeItem.nextItem = xPathItem;
        this.lastFreeItem = xPathItem2;
    }

    public void cacheValue(XSLExprBase xSLExprBase, Object object) {
        if (this.cachedValues == null) {
            this.cachedValues = new HashMap();
        }
        this.cachedValues.put(xSLExprBase, object);
    }

    public Object getCachedValue(XSLExprBase xSLExprBase) {
        if (this.cachedValues == null) {
            return null;
        }
        return this.cachedValues.get(xSLExprBase);
    }

    private void enlargeValueStackSize() {
        int n = this.valueStackSize * 2;
        XPathSequence[] xPathSequenceArray = new XPathSequence[n];
        System.arraycopy(this.valueStack, 0, xPathSequenceArray, 0, this.valueStackSize);
        for (int i = this.valueStackSize; i < n; ++i) {
            xPathSequenceArray[i] = new XPathSequence(this);
        }
        this.valueStack = xPathSequenceArray;
        this.valueStackSize = n;
    }

    public void setCompatibilityFlags(int n, boolean bl, boolean bl2) {
        this.version = n;
        this.bkwdCompFlag = bl;
        this.fwdCompFlag = bl2;
    }

    public void setStreaming(boolean bl) {
        this.streaming = this.isDebugMode ? false : bl;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    StreamingSequence getStreamValue(XSLExprBase xSLExprBase) {
        return this.streamValues.get(xSLExprBase);
    }

    void saveStreamValue(XSLExprBase xSLExprBase, StreamingSequence streamingSequence) {
        this.streamValues.put(xSLExprBase, streamingSequence);
    }

    @Override
    public PageManagerPool getPageManagerPool() {
        return null;
    }

    public boolean isInDebugMode() {
        return this.isDebugMode;
    }

    public void setDebugMode(boolean bl) {
        this.isDebugMode = bl;
        if (bl) {
            this.streaming = false;
        }
    }

    void setCreateNode(boolean bl) {
        this.createNode = bl;
    }

    boolean getCreateNode() {
        return this.createNode;
    }

    void setEnableException(boolean bl) {
        this.enableException = bl;
    }

    boolean getEnableException() {
        return this.enableException;
    }

    static {
        caseblindString = "http://www.w3.org/xslts/collation/caseblind";
        contextTimeZone = TimeZone.getDefault();
    }

    static class CaseblindCollator
    extends OXMLCollator {
        CaseblindCollator() {
        }

        @Override
        public int compare(String string, String string2) {
            String string3 = string.toUpperCase();
            String string4 = string2.toUpperCase();
            int n = string3.length();
            int n2 = string4.length();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n && n4 < n2) {
                int n5;
                int n6 = string3.codePointAt(n3);
                if (n6 < (n5 = string4.codePointAt(n4))) {
                    return -1;
                }
                if (n6 > n5) {
                    return 1;
                }
                if (Character.isSupplementaryCodePoint(n6)) {
                    n3 += 2;
                    n4 += 2;
                    continue;
                }
                ++n3;
                ++n4;
            }
            if (n == n2) {
                return 0;
            }
            if (n < n2) {
                return -1;
            }
            return 1;
        }

        @Override
        public int match(String string, String string2, boolean bl) {
            String string3 = string.toUpperCase();
            String string4 = string2.toUpperCase();
            if (bl) {
                return string3.indexOf(string4);
            }
            return string3.lastIndexOf(string4);
        }
    }
}

