/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLDecoder;
import oracle.xml.binxml.BinXMLDecoderImpl;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLFormat;
import oracle.xml.binxml.BinXMLInfosetReader;
import oracle.xml.binxml.BinXMLMetadataProvider;
import oracle.xml.binxml.BinXMLNamespaceToken;
import oracle.xml.binxml.BinXMLOpcode;
import oracle.xml.binxml.BinXMLProcessorImpl;
import oracle.xml.binxml.BinXMLProperty;
import oracle.xml.binxml.BinXMLQNameToken;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLStreamImpl;
import oracle.xml.binxml.BinXMLTokenManager;
import oracle.xml.binxml.BinXMLUtil;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.binxml.BinXMLVocabularyManager;
import oracle.xml.binxml.DBBinXMLMetadataProviderImpl;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLLocator;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.util.XMLError;
import org.w3c.dom.Entity;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2Impl;

class BinXMLDecodeReader
implements BinXMLConstants,
XMLConstants {
    private BinXMLDecoderImpl decoder;
    private BinXMLTokenManager tokenMngr;
    BinXMLVocabularyManager vocabMngr;
    private BinXMLProcessorImpl binXMLProc;
    private BinXMLLocator binLocator;
    private long nsidxi;
    private long nsidnull;
    private DTD dtd;
    BinXMLStreamImpl binStream;
    ArrayList streamTable;
    Stack streamStack;
    int mark;
    int lastmark;
    ArrayList markMap;
    DecodeStream curStream;
    private static final int INFINITY = Integer.MAX_VALUE;
    ElemStack elemStack;
    Stack<BinXMLSchema> schemaStack;
    ArrayList nsStack;
    DecodeElem curElem;
    DecodeElem prevSibling;
    SAXAttrList attrlist;
    int pitgtlen;
    short state;
    byte event;
    int eventMark;
    BinXMLSchema schema;
    ArrayList schemaTable;
    ConcurrentHashMap<Short, PrefixInfo> prefixTable;
    ConcurrentHashMap<MutableLong, PrefixInfo> nsPrefixTable;
    short datastatus;
    short noseq;
    short opcode;
    BinXMLOpcode opinfo;
    long[] opdata;
    long datalen;
    byte datatype;
    String curValue;
    char[] curChars;
    char[] charbuf;
    short oldKidnum;
    boolean xmldecl;
    short prtOpcode;
    String prtBuf;
    String version = null;
    String standalone = null;
    String encoding = null;
    String client_encoding = null;
    String dtdName;
    String publicId;
    String systemId;
    String elemName;
    String contentSpec;
    String attrName;
    String attrType;
    String attrMode;
    String value;
    String entName;
    String notName;
    String parName;
    String piTarget;
    int attrCount;
    String[] attrNames;
    String[] attrTypes;
    String[] attrModes;
    String[] values;
    long locId;
    byte[] buf;
    int curBufLen;
    char[] spcTable;
    char[] crspcTable;
    char[] wsBuf;
    int dirtPos;
    boolean localDefs;
    ConcurrentHashMap<MutableLong, BinXMLQNameToken> qnTable;
    ConcurrentHashMap<MutableLong, String> nsTable;
    boolean seqId;
    Vector<BinXMLQNameToken> qnTableSeq;
    Vector<String> nsTableSeq;
    private static final int OFFSET_HOUR = 20;
    private static final int OFFSET_MINUTE = 60;
    private static final byte REGIONIDBIT = -128;
    static final short SELFMODE = 0;
    static final short ARRMODE = 1;
    static final short SEQMODE = 2;
    static final short SELFSTRMMODE = 4;
    static final short STRMMODE = 4;
    static final short OPTMODE = 8;
    static final short KIDMODE = 16;
    static final short ARRNEXTMODE = 32;
    static final short TYPEID = 256;
    static final short ARRSEQMODE = 3;
    static final short OPTSEQMODE = 10;
    static final short ARRNEXTSEQMODE = 34;
    static final short ARRKIDMODE = 17;
    static final short LOCF_SCHPRP = 1;
    static final short LOCF_QNAMEID = 2;
    static final short LOCF_DATA = 4;
    static final short LOCF_TEXT = 8;
    static final short LOCF_INARR = 16;
    static final short LOCF_INSCHSEQ = 32;
    static final short LOCF_SCHSEQ = 64;
    static final short LOCF_NOTDECTYP = 128;
    static final short LOCF_IMPTYP = 256;
    static final short LOCF_PFXID = 512;
    static final short LOCF_TWOBYTE = 1024;
    static final short LOCF_FOURBYTE = 2048;
    static final short LOCF_DOC = 4096;
    static final byte EVENT_DTDSTART = 100;
    static final byte EVENT_ELEMDECL = 101;
    static final byte EVENT_ATTRDECL = 102;
    static final byte EVENT_INT_ENTDECL = 103;
    static final byte EVENT_UNPAR_ENTDECL = 104;
    static final byte EVENT_EXT_ENTDECL = 105;
    static final byte EVENT_PARDECL = 106;
    static final byte EVENT_NOTDECL = 107;
    static final byte EVENT_DTDEND = 108;
    static final byte EVENT_NOOP = 99;
    static final byte EVENT_ERROR = -1;
    static final short STATE_ZERO = 1;
    static final short STATE_START_ELEM_OPT = 2;
    static final short STATE_CHARS_OPT = 3;
    static final short STATE_CHARS_LOC = 4;
    static final short STATE_PRT = 5;
    static final short LENGTH_DATA = 2;
    static final short DATA_ONLY = 1;
    static final short NO_DATA = 0;
    static final short NOOP = 255;
    static final int HDR_RGUID_LEN = 16;
    static final byte CSX_MAX_SCHID_LEN = 16;
    static final byte CSX_MAX_PFX_LEN = 100;
    static final byte CSX_DEFQNF_ATTR = 1;
    private static final int originalSize = 128;
    BinXMLVocabId vocabId = new BinXMLVocabId();
    boolean isExtendedOpcode = false;
    MutableLong mutableLong = new MutableLong(0L);
    boolean printInst = false;
    boolean printStacks = false;
    boolean printLocator = false;
    XMLError err;
    private static HashMap<Short, String> reservedPrefixTable = null;
    private static HashMap<Long, String> reservedNSPrefixTable = null;
    private static HashMap<Short, String> reservedNSTable = null;

    BinXMLDecodeReader(BinXMLStreamImpl binXMLStreamImpl, BinXMLDecoderImpl binXMLDecoderImpl) throws BinXMLException {
        this.binStream = binXMLStreamImpl;
        this.decoder = binXMLDecoderImpl;
        this.binLocator = new BinXMLLocator();
        this.err = binXMLDecoderImpl.getXMLError();
        this.init(true);
    }

    BinXMLDecodeReader(BinXMLStreamImpl binXMLStreamImpl, BinXMLDecoderImpl binXMLDecoderImpl, boolean bl) throws BinXMLException {
        this.binStream = binXMLStreamImpl;
        this.decoder = binXMLDecoderImpl;
        this.binLocator = new BinXMLLocator();
        this.err = binXMLDecoderImpl.getXMLError();
        this.init(bl);
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
    }

    protected BinXMLInfosetReader getReader() {
        Object object;
        int n;
        BinXMLInfosetReader binXMLInfosetReader;
        try {
            binXMLInfosetReader = new BinXMLInfosetReader(this.binStream, this.decoder, false);
        }
        catch (BinXMLException binXMLException) {
            return null;
        }
        binXMLInfosetReader.curStream.copy(this.curStream);
        binXMLInfosetReader.streamTable.clear();
        binXMLInfosetReader.streamTable.add(binXMLInfosetReader.curStream);
        binXMLInfosetReader.streamStack.clear();
        binXMLInfosetReader.streamStack.push(binXMLInfosetReader.curStream);
        binXMLInfosetReader.markMap.clear();
        for (n = 0; n < this.markMap.size(); ++n) {
            object = (MarkInfo)this.markMap.get(n);
            binXMLInfosetReader.markMap.add((MarkInfo)((MarkInfo)object).clone());
        }
        binXMLInfosetReader.nsStack.clear();
        for (n = 0; n < this.nsStack.size(); ++n) {
            object = (PrefixInfo)this.nsStack.get(n);
            binXMLInfosetReader.nsStack.add(((PrefixInfo)object).clone());
        }
        binXMLInfosetReader.elemStack.copy(this.elemStack);
        for (n = 0; n < 10; ++n) {
            binXMLInfosetReader.opdata[n] = this.opdata[n];
        }
        binXMLInfosetReader.schemaStack.clear();
        for (n = 0; n < this.schemaStack.size(); ++n) {
            binXMLInfosetReader.schemaStack.add(this.schemaStack.get(n));
        }
        n = this.charbuf.length;
        if (binXMLInfosetReader.charbuf.length < n) {
            binXMLInfosetReader.charbuf = new char[n];
        }
        for (int i = 0; i < n; ++i) {
            binXMLInfosetReader.charbuf[i] = this.charbuf[i];
        }
        binXMLInfosetReader.localDefs = this.localDefs;
        binXMLInfosetReader.seqId = this.seqId;
        binXMLInfosetReader.nsTableSeq = this.nsTableSeq;
        binXMLInfosetReader.qnTableSeq = this.qnTableSeq;
        binXMLInfosetReader.nsTable = this.nsTable;
        binXMLInfosetReader.qnTable = this.qnTable;
        binXMLInfosetReader.attrlist.copy(this.attrlist);
        binXMLInfosetReader.curChars = this.curChars;
        binXMLInfosetReader.datalen = this.datalen;
        binXMLInfosetReader.curElem = this.curElem != null ? (DecodeElem)this.curElem.clone() : null;
        binXMLInfosetReader.prevSibling = this.prevSibling != null ? (DecodeElem)this.prevSibling.clone() : null;
        binXMLInfosetReader.pitgtlen = this.pitgtlen;
        binXMLInfosetReader.state = this.state;
        binXMLInfosetReader.event = this.event;
        binXMLInfosetReader.eventMark = this.eventMark;
        binXMLInfosetReader.schema = this.schema;
        binXMLInfosetReader.datastatus = this.datastatus;
        binXMLInfosetReader.schemaTable = binXMLInfosetReader.curStream.schemaTable;
        binXMLInfosetReader.prefixTable = binXMLInfosetReader.curStream.prefixTable;
        binXMLInfosetReader.nsPrefixTable = binXMLInfosetReader.curStream.nsPrefixTable;
        binXMLInfosetReader.opcode = this.opcode;
        binXMLInfosetReader.opinfo = this.opinfo;
        binXMLInfosetReader.datatype = this.datatype;
        binXMLInfosetReader.curValue = this.curValue;
        binXMLInfosetReader.oldKidnum = this.oldKidnum;
        binXMLInfosetReader.prtOpcode = this.prtOpcode;
        binXMLInfosetReader.prtBuf = this.prtBuf;
        binXMLInfosetReader.version = this.version;
        binXMLInfosetReader.standalone = this.standalone;
        binXMLInfosetReader.encoding = this.encoding;
        binXMLInfosetReader.dtdName = this.dtdName;
        binXMLInfosetReader.publicId = this.publicId;
        binXMLInfosetReader.systemId = this.systemId;
        binXMLInfosetReader.elemName = this.elemName;
        binXMLInfosetReader.contentSpec = this.contentSpec;
        binXMLInfosetReader.attrName = this.attrName;
        binXMLInfosetReader.attrType = this.attrType;
        binXMLInfosetReader.attrMode = this.attrMode;
        binXMLInfosetReader.value = this.value;
        binXMLInfosetReader.entName = this.entName;
        binXMLInfosetReader.notName = this.notName;
        binXMLInfosetReader.parName = this.parName;
        binXMLInfosetReader.piTarget = this.piTarget;
        binXMLInfosetReader.locId = this.locId;
        return binXMLInfosetReader;
    }

    void init(boolean bl) throws BinXMLException {
        this.binXMLProc = (BinXMLProcessorImpl)this.binStream.getBinXMLProcessor();
        this.vocabMngr = this.binXMLProc.getVocabularyManager();
        this.tokenMngr = this.binXMLProc.getTokenManager(this.decoder.rguid);
        this.streamTable = new ArrayList(5);
        this.streamStack = new Stack();
        this.markMap = new ArrayList(10);
        this.nsStack = new ArrayList(20);
        this.opdata = new long[10];
        this.curBufLen = 128;
        this.buf = new byte[this.curBufLen];
        this.elemStack = new ElemStack();
        this.schemaStack = new Stack();
        this.lastmark = 0;
        this.locId = 0L;
        this.attrlist = new SAXAttrList(100);
        this.charbuf = new char[1024];
        this.initSpaceTables();
        if (bl) {
            this.initLocal();
        }
        this.reset();
        if (this.binXMLProc.getDebugMode()) {
            this.printInst = true;
            this.printStacks = true;
            this.printLocator = true;
        }
        long l = this.tokenMngr.getNamespaceTokenId(null);
        BinXMLNamespaceToken binXMLNamespaceToken = this.tokenMngr.getNamespaceToken(l);
        this.nsidnull = binXMLNamespaceToken.getTokenId();
        l = this.tokenMngr.getNamespaceTokenId("http://www.w3.org/2001/XInclude");
        binXMLNamespaceToken = this.tokenMngr.getNamespaceToken(l);
        this.nsidxi = binXMLNamespaceToken.getTokenId();
    }

    void setDecoder(BinXMLDecoder binXMLDecoder) {
        this.decoder = (BinXMLDecoderImpl)binXMLDecoder;
    }

    long readBytes(byte[] byArray, long l) throws BinXMLException {
        return this.curStream.readBytes(byArray, l);
    }

    long skipBytes(long l) throws BinXMLException {
        return this.curStream.skipBytes(l);
    }

    long readBytes(BinXMLStreamImpl binXMLStreamImpl, byte[] byArray, long l) throws BinXMLException {
        return this.readBytes(byArray, l);
    }

    long skipBytes(BinXMLStreamImpl binXMLStreamImpl, long l) throws BinXMLException {
        return this.skipBytes(l);
    }

    short nextByte() throws BinXMLException {
        if (this.datastatus != 0) {
            this.getEventText(null);
        }
        DecodeStream decodeStream = this.nextDecodeStream();
        return decodeStream.nextByte();
    }

    short nextByte2() throws BinXMLException {
        DecodeStream decodeStream = this.nextDecodeStream();
        return decodeStream.nextByte2();
    }

    DecodeStream getDecodeStream(byte by) throws BinXMLException {
        for (int i = 0; i < this.streamTable.size(); ++i) {
            DecodeStream decodeStream = (DecodeStream)this.streamTable.get(i);
            if (decodeStream.id != by) continue;
            return decodeStream;
        }
        return null;
    }

    DecodeStream getDecodeStream(String string) throws BinXMLException {
        for (int i = 0; i < this.streamTable.size(); ++i) {
            DecodeStream decodeStream = (DecodeStream)this.streamTable.get(i);
            if (decodeStream.href == null || !decodeStream.href.equals(string)) continue;
            return decodeStream;
        }
        return this.createStream(string);
    }

    DecodeStream nextDecodeStream() throws BinXMLException {
        if (this.curElem.streamId == this.elemStack.peek().streamId) {
            return this.curStream;
        }
        return this.getDecodeStream(this.elemStack.peek().streamId);
    }

    BinXMLStream getStream(byte by) throws BinXMLException {
        for (int i = 0; i < this.streamTable.size(); ++i) {
            DecodeStream decodeStream = (DecodeStream)this.streamTable.get(i);
            if (decodeStream.id != by) continue;
            return decodeStream.stream;
        }
        throw new BinXMLException(this.err.getMessage0(35000));
    }

    DecodeStream createStream(String string) throws BinXMLException {
        DecodeStream decodeStream = string != null ? new DecodeStream(string, (byte)this.streamTable.size()) : new DecodeStream(this.binStream, (byte)this.streamTable.size());
        this.streamTable.add(decodeStream);
        return decodeStream;
    }

    void activateStream(DecodeStream decodeStream, int n) {
        this.curStream = decodeStream;
        if (n >= 0) {
            decodeStream.setLMark(n);
        }
        this.schemaTable = decodeStream.schemaTable;
        this.prefixTable = decodeStream.prefixTable;
        this.nsPrefixTable = decodeStream.nsPrefixTable;
        this.datastatus = 0;
        this.state = 1;
    }

    void pushStream(byte by) throws BinXMLException {
        int n;
        int n2 = n = this.curStream != null && this.curStream.ladata > 0 ? this.curStream.ladata : this.mark;
        if (by > 0) {
            this.updateMarkMapEndMark(this.curStream.id, this.lastmark);
        }
        this.appendMarkMap(by, 0, n);
        DecodeStream decodeStream = this.getDecodeStream(by);
        this.streamStack.add(decodeStream);
        this.activateStream(decodeStream, 0);
    }

    void pushStream(byte by, int n) throws BinXMLException {
        DecodeStream decodeStream = this.getDecodeStream(by);
        this.streamStack.add(decodeStream);
        this.activateStream(decodeStream, n);
    }

    void popStream() throws BinXMLException {
        if (this.streamStack.size() < 1) {
            throw new BinXMLException(this.err.getMessage0(35000));
        }
        this.updateMarkMapEndMark(this.curStream.id, this.eventMark);
        this.streamStack.pop();
        DecodeStream decodeStream = (DecodeStream)this.streamStack.peek();
        this.activateStream(decodeStream, -1);
        this.appendMarkMap(decodeStream.id, this.curStream.getLMark(), this.mark);
    }

    byte pushStreamMark(int n) throws BinXMLException {
        for (int i = 0; i < this.markMap.size(); ++i) {
            MarkInfo markInfo = (MarkInfo)this.markMap.get(i);
            if (markInfo.endmark < n) continue;
            int n2 = markInfo.lmark + (n - markInfo.gmark);
            this.pushStream(markInfo.id, n2);
            return markInfo.id;
        }
        return 0;
    }

    byte pushStreamParentMark(byte by, int n) throws BinXMLException {
        int n2;
        MarkInfo markInfo;
        int n3;
        for (n3 = 0; n3 < this.markMap.size(); ++n3) {
            markInfo = (MarkInfo)this.markMap.get(n3);
            if (markInfo.endmark >= n) break;
        }
        if ((n2 = n3 + 1) < this.markMap.size()) {
            while (n2 < this.markMap.size()) {
                markInfo = (MarkInfo)this.markMap.get(n2);
                if (markInfo.id == by) {
                    this.pushStream(markInfo.id, markInfo.lmark);
                    break;
                }
                ++n2;
            }
        } else {
            markInfo = (MarkInfo)this.markMap.get(n2 - 2);
            this.pushStream(markInfo.id, markInfo.endmark - markInfo.lmark);
        }
        return by;
    }

    void appendMarkMap(byte by, int n, int n2) {
        if (this.markMap.size() > 0) {
            MarkInfo markInfo = (MarkInfo)this.markMap.get(this.markMap.size() - 1);
            if (markInfo.endmark > n2) {
                return;
            }
        }
        this.markMap.add(new MarkInfo(by, n, n2));
    }

    void updateMarkMapEndMark(byte by, int n) {
        MarkInfo markInfo = (MarkInfo)this.markMap.get(this.markMap.size() - 1);
        if (markInfo.id == by && markInfo.gmark < n) {
            markInfo.endmark = n;
        }
    }

    void updateMarkMapLMark(byte by, int n) {
        MarkInfo markInfo = (MarkInfo)this.markMap.get(this.markMap.size() - 1);
        if (markInfo.id == by && markInfo.lmark < n) {
            markInfo.lmark = n;
        }
    }

    int getLMark(int n) {
        int n2 = n;
        for (int i = 0; i < this.markMap.size(); ++i) {
            MarkInfo markInfo = (MarkInfo)this.markMap.get(i);
            if (markInfo.gmark > n || markInfo.gmark < 0) break;
            n2 = markInfo.lmark + (n - markInfo.gmark);
        }
        return n2;
    }

    void printMarkMap() {
        System.out.println("MarkMap");
        for (int i = 0; i < this.markMap.size(); ++i) {
            MarkInfo markInfo = (MarkInfo)this.markMap.get(i);
            System.out.println(markInfo.id + ", " + markInfo.lmark + "' " + markInfo.gmark + "-" + markInfo.endmark);
        }
    }

    void decode(ContentHandler contentHandler, ErrorHandler errorHandler) throws BinXMLException {
        boolean bl = false;
        this.xmldecl = false;
        block22: while (!bl) {
            try {
                switch (this.getNextEvent(false)) {
                    case 7: {
                        if (this.xmldecl) {
                            contentHandler.setDocumentLocator(this.binLocator);
                        }
                        contentHandler.startDocument();
                        continue block22;
                    }
                    case 8: {
                        contentHandler.endDocument();
                        bl = true;
                        continue block22;
                    }
                    case 1: {
                        contentHandler.startElement(this.getEventURI(), this.getEventLocalName(), this.getEventName(), this.getEventAttrList());
                        continue block22;
                    }
                    case 2: {
                        contentHandler.endElement(this.getEventURI(), this.getEventLocalName(), this.getEventName());
                        continue block22;
                    }
                    case 4: {
                        char[] cArray = this.getEventChars();
                        if (this.datalen == 0L) continue block22;
                        contentHandler.characters(cArray, 0, (int)this.datalen);
                        continue block22;
                    }
                    case 3: {
                        contentHandler.processingInstruction(this.piTarget, this.value);
                        continue block22;
                    }
                    case 5: {
                        if (this.decoder.lexHdlr == null) continue block22;
                        this.decoder.lexHdlr.comment(this.value.toCharArray(), 0, this.value.length());
                        continue block22;
                    }
                    case 12: {
                        if (this.decoder.lexHdlr != null) {
                            this.decoder.lexHdlr.startCDATA();
                        }
                        contentHandler.characters(this.value.toCharArray(), 0, this.value.length());
                        if (this.decoder.lexHdlr == null) continue block22;
                        this.decoder.lexHdlr.endCDATA();
                        continue block22;
                    }
                    case 9: {
                        contentHandler.characters(this.value.toCharArray(), 0, this.value.length());
                        continue block22;
                    }
                    case 100: {
                        if (this.decoder.lexHdlr == null) continue block22;
                        this.decoder.lexHdlr.startDTD(this.dtdName, this.publicId, this.systemId);
                        continue block22;
                    }
                    case 101: {
                        if (this.decoder.decHdlr == null) continue block22;
                        this.decoder.decHdlr.elementDecl(this.elemName, this.contentSpec);
                        continue block22;
                    }
                    case 102: {
                        if (this.decoder.decHdlr == null) continue block22;
                        if (this.attrCount > 0) {
                            for (int i = 0; i < this.attrCount; ++i) {
                                this.decoder.decHdlr.attributeDecl(this.elemName, this.attrNames[i], this.attrTypes[i], this.attrModes[i], this.values[i]);
                            }
                            this.attrCount = 0;
                            continue block22;
                        }
                        this.decoder.decHdlr.attributeDecl(this.elemName, this.attrName, this.attrType, this.attrMode, this.value);
                        continue block22;
                    }
                    case 103: {
                        if (this.decoder.decHdlr == null) continue block22;
                        this.decoder.decHdlr.internalEntityDecl(this.entName, this.value);
                        continue block22;
                    }
                    case 104: {
                        if (this.decoder.dtdHdlr == null) continue block22;
                        this.decoder.dtdHdlr.unparsedEntityDecl(this.entName, this.publicId, this.systemId, this.notName);
                        continue block22;
                    }
                    case 105: {
                        if (this.decoder.decHdlr == null) continue block22;
                        this.decoder.decHdlr.externalEntityDecl(this.entName, this.publicId, this.systemId);
                        continue block22;
                    }
                    case 106: {
                        continue block22;
                    }
                    case 107: {
                        if (this.decoder.dtdHdlr == null) continue block22;
                        this.decoder.dtdHdlr.notationDecl(this.notName, this.publicId, this.systemId);
                        continue block22;
                    }
                    case 108: {
                        if (this.decoder.lexHdlr == null) continue block22;
                        this.decoder.lexHdlr.endDTD();
                        continue block22;
                    }
                }
                this.err.error0(36005, 1);
                throw new BinXMLException(this.err.getMessage0(36005));
            }
            catch (SAXException sAXException) {
                throw new BinXMLException(sAXException.getMessage());
            }
        }
    }

    void decode(ContentHandler contentHandler, ErrorHandler errorHandler, String string) throws BinXMLException {
        this.client_encoding = string;
        this.decode(contentHandler, errorHandler);
    }

    void skipNode() throws BinXMLException {
        if (this.event == 1) {
            int n = 1;
            block4: while (n > 0) {
                this.event = this.getNextEvent(true);
                switch (this.event) {
                    case 1: {
                        ++n;
                        continue block4;
                    }
                    case 2: {
                        --n;
                        continue block4;
                    }
                }
            }
        } else if (this.event != 4 && this.event != 3 && this.event != 5) {
            throw new BinXMLException(this.err.getMessage0(35000));
        }
    }

    byte getNextEvent(boolean bl) throws BinXMLException {
        if (this.state == 2) {
            this.state = (short)3;
            long l = this.getDataLen();
            if (l != 0L) {
                return 4;
            }
        }
        if (this.state == 3) {
            this.popElem();
            this.state = 1;
            return 2;
        }
        if (this.state == 4) {
            this.state = 1;
            this.popStream();
        }
        do {
            this.event = this.getNext(bl);
            if (this.event != 1) continue;
            this.event = this.checkOraXInclude();
        } while (this.event == 99);
        if (this.printStacks) {
            this.elemStack.print();
        }
        return this.event;
    }

    private byte checkOraXInclude() throws BinXMLException {
        if (this.curElem.nsid == this.nsidxi && this.curElem.local.equals("include") && this.attrlist.getLength() != 0) {
            String string = null;
            String string2 = null;
            int n = this.attrlist.getLength();
            for (int i = 0; i < n; ++i) {
                String string3 = this.attrlist.getLocalName(i);
                String string4 = this.attrlist.getValue(i);
                if (string3.equals("xpointer")) {
                    if (!string4.startsWith("ora:csxloc")) continue;
                    string = string4.substring(11, string4.length() - 1);
                    continue;
                }
                if (!string3.equals("href")) continue;
                string2 = string4;
            }
            if (string2 != null && string != null) {
                this.processXInclude(string2, string);
                this.event = (byte)99;
            }
        }
        return this.event;
    }

    private void processXInclude(String string, String string2) throws BinXMLException {
        while (this.event != 2) {
            this.event = this.getNext(false);
        }
        try {
            DecodeStream decodeStream = this.getDecodeStream(string);
            this.pushStream(decodeStream.id);
            String[] stringArray = string2.split(",");
            this.skipOffsetCSXData(Integer.parseInt(stringArray[1]));
            switch (stringArray[0].charAt(0)) {
                case 'A': {
                    this.locId = Long.parseLong(stringArray[2]);
                    this.curStream.locator = string2;
                    break;
                }
                case 'S': {
                    this.vocabId.setVocabID(stringArray[3].getBytes());
                    this.schema = this.vocabMngr.getBinXMLSchema(this.vocabId);
                    this.addSchema(this.schema);
                    this.pushSchema(this.schema);
                    this.locId = Long.parseLong(stringArray[2]);
                    this.curStream.locator = string2;
                    break;
                }
                case 'T': {
                    this.locId = 1L;
                    this.curStream.locator = string2;
                    break;
                }
                case 'E': {
                    this.locId = 0L;
                }
            }
        }
        catch (Exception exception) {
            throw new BinXMLException(exception.getMessage());
        }
    }

    private void skipOffsetCSXData(int n) throws BinXMLException {
        block6: while (this.curStream.getLMark() < n) {
            short s = this.nextCSXInstr();
            switch (s) {
                case 159: {
                    this.readSectionHeader(s);
                    continue block6;
                }
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    long l = this.getdatalen(s);
                    String string = this.curStream.readString((int)l);
                    if (this.mark != this.lastmark) continue block6;
                    long l2 = this.opdata[1];
                    this.registerNamespace(l2, string);
                    continue block6;
                }
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: {
                    long l = this.getdatalen(s);
                    String string = this.curStream.readString((int)l);
                    if (this.mark != this.lastmark) continue block6;
                    long l3 = this.opdata[2];
                    long l2 = this.opdata[3];
                    boolean bl = ((int)this.opdata[1] & 1) > 0;
                    this.registerTokenId(l3, string, l2, bl);
                    continue block6;
                }
                case 178: 
                case 179: {
                    long l = this.getdatalen(s);
                    String string = this.curStream.readString((int)l);
                    long l3 = this.opdata[2];
                    long l2 = this.opdata[1];
                    this.addPrefix((short)l3, string, l2);
                    continue block6;
                }
            }
            long l = this.getdatalen(s);
            if (l <= 0L) continue;
            this.curStream.readString((int)l);
        }
    }

    protected byte getNext(boolean bl) throws BinXMLException {
        if (this.datastatus != 0) {
            this.skipData();
        }
        this.eventMark = this.mark;
        this.curValue = null;
        this.curChars = null;
        if (this.state != 5) {
            this.prtBuf = null;
        }
        this.attrlist.reset();
        if (this.elemStack.empty()) {
            throw new BinXMLException(this.err.getMessage0(35000));
        }
        this.oldKidnum = this.elemStack.peek().kidnum;
        short s = this.nextCSXInstr();
        if (this.noseq > 0) {
            this.noseq = (short)(this.noseq - 1);
        }
        if (s < 174 && !this.isExtendedOpcode) {
            switch (s) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 143: {
                    this.datastatus = (short)2;
                    if (this.state == 5) {
                        if (this.prtOpcode != 228) {
                            throw new BinXMLException(this.err.getMessage0(35000));
                        }
                        this.state = 1;
                        if (bl) {
                            this.skipData();
                        } else {
                            this.getEventText(null);
                            this.curValue = this.prtBuf + this.curValue;
                        }
                        return 4;
                    }
                    DecodeElem decodeElem = this.peekElem();
                    if (this.locId > 0L) {
                        if (this.locId == 1L) {
                            this.locId = 0L;
                            this.state = (short)4;
                            return 4;
                        }
                        long l = this.locId;
                        this.locId = 0L;
                        DecodeElem decodeElem2 = this.getDecodeElem(l);
                        decodeElem2.setPrefix(null);
                        this.pushElem(decodeElem2);
                        this.state = (short)2;
                        return 1;
                    }
                    if (decodeElem.isArrMode()) {
                        DecodeElem decodeElem3 = this.elemStack.getNew(this.curElem);
                        this.pushElem(decodeElem3);
                        this.state = (short)2;
                        return 1;
                    }
                    if (decodeElem.isSeqMode() && this.noseq == 0) {
                        decodeElem.kidnum = (short)(decodeElem.kidnum + 1);
                        DecodeElem decodeElem4 = this.getDecodeElem(this.schema, decodeElem.prop, decodeElem.kidnum);
                        decodeElem4.setPrefix(null);
                        this.pushElem(decodeElem4);
                        this.state = (short)2;
                        return 1;
                    }
                    this.state = 1;
                    return 4;
                }
                case 144: {
                    DecodeElem decodeElem = this.peekElem();
                    if (!decodeElem.isSeqMode()) {
                        throw new BinXMLException(this.err.getMessage0(35000));
                    }
                    decodeElem.kidnum = (short)(decodeElem.kidnum + 1);
                    return 99;
                }
                case 145: 
                case 146: 
                case 147: {
                    long l = this.opdata[0];
                    byte[] byArray = new byte[(int)l];
                    this.readBytes(byArray, (int)l);
                    this.schema = this.vocabMngr.getBinXMLSchema(byArray);
                    this.addSchema(this.schema);
                    this.pushSchema(this.schema);
                    return 99;
                }
                case 148: {
                    this.schema = this.popSchema();
                    return 99;
                }
                case 149: {
                    short s2 = this.readNum2();
                    this.dtdName = s2 > 0 ? this.curStream.readString(s2) : null;
                    s2 = this.readNum2();
                    this.publicId = s2 > 0 ? this.curStream.readString(s2) : null;
                    s2 = this.readNum2();
                    String string = this.systemId = s2 > 0 ? this.curStream.readString(s2) : null;
                    if (this.systemId == null) {
                        return 100;
                    }
                    BinXMLMetadataProvider binXMLMetadataProvider = this.tokenMngr.metaProvider;
                    if (binXMLMetadataProvider == null) {
                        return 100;
                    }
                    if (!(binXMLMetadataProvider instanceof DBBinXMLMetadataProviderImpl)) {
                        throw new BinXMLException(this.err.getMessage0(35000));
                    }
                    DBBinXMLMetadataProviderImpl dBBinXMLMetadataProviderImpl = (DBBinXMLMetadataProviderImpl)binXMLMetadataProvider;
                    String string2 = dBBinXMLMetadataProviderImpl.getResource(this.systemId);
                    if (string2 == null) {
                        String string3 = this.err.getMessage1(20112, this.systemId);
                        throw new BinXMLException(string3);
                    }
                    DOMParser dOMParser = new DOMParser();
                    StringReader stringReader = new StringReader(string2);
                    try {
                        dOMParser.parseDTD(stringReader, this.dtdName);
                    }
                    catch (XMLParseException xMLParseException) {
                        throw new BinXMLException(xMLParseException);
                    }
                    catch (SAXException sAXException) {
                        throw new BinXMLException(sAXException);
                    }
                    catch (IOException iOException) {
                        throw new BinXMLException(iOException);
                    }
                    this.dtd = dOMParser.getDoctype();
                    return 100;
                }
                case 150: {
                    short s3 = this.readNum2();
                    this.elemName = s3 > 0 ? this.curStream.readString(s3) : null;
                    s3 = this.readNum2();
                    this.contentSpec = s3 > 0 ? this.curStream.readString(s3) : null;
                    return 101;
                }
                case 151: {
                    short s4 = this.readNum2();
                    this.elemName = s4 > 0 ? this.curStream.readString(s4) : null;
                    s4 = this.readNum2();
                    this.attrName = s4 > 0 ? this.curStream.readString(s4) : null;
                    s4 = this.readNum2();
                    this.attrType = s4 > 0 ? this.curStream.readString(s4) : null;
                    this.splitAttrString(this.attrType);
                    return 102;
                }
                case 152: {
                    short s5 = this.readNum2();
                    this.entName = s5 > 0 ? this.curStream.readString(s5) : null;
                    s5 = this.readNum2();
                    this.value = s5 > 0 ? this.curStream.readString(s5) : null;
                    s5 = this.readNum2();
                    this.publicId = s5 > 0 ? this.curStream.readString(s5) : null;
                    s5 = this.readNum2();
                    this.systemId = s5 > 0 ? this.curStream.readString(s5) : null;
                    s5 = this.readNum2();
                    String string = this.notName = s5 > 0 ? this.curStream.readString(s5) : null;
                    if (this.value != null) {
                        return 103;
                    }
                    if (this.notName != null) {
                        return 104;
                    }
                    return 105;
                }
                case 153: {
                    short s6 = this.readNum2();
                    this.parName = s6 > 0 ? this.curStream.readString(s6) : null;
                    s6 = this.readNum2();
                    this.publicId = s6 > 0 ? this.curStream.readString(s6) : null;
                    s6 = this.readNum2();
                    this.systemId = s6 > 0 ? this.curStream.readString(s6) : null;
                    return 106;
                }
                case 154: {
                    short s7 = this.readNum2();
                    this.notName = s7 > 0 ? this.curStream.readString(s7) : null;
                    s7 = this.readNum2();
                    this.publicId = s7 > 0 ? this.curStream.readString(s7) : null;
                    s7 = this.readNum2();
                    this.systemId = s7 > 0 ? this.curStream.readString(s7) : null;
                    return 107;
                }
                case 155: {
                    return 108;
                }
                case 156: {
                    short s8 = this.readNum1();
                    String string = this.curStream.readString(s8);
                    if (this.dtd == null) {
                        String string4 = this.err.getMessage1(20250, string);
                        throw new BinXMLException(string4);
                    }
                    Entity entity = this.dtd.findEntity(string, false);
                    if (entity == null) {
                        String string5 = this.err.getMessage1(20250, string);
                        throw new BinXMLException(string5);
                    }
                    this.value = entity.getNodeValue();
                    return 9;
                }
                case 157: {
                    return 99;
                }
                case 158: {
                    int n = (int)this.opdata[1];
                    this.version = null;
                    this.standalone = null;
                    this.encoding = null;
                    this.xmldecl = false;
                    if ((n & 2) > 0) {
                        this.xmldecl = true;
                        this.version = (n & 8) > 0 ? ((n & 0xFF00) > 0 ? "1.1" : "1.0") : "1.0";
                        if ((n & 1) > 0) {
                            String string = this.standalone = (n & 0x10) > 0 ? "yes" : "no";
                        }
                        if ((n & 4) > 0) {
                            long l = (int)this.opdata[0];
                            this.encoding = this.curStream.readString((int)l);
                        }
                        this.binLocator.setXMLVersion(this.version);
                        if (this.client_encoding != null) {
                            this.binLocator.setEncoding(this.client_encoding);
                        } else {
                            this.binLocator.setEncoding(this.encoding);
                        }
                        this.binLocator.setStandalone(this.standalone);
                    } else {
                        if (this.opdata[0] > 0L) {
                            long l = (int)this.opdata[0];
                            this.curStream.readString((int)l);
                        }
                        if (this.client_encoding != null) {
                            this.binLocator.setEncoding(this.client_encoding);
                            this.xmldecl = true;
                        }
                    }
                    return 7;
                }
                case 159: {
                    this.readSectionHeader(s);
                    return 99;
                }
                case 160: {
                    return 8;
                }
                case 161: {
                    return 99;
                }
                case 162: {
                    return 99;
                }
                case 163: 
                case 164: 
                case 165: {
                    if (this.state == 5) {
                        if (this.prtOpcode != 230) {
                            throw new BinXMLException(this.err.getMessage0(35000));
                        }
                        this.state = 1;
                        if (bl) {
                            this.datastatus = (short)2;
                            this.skipData();
                        } else {
                            this.getEventText(null);
                            this.curValue = this.prtBuf + this.curValue;
                        }
                        return 4;
                    }
                    this.state = 1;
                    if (this.locId > 0L) {
                        this.locId = 0L;
                        this.state = (short)4;
                    }
                    this.datastatus = (short)2;
                    return 4;
                }
                case 166: 
                case 167: 
                case 168: {
                    this.datalen = this.opdata[0];
                    if (bl) {
                        this.skipBytes(this.datalen);
                    } else {
                        this.value = this.curStream.readString((int)this.datalen);
                        if (this.state == 5) {
                            if (this.prtOpcode != 231) {
                                throw new BinXMLException(this.err.getMessage0(35000));
                            }
                            this.state = 1;
                            this.value = this.prtBuf + this.value;
                        }
                    }
                    return 12;
                }
                case 169: 
                case 170: {
                    long l = this.opdata[0];
                    if (bl) {
                        this.skipBytes(l);
                    } else {
                        this.pitgtlen = (int)this.opdata[1];
                        this.piTarget = this.curStream.readString(this.pitgtlen);
                        this.value = this.curStream.readString((int)(l - (long)this.pitgtlen));
                        if (this.state == 5) {
                            if (this.prtOpcode != 232) {
                                throw new BinXMLException(this.err.getMessage0(35000));
                            }
                            this.state = 1;
                            this.value = this.prtBuf + this.value;
                        }
                    }
                    return 3;
                }
                case 171: 
                case 172: 
                case 173: {
                    this.datalen = this.opdata[0];
                    if (bl) {
                        this.skipBytes(this.datalen);
                    } else {
                        this.value = this.curStream.readString((int)this.datalen);
                        if (this.state == 5) {
                            if (this.prtOpcode != 233) {
                                throw new BinXMLException(this.err.getMessage0(35000));
                            }
                            this.state = 1;
                            this.value = this.prtBuf + this.value;
                        }
                    }
                    return 5;
                }
            }
            throw new BinXMLException(this.err.getMessage0(35000));
        }
        if (this.isExtendedOpcode) {
            switch (s) {
                case 1: {
                    short s9 = this.readNum2();
                    this.notName = s9 > 0 ? this.curStream.readString(s9) : null;
                    s9 = this.readNum2();
                    this.publicId = s9 > 0 ? this.curStream.readString(s9) : null;
                    s9 = this.readNum2();
                    this.systemId = s9 > 0 ? this.curStream.readString(s9) : null;
                    s9 = this.readNum1();
                    if (s9 == 1) {
                        this.systemId = "";
                    } else if (s9 == 2) {
                        this.publicId = "";
                    } else if (s9 == 3) {
                        this.systemId = "";
                        this.publicId = "";
                    }
                    this.isExtendedOpcode = false;
                    return 107;
                }
                case 0: {
                    short s10 = this.readNum2();
                    this.dtdName = s10 > 0 ? this.curStream.readString(s10) : null;
                    s10 = this.readNum2();
                    this.publicId = s10 > 0 ? this.curStream.readString(s10) : null;
                    s10 = this.readNum2();
                    this.systemId = s10 > 0 ? this.curStream.readString(s10) : null;
                    s10 = this.readNum1();
                    if (s10 == 1) {
                        this.systemId = "";
                    } else if (s10 == 2) {
                        this.publicId = "";
                    } else if (s10 == 3) {
                        this.systemId = "";
                        this.publicId = "";
                    }
                    this.isExtendedOpcode = false;
                    return 100;
                }
                case 2: {
                    short s11 = this.readNum2();
                    this.entName = s11 > 0 ? this.curStream.readString(s11) : null;
                    s11 = this.readNum2();
                    this.value = s11 > 0 ? this.curStream.readString(s11) : null;
                    s11 = this.readNum2();
                    this.publicId = s11 > 0 ? this.curStream.readString(s11) : null;
                    s11 = this.readNum2();
                    this.systemId = s11 > 0 ? this.curStream.readString(s11) : null;
                    s11 = this.readNum2();
                    this.notName = s11 > 0 ? this.curStream.readString(s11) : null;
                    s11 = this.readNum1();
                    if (s11 == 1) {
                        this.systemId = "";
                    } else if (s11 == 2) {
                        this.publicId = "";
                    } else if (s11 == 3) {
                        this.systemId = "";
                        this.publicId = "";
                    } else if (s11 == 4) {
                        this.value = "";
                    }
                    this.isExtendedOpcode = false;
                    if (this.value != null) {
                        return 103;
                    }
                    if (this.notName != null) {
                        return 104;
                    }
                    return 105;
                }
                case 3: {
                    short s12 = this.readNum2();
                    this.entName = s12 > 0 ? this.curStream.readString(s12) : null;
                    s12 = this.readNum2();
                    this.value = s12 > 0 ? this.curStream.readString(s12) : null;
                    s12 = this.readNum2();
                    this.publicId = s12 > 0 ? this.curStream.readString(s12) : null;
                    s12 = this.readNum2();
                    String string = this.systemId = s12 > 0 ? this.curStream.readString(s12) : null;
                    if (this.entName != null && this.entName.length() != 0) {
                        this.entName = "%" + this.entName;
                    }
                    if ((s12 = (short)this.readNum1()) == 1) {
                        this.systemId = "";
                    } else if (s12 == 2) {
                        this.publicId = "";
                    } else if (s12 == 4) {
                        this.value = "";
                    } else if (s12 == 3) {
                        this.systemId = "";
                        this.publicId = "";
                    }
                    this.isExtendedOpcode = false;
                    if (this.value != null) {
                        return 103;
                    }
                    return 105;
                }
                case 4: {
                    int n;
                    short s13 = this.readNum2();
                    this.elemName = s13 > 0 ? this.curStream.readString(s13) : null;
                    this.attrCount = this.readNum2();
                    if (this.attrCount >= Short.MAX_VALUE || this.attrCount < 0) {
                        String string = this.err.getMessage0(35017);
                        throw new BinXMLException(string);
                    }
                    this.attrNames = new String[this.attrCount];
                    this.attrTypes = new String[this.attrCount];
                    this.attrModes = new String[this.attrCount];
                    this.values = new String[this.attrCount];
                    for (n = 0; n < this.attrCount; ++n) {
                        s13 = this.readNum2();
                        this.attrNames[n] = s13 > 0 ? this.curStream.readString(s13) : null;
                        s13 = this.readNum2();
                        this.attrType = s13 > 0 ? this.curStream.readString(s13) : null;
                        this.splitAttrString(this.attrType);
                        this.attrTypes[n] = this.attrType;
                        this.attrModes[n] = this.attrMode;
                        this.values[n] = this.value;
                    }
                    n = this.readNum1();
                    if (n != 0) {
                        throw new BinXMLException(this.err.getMessage1(35016, "" + s));
                    }
                    this.isExtendedOpcode = false;
                    return 102;
                }
            }
            throw new BinXMLException(this.err.getMessage0(35000));
        }
        switch (s) {
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                long l = this.getdatalen(s);
                String string = this.curStream.readString((int)l);
                if (this.mark == this.lastmark) {
                    long l2 = this.opdata[1];
                    this.registerNamespace(l2, string);
                }
                this.state = 1;
                return 99;
            }
            case 178: 
            case 179: {
                long l = this.getdatalen(s);
                String string = this.curStream.readString((int)l);
                long l3 = this.opdata[2];
                long l4 = this.opdata[1];
                this.addPrefix((short)l3, string, l4);
                return 99;
            }
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: {
                long l = this.getdatalen(s);
                String string = this.curStream.readString((int)l);
                if (this.mark == this.lastmark) {
                    long l5 = this.opdata[2];
                    long l6 = this.opdata[3];
                    boolean bl2 = ((int)this.opdata[1] & 1) > 0;
                    this.registerTokenId(l5, string, l6, bl2);
                }
                this.state = 1;
                return 99;
            }
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: {
                DecodeElem decodeElem;
                Object var12_70 = null;
                if (this.locId > 0L) {
                    if (this.locId == 1L) {
                        this.locId = 0L;
                        this.datastatus = (short)2;
                        this.state = (short)4;
                        return 1;
                    }
                    long l = this.locId;
                    this.locId = 0L;
                    decodeElem = this.getDecodeElem(l);
                } else if (this.curStream.laElem != null) {
                    decodeElem = this.curStream.laElem;
                    this.curStream.laElem = null;
                } else if ((this.opinfo.flags & 1) > 0) {
                    DecodeElem decodeElem5 = this.peekElem();
                    if (decodeElem5.prop == null) {
                        throw new BinXMLException(this.err.getMessage0(35000));
                    }
                    short s14 = (short)this.opdata[1];
                    decodeElem = this.getDecodeElem(this.schema, decodeElem5.prop, s14);
                } else {
                    decodeElem = this.getDecodeElem(this.opdata[1]);
                }
                if (decodeElem.isAttr) {
                    throw new BinXMLException(this.err.getMessage0(35000));
                }
                decodeElem.setPrefix(null);
                this.pushElem(decodeElem);
                this.datastatus = (short)2;
                this.state = (short)2;
                return 1;
            }
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: {
                DecodeElem decodeElem;
                byte by;
                String string = null;
                int n = 0;
                boolean bl3 = false;
                if (s >= 203 && s <= 207) {
                    by = (byte)this.opdata[1];
                } else if (s >= 208 && s <= 212) {
                    by = (byte)this.opdata[2];
                    bl3 = true;
                } else {
                    by = 0;
                }
                if (this.locId > 0L) {
                    long l = this.locId;
                    this.locId = 0L;
                    decodeElem = this.getDecodeElem(l);
                } else if (this.curStream.laElem != null) {
                    decodeElem = this.curStream.laElem;
                    this.curStream.laElem = null;
                } else if ((this.opinfo.flags & 1) > 0) {
                    DecodeElem decodeElem6 = this.peekElem();
                    if (decodeElem6.prop == null) {
                        throw new BinXMLException(this.err.getMessage0(35000));
                    }
                    short s15 = (short)(bl3 ? this.opdata[1] : this.opdata[0]);
                    decodeElem = this.getDecodeElem(this.schema, decodeElem6.prop, s15);
                } else {
                    long l = bl3 ? this.opdata[1] : this.opdata[0];
                    decodeElem = this.getDecodeElem(l);
                }
                if (decodeElem.isAttr) {
                    throw new BinXMLException(this.err.getMessage0(35000));
                }
                if (bl3) {
                    if ((by & 2) > 0) {
                        n = this.readNum4();
                        decodeElem.prop = this.schema.getTypeProperty(n);
                        decodeElem.typeid = n;
                    }
                    if ((by & 8) > 0) {
                        short s16 = this.readNum2();
                        string = this.getPrefix(s16);
                        decodeElem.pfxid = s16;
                    }
                }
                decodeElem.setPrefix(string);
                if (this.schema != null) {
                    decodeElem.setKidMode(true);
                }
                this.pushElem(decodeElem);
                this.processAttrs(bl);
                decodeElem.setSeqMode((by & 1) > 0);
                this.state = 1;
                return 1;
            }
            case 213: 
            case 214: {
                DecodeElem decodeElem;
                DecodeElem decodeElem7 = this.peekElem();
                if (this.locId > 0L) {
                    long l = this.locId;
                    this.locId = 0L;
                    decodeElem = this.getDecodeElem(l);
                } else if (decodeElem7.isArrMode()) {
                    decodeElem = this.elemStack.getNew(this.curElem);
                } else if (decodeElem7.isSeqMode()) {
                    decodeElem7.kidnum = (short)(decodeElem7.kidnum + 1);
                    decodeElem = this.getDecodeElem(this.schema, decodeElem7.prop, decodeElem7.kidnum);
                    decodeElem.setPrefix(null);
                } else {
                    throw new BinXMLException(this.err.getMessage0(35000));
                }
                this.pushElem(decodeElem);
                this.processAttrs(bl);
                if (s == 214) {
                    decodeElem.setSeqMode(true);
                    if (this.schema != null) {
                        decodeElem.setKidMode(true);
                    }
                } else if (this.schema != null) {
                    XSDComplexType xSDComplexType = null;
                    if (decodeElem != null && decodeElem.prop != null && decodeElem.prop.xnode != null) {
                        if (decodeElem.prop.xnode instanceof XSDElement) {
                            XSDElement xSDElement = (XSDElement)decodeElem.prop.xnode;
                            if (xSDElement.getType() instanceof XSDComplexType) {
                                xSDComplexType = (XSDComplexType)xSDElement.getType();
                            }
                        } else if (decodeElem.prop.xnode instanceof XSDComplexType) {
                            xSDComplexType = (XSDComplexType)decodeElem.prop.xnode;
                        }
                    }
                    if (xSDComplexType != null) {
                        decodeElem.setKidMode(true);
                    }
                }
                this.state = 1;
                return 1;
            }
            case 215: 
            case 216: {
                DecodeElem decodeElem = this.peekElem();
                decodeElem.setArrMode(s == 215);
                return 99;
            }
            case 217: {
                this.popElem();
                return 2;
            }
            case 218: {
                this.noseq = (short)2;
                return 99;
            }
            case 219: 
            case 220: {
                return 99;
            }
            case 221: 
            case 222: 
            case 223: {
                throw new BinXMLException(this.err.getMessage0(35000));
            }
            case 224: 
            case 225: 
            case 226: 
            case 227: {
                DecodeElem decodeElem;
                String string = null;
                int n = 0;
                byte by = (byte)this.opdata[2];
                boolean bl4 = true;
                if (this.locId > 0L) {
                    long l = this.locId;
                    this.locId = 0L;
                    decodeElem = this.getDecodeElem(l);
                } else if (this.curStream.laElem != null) {
                    decodeElem = this.curStream.laElem;
                    this.curStream.laElem = null;
                } else if ((this.opinfo.flags & 1) > 0) {
                    DecodeElem decodeElem8 = this.peekElem();
                    if (decodeElem8.prop == null) {
                        throw new BinXMLException(this.err.getMessage0(35000));
                    }
                    short s17 = (short)this.opdata[1];
                    decodeElem = this.getDecodeElem(this.schema, decodeElem8.prop, s17);
                } else {
                    long l = this.opdata[1];
                    decodeElem = this.getDecodeElem(l);
                }
                if (decodeElem.isAttr) {
                    throw new BinXMLException(this.err.getMessage0(35000));
                }
                if ((by & 2) > 0) {
                    n = this.readNum4();
                    decodeElem.prop = this.schema.getTypeProperty(n);
                    decodeElem.typeid = n;
                }
                if ((by & 8) > 0) {
                    short s18 = this.readNum2();
                    string = this.getPrefix(s18);
                }
                decodeElem.setArrMode(true);
                this.curElem = decodeElem;
                decodeElem.setPrefix(string);
                decodeElem.setSeqMode((by & 1) > 0);
                if (this.schema != null) {
                    decodeElem.setKidMode(true);
                }
                this.state = 1;
                return 99;
            }
            case 228: 
            case 229: {
                this.getDataLen(s);
                this.addPRTdata((int)this.datalen, s);
                this.state = (short)5;
                return 99;
            }
            case 230: {
                this.getDataLen(s);
                this.addPRTdata((int)this.datalen, s);
                this.state = (short)5;
                return 99;
            }
            case 231: {
                this.addPRTdata((int)this.opdata[0], s);
                this.state = (short)5;
                return 99;
            }
            case 232: {
                this.addPRTdata((int)this.opdata[1], s);
                this.state = (short)5;
                return 99;
            }
            case 233: {
                this.addPRTdata((int)this.opdata[0], s);
                this.state = (short)5;
                return 99;
            }
            case 234: 
            case 235: {
                this.curChars = this.decodeWhitespaces();
                this.datastatus = 0;
                return 4;
            }
            case 236: {
                this.skipData();
                return 99;
            }
            case 237: {
                this.datastatus = 1;
                this.skipData();
                return 99;
            }
            case 242: {
                this.datastatus = 1;
                this.skipData();
                return 99;
            }
            case 238: 
            case 239: {
                this.datastatus = 1;
                this.skipData();
                return 99;
            }
            case 240: 
            case 241: {
                this.datastatus = 1;
                this.skipData();
                this.popElem();
                return 2;
            }
        }
        throw new BinXMLException(this.err.getMessage0(35000));
    }

    void splitAttrString(String string) {
        int n;
        this.attrType = null;
        this.attrMode = null;
        this.value = null;
        if (string == null) {
            return;
        }
        if ((string = string.trim()).startsWith("IDREFS")) {
            this.attrType = "IDREFS";
            string = string.substring(6, string.length());
        } else if (string.startsWith("IDREF")) {
            this.attrType = "IDREF";
            string = string.substring(5, string.length());
        } else if (string.startsWith("ID")) {
            this.attrType = "ID";
            string = string.substring(2, string.length());
        } else if (string.startsWith("NMTOKENS")) {
            this.attrType = "NMTOKENS";
            string = string.substring(7, string.length());
        } else if (string.startsWith("NMTOKEN")) {
            this.attrType = "NMTOKEN";
            string = string.substring(6, string.length());
        } else if (string.startsWith("ENTITY")) {
            this.attrType = "ENTITY";
            string = string.substring(6, string.length());
        } else if (string.startsWith("ENTITIES")) {
            this.attrType = "ENTITIES";
            string = string.substring(8, string.length());
        } else if (string.startsWith("CDATA")) {
            this.attrType = "CDATA";
            string = string.substring(5, string.length());
        } else if (string.startsWith("NOTATION")) {
            n = string.indexOf(")");
            this.attrType = string.substring(0, n + 1);
            string = string.substring(n + 1, string.length());
        } else if (string.startsWith("(")) {
            n = string.indexOf(")");
            this.attrType = string.substring(0, n + 1);
            string = string.substring(n + 1, string.length());
        }
        string = string.trim();
        if (string.startsWith("#FIXED")) {
            this.attrMode = "#FIXED";
            string = string.substring(6, string.length());
        } else if (string.startsWith("#IMPLIED")) {
            this.attrMode = "#IMPLIED";
            string = string.substring(8, string.length());
        } else if (string.startsWith("#REQUIRED")) {
            this.attrMode = "#REQUIRED";
            string = string.substring(9, string.length());
        }
        string = string.trim();
        if (string.equals("")) {
            this.value = null;
        } else if (string.startsWith("\"")) {
            n = string.lastIndexOf("\"");
            this.value = string.substring(1, n);
        } else if (string.startsWith("'")) {
            n = string.lastIndexOf("'");
            this.value = string.substring(1, n);
        }
    }

    private char[] decodeWhitespaces() throws BinXMLException {
        this.datalen = 0L;
        int n = 0;
        while (this.opcode == 234 || this.opcode == 235) {
            int n2;
            short s;
            short s2;
            if (this.opcode == 234) {
                s2 = (short)((short)this.opdata[0] & 0x1F);
                s = (short)((short)this.opdata[0] & 0xE0);
            } else if (this.opcode == 235) {
                s2 = (short)((short)this.opdata[0] & 0x1FFF);
                s = (short)((short)this.opdata[0] >> 8 & 0xE0);
            } else {
                s2 = 0;
                s = 0;
            }
            int n3 = (int)this.datalen + s2;
            if (this.charbuf.length < n3) {
                char[] cArray = this.charbuf;
                this.charbuf = new char[n3];
                System.arraycopy(this.charbuf, 0, cArray, 0, (int)this.datalen);
            }
            switch (s) {
                case 128: {
                    this.charbuf[(int)this.datalen++] = 10;
                    n2 = 32;
                    break;
                }
                case 0: {
                    n2 = 32;
                    break;
                }
                case 32: {
                    n2 = 9;
                    break;
                }
                case 64: {
                    n2 = 10;
                    break;
                }
                default: {
                    n2 = 13;
                }
            }
            for (int i = (int)this.datalen; i < n3; ++i) {
                this.charbuf[i] = n2;
            }
            this.datalen = n3;
            n = this.mark;
            this.opcode = this.nextCSXInstr();
        }
        this.curStream.ladata = n;
        return this.charbuf;
    }

    private void processAttrs(boolean bl) throws BinXMLException {
        int n;
        short s = 0;
        block12: while (true) {
            n = this.mark;
            short s2 = this.nextCSXInstr();
            if (s2 == 255) {
                throw new BinXMLException(this.err.getMessage0(35000));
            }
            switch (s2) {
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 224: 
                case 225: 
                case 226: 
                case 227: {
                    long l;
                    short s3;
                    DecodeElem decodeElem;
                    DecodeElem decodeElem2;
                    byte by;
                    int n2 = 0;
                    boolean bl2 = false;
                    String string = null;
                    if (s2 >= 203 && s2 <= 207) {
                        by = (byte)this.opdata[1];
                    } else if (s2 >= 208 && s2 <= 212 || s2 >= 224 && s2 <= 227) {
                        by = (byte)this.opdata[2];
                        bl2 = true;
                    } else {
                        by = 0;
                    }
                    if ((this.opinfo.flags & 1) > 0) {
                        decodeElem2 = this.peekElem();
                        if (decodeElem2.prop == null) {
                            throw new BinXMLException(this.err.getMessage0(35000));
                        }
                        s = (short)(bl2 ? this.opdata[1] : this.opdata[0]);
                        decodeElem = this.getDecodeElem(this.schema, decodeElem2.prop, s);
                    } else {
                        long l2 = bl2 ? this.opdata[1] : this.opdata[0];
                        decodeElem = this.getDecodeElem(l2);
                    }
                    if (!decodeElem.isAttr) {
                        this.curStream.ladata = n;
                        this.curStream.laElem = decodeElem;
                        return;
                    }
                    if (bl2) {
                        if ((by & 2) > 0) {
                            n2 = this.readNum4();
                            decodeElem.prop = this.schema.getTypeProperty(n2);
                            decodeElem.typeid = n2;
                        }
                        if ((by & 8) > 0) {
                            s3 = this.readNum2();
                            string = this.getPrefix(s3);
                        }
                    }
                    string = decodeElem.setPrefix(string);
                    String string2 = "";
                    while ((s2 = this.nextCSXInstr()) != 217) {
                        if (!this.opinfo.hasfixeddata && s2 != 138 && s2 != 139) {
                            throw new BinXMLException(this.err.getMessage0(35000));
                        }
                        l = this.getdatalen(s2);
                        if (!bl) {
                            string2 = this.curStream.readString((int)l);
                            continue;
                        }
                        this.skipBytes(l);
                    }
                    if (bl) continue block12;
                    if (string == null || string.length() == 0) {
                        this.addAttr(string, decodeElem.local, decodeElem.local, string2, decodeElem.getURI());
                        continue block12;
                    }
                    this.addAttr(string, decodeElem.local, string + ":" + decodeElem.local, string2, decodeElem.getURI());
                    continue block12;
                }
                case 188: 
                case 189: 
                case 190: 
                case 191: 
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: {
                    String string2;
                    DecodeElem decodeElem;
                    DecodeElem decodeElem2;
                    String string = null;
                    if ((this.opinfo.flags & 1) > 0) {
                        decodeElem2 = this.peekElem();
                        if (decodeElem2.prop == null) {
                            throw new BinXMLException(this.err.getMessage0(35000));
                        }
                        s = (short)this.opdata[1];
                        decodeElem = this.getDecodeElem(this.schema, decodeElem2.prop, s);
                        if (this.schema != null) {
                            decodeElem.setKidMode(true);
                        }
                    } else {
                        decodeElem = this.getDecodeElem(this.opdata[1]);
                    }
                    if (!decodeElem.isAttr) {
                        this.curStream.ladata = n;
                        this.curStream.laElem = decodeElem;
                        return;
                    }
                    this.datastatus = (short)2;
                    if (!bl) {
                        string2 = this.getEventText(decodeElem);
                        string = decodeElem.setPrefix(null);
                        if (string == null || string.length() == 0) {
                            this.addAttr(string, decodeElem.local, decodeElem.local, string2, decodeElem.getURI());
                            continue block12;
                        }
                        this.addAttr(string, decodeElem.local, string + ":" + decodeElem.local, string2, decodeElem.getURI());
                        continue block12;
                    }
                    this.skipData();
                    continue block12;
                }
                case 221: {
                    short s3 = (short)this.opdata[0];
                    PrefixInfo prefixInfo = this.getPrefixInfo(s3);
                    this.pushNamespace(prefixInfo);
                    if (bl) continue block12;
                    if (prefixInfo.prefix == null || prefixInfo.prefix.length() == 0) {
                        this.addAttr(null, "xmlns", "xmlns", prefixInfo.getUri(), "http://www.w3.org/2000/xmlns/");
                        continue block12;
                    }
                    this.addAttr("xmlns", prefixInfo.prefix, "xmlns:" + prefixInfo.prefix, prefixInfo.getUri(), "http://www.w3.org/2000/xmlns/");
                    continue block12;
                }
                case 222: 
                case 223: {
                    long l = this.getdatalen(s2);
                    String string = this.curStream.readString((int)l);
                    long l3 = this.opdata[1];
                    String string2 = this.getNamespace(l3);
                    PrefixInfo prefixInfo = this.addPrefix((short)0, string, l3);
                    this.pushNamespace(prefixInfo);
                    if (bl) continue block12;
                    if (string == null || string.length() == 0) {
                        this.addAttr(null, "xmlns", "xmlns", string2, "http://www.w3.org/2000/xmlns/");
                        continue block12;
                    }
                    this.addAttr("xmlns", string, "xmlns:" + string, string2, "http://www.w3.org/2000/xmlns/");
                    continue block12;
                }
                case 218: {
                    continue block12;
                }
                case 161: {
                    continue block12;
                }
                case 174: 
                case 175: 
                case 176: 
                case 177: {
                    long l = this.getdatalen(s2);
                    String string = this.curStream.readString((int)l);
                    long l3 = this.opdata[1];
                    this.registerNamespace(l3, string);
                    continue block12;
                }
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: {
                    long l = this.getdatalen(s2);
                    String string = this.curStream.readString((int)l);
                    long l4 = this.opdata[2];
                    long l3 = this.opdata[3];
                    boolean bl3 = ((int)this.opdata[1] & 1) > 0;
                    this.registerTokenId(l4, string, l3, bl3);
                    continue block12;
                }
                case 178: 
                case 179: {
                    long l = this.getdatalen(s2);
                    String string = this.curStream.readString((int)l);
                    long l4 = this.opdata[2];
                    long l3 = this.opdata[1];
                    this.addPrefix((short)l4, string, l3);
                    continue block12;
                }
                case 238: 
                case 239: {
                    this.datastatus = 1;
                    this.skipData();
                    continue block12;
                }
            }
            break;
        }
        this.curStream.ladata = n;
    }

    void decodeVocabDoc(BinXMLTokenManager binXMLTokenManager) throws BinXMLException {
        long l;
        long l2;
        this.reset();
        short s = this.readOpcode();
        this.readSectionHeader(s);
        s = this.nextCSXInstr();
        if (s == 174 || s == 175) {
            l2 = this.getdatalen(s);
            String string = this.curStream.readString((int)l2);
            l = this.opdata[1];
            binXMLTokenManager.registerNamespace(l, string);
        } else {
            throw new BinXMLException(this.err.getMessage0(35000));
        }
        block3: while ((s = this.nextCSXInstr()) != 160) {
            switch (s) {
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 186: 
                case 187: {
                    l2 = this.getdatalen(s);
                    String string = this.curStream.readString((int)l2);
                    long l3 = this.opdata[2];
                    l = this.opdata[3];
                    boolean bl = ((int)this.opdata[1] & 1) > 0;
                    binXMLTokenManager.registerTokenId(l3, string, l, bl);
                    continue block3;
                }
            }
            throw new BinXMLException(this.err.getMessage0(35000));
        }
    }

    private void readSectionHeader(short s) throws BinXMLException {
        byte by;
        if (s != 159) {
            throw new BinXMLException(this.err.getMessage0(35000));
        }
        this.decoder.version = this.readNum1();
        if (this.decoder.version != 1) {
            throw new BinXMLException(this.err.getMessage2(35014, "" + this.decoder.version, "1"));
        }
        byte by2 = this.readNum1();
        if ((by2 & 8) > 0) {
            by = this.readNum1();
            this.decoder.docid = new byte[by];
            this.readBytes(this.decoder.docid, by);
        }
        if ((by2 & 0x10) > 0) {
            by = this.readNum1();
            this.decoder.pathid = new byte[by];
            this.readBytes(this.decoder.pathid, by);
            byte by3 = this.readNum1();
            this.skipBytes(by3);
        }
        if ((by2 & 4) > 0) {
            if (this.decoder.rguid == null) {
                this.decoder.rguid = new byte[16];
                this.readBytes(this.decoder.rguid, 16L);
                this.binXMLProc.setTokenManager(this.decoder.rguid);
            } else {
                this.skipBytes(16L);
            }
            if (this.tokenMngr.metaProvider instanceof DBBinXMLMetadataProviderImpl) {
                ((DBBinXMLMetadataProviderImpl)this.tokenMngr.metaProvider).setGUID(this.decoder.rguid);
            }
        } else if (this.tokenMngr.metaProvider instanceof DBBinXMLMetadataProviderImpl) {
            ((DBBinXMLMetadataProviderImpl)this.tokenMngr.metaProvider).setGUID(this.decoder.rguid);
        }
        this.decoder.bigeflt = (by2 & 0x40) > 0;
    }

    private boolean isPropertyId(long l) {
        if (l <= 65535L) {
            return (l & 0x8000L) == 32768L;
        }
        return (l & 0x80000000L) == 0x80000000L;
    }

    void addPRTdata(int n, short s) throws BinXMLException {
        String string = this.curStream.readString(n);
        if (this.prtBuf != null) {
            if (this.prtOpcode != s) {
                throw new BinXMLException(this.err.getMessage0(35000));
            }
            this.prtBuf = this.prtBuf + string;
        } else {
            this.prtBuf = string;
            this.prtOpcode = s;
        }
    }

    void pushElem(DecodeElem decodeElem) {
        decodeElem.nsinx = this.nsStack.size();
        this.elemStack.push(decodeElem);
        this.curElem = decodeElem;
        this.curElem.streamId = this.curStream.id;
        this.prevSibling = null;
    }

    DecodeElem popElem() throws BinXMLException {
        if (this.elemStack.empty()) {
            throw new BinXMLException(this.err.getMessage0(35000));
        }
        this.prevSibling = this.curElem = this.elemStack.pop();
        this.popNamespace(this.curElem.nsinx);
        if (!this.elemStack.empty()) {
            DecodeElem decodeElem = this.elemStack.peek();
            if (this.curElem.streamId != decodeElem.streamId) {
                decodeElem.flags = 0;
                this.popStream();
            }
        }
        return this.curElem;
    }

    DecodeElem peekElem() throws BinXMLException {
        if (this.elemStack.empty()) {
            throw new BinXMLException(this.err.getMessage0(35000));
        }
        return this.elemStack.peek();
    }

    DecodeElem getDecodeElem(BinXMLSchema binXMLSchema, BinXMLProperty binXMLProperty, short s) throws BinXMLException {
        BinXMLProperty binXMLProperty2;
        if (binXMLProperty.getBinXMLSchema() == null) {
            binXMLProperty.setBinXMLSchema(binXMLSchema);
        }
        if ((binXMLProperty2 = binXMLSchema.getProperty(binXMLProperty, s)) == null) {
            throw new BinXMLException(this.err.getMessage0(35000));
        }
        binXMLProperty2.setBinXMLSchema(binXMLSchema);
        QName qName = binXMLProperty2.getQName();
        DecodeElem decodeElem = this.elemStack.getNew();
        decodeElem.local = qName.getLocalPart();
        decodeElem.uri = qName.getNamespaceURI();
        decodeElem.prefix = qName.getPrefix();
        decodeElem.nsid = 0L;
        decodeElem.id = -binXMLProperty2.propId;
        decodeElem.isAttr = binXMLProperty2.isAttribute();
        decodeElem.prop = binXMLProperty2;
        decodeElem.pfxid = 0;
        decodeElem.typeid = 0;
        return decodeElem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DecodeElem getDecodeElem(long l) throws BinXMLException {
        DecodeElem decodeElem = this.elemStack.getNew();
        if (this.isPropertyId(l) && this.schema != null) {
            int n = l <= 65535L && (l & 0x8000L) == 32768L ? (int)(-((short)l)) : -((int)l);
            BinXMLProperty binXMLProperty = this.schema.getProperty(n);
            if (binXMLProperty != null) {
                QName qName = binXMLProperty.getQName();
                decodeElem.local = qName.getLocalPart();
                decodeElem.uri = qName.getNamespaceURI();
                decodeElem.prefix = qName.getPrefix();
                decodeElem.nsid = 0L;
                decodeElem.isAttr = binXMLProperty.isAttribute();
                decodeElem.id = l;
                decodeElem.prop = binXMLProperty;
                decodeElem.pfxid = 0;
                decodeElem.typeid = 0;
                return decodeElem;
            } else {
                if ((l < 32769L || l > 65535L) && (l < 0x80000001L || l > 0xFFFFFFFFL)) throw new BinXMLException(this.err.getMessage0(35000));
                BinXMLQNameToken binXMLQNameToken = this.getToken(l);
                decodeElem.local = binXMLQNameToken.getLocalName();
                decodeElem.uri = binXMLQNameToken.getNamespace();
                decodeElem.prefix = null;
                decodeElem.nsid = binXMLQNameToken.getNamespaceId();
                decodeElem.isAttr = binXMLQNameToken.isAttr();
                decodeElem.id = l;
                decodeElem.prop = null;
                decodeElem.pfxid = 0;
                decodeElem.typeid = 0;
            }
            return decodeElem;
        } else {
            BinXMLQNameToken binXMLQNameToken = this.getToken(l);
            decodeElem.local = binXMLQNameToken.getLocalName();
            decodeElem.uri = binXMLQNameToken.getNamespace();
            decodeElem.isAttr = binXMLQNameToken.isAttr();
            decodeElem.nsid = binXMLQNameToken.getNamespaceId();
            decodeElem.id = l;
            decodeElem.prefix = null;
            decodeElem.prop = null;
            decodeElem.pfxid = 0;
            decodeElem.typeid = 0;
        }
        return decodeElem;
    }

    DecodeElem getDecodeElemByTypeId(int n) throws BinXMLException {
        DecodeElem decodeElem = this.elemStack.getNew();
        BinXMLProperty binXMLProperty = this.schema.getTypeProperty(n);
        if (binXMLProperty == null) {
            throw new BinXMLException(this.err.getMessage0(35000));
        }
        QName qName = binXMLProperty.getQName();
        decodeElem.local = qName.getLocalPart();
        decodeElem.uri = qName.getNamespaceURI();
        decodeElem.prefix = qName.getPrefix();
        decodeElem.nsid = 0L;
        decodeElem.isAttr = binXMLProperty.isAttribute();
        decodeElem.id = n;
        decodeElem.prop = binXMLProperty;
        decodeElem.pfxid = 0;
        decodeElem.typeid = n;
        return decodeElem;
    }

    void addAttr(String string, String string2, String string3, String string4, String string5) {
        this.attrlist.addAttr(string == null ? "" : string, string2, string3, string4 == null ? "" : string4, true, 0, string5);
    }

    private BinXMLSchema popSchema() throws BinXMLException {
        if (this.schemaStack.isEmpty()) {
            String string = this.err.getMessage0(35017);
            throw new BinXMLException(string);
        }
        return this.schemaStack.pop();
    }

    void pushSchema(BinXMLSchema binXMLSchema) {
        this.schemaStack.push(binXMLSchema);
    }

    void pushNamespace(PrefixInfo prefixInfo) throws BinXMLException {
        this.nsStack.add(prefixInfo);
    }

    String getNSPrefix(long l) throws BinXMLException {
        Object object;
        for (int i = 0; i < this.nsStack.size(); ++i) {
            object = (PrefixInfo)this.nsStack.get(i);
            if (((PrefixInfo)object).nsid != l) continue;
            return ((PrefixInfo)object).prefix;
        }
        this.mutableLong.setValue(l);
        PrefixInfo prefixInfo = this.nsPrefixTable.get(this.mutableLong);
        if (prefixInfo != null) {
            return prefixInfo.prefix;
        }
        object = reservedNSPrefixTable.get(new Long(l));
        return object;
    }

    String getNSPrefix(String string) throws BinXMLException {
        Object object;
        for (int i = 0; i < this.nsStack.size(); ++i) {
            PrefixInfo object2 = (PrefixInfo)this.nsStack.get(i);
            if (!object2.getUri().equals(string)) continue;
            return object2.prefix;
        }
        for (Short s : this.prefixTable.keySet()) {
            object = this.prefixTable.get(s);
            if (!((PrefixInfo)object).getUri().equals(string)) continue;
            return ((PrefixInfo)object).prefix;
        }
        for (Short s : reservedNSTable.keySet()) {
            object = reservedNSTable.get(s);
            if (!((String)object).equals(string)) continue;
            return reservedNSPrefixTable.get(s);
        }
        return null;
    }

    void popNamespace(int n) {
        for (int i = this.nsStack.size() - 1; i >= n; --i) {
            this.nsStack.remove(i);
        }
    }

    short addSchema(BinXMLSchema binXMLSchema) {
        boolean bl = false;
        for (int i = 0; i < this.schemaTable.size(); ++i) {
            if (this.schemaTable.get(i) != binXMLSchema) continue;
            return (short)i;
        }
        this.schemaTable.add(binXMLSchema);
        return (short)(this.schemaTable.size() - 1);
    }

    short getSchemaId(BinXMLSchema binXMLSchema) {
        for (int i = 0; i < this.schemaTable.size(); ++i) {
            if (this.schemaTable.get(i) != binXMLSchema) continue;
            return (short)i;
        }
        return 0;
    }

    BinXMLSchema getSchema(short s) {
        if (s >= 0 && s < this.schemaTable.size()) {
            return (BinXMLSchema)this.schemaTable.get(s);
        }
        return null;
    }

    PrefixInfo addPrefix(short s, String string, long l) throws BinXMLException {
        PrefixInfo prefixInfo = null;
        if (!this.prefixTable.containsKey(new Short(s))) {
            prefixInfo = new PrefixInfo(s, string, l);
            this.prefixTable.put(new Short(s), prefixInfo);
        } else {
            prefixInfo = this.prefixTable.get(new Short(s));
        }
        this.mutableLong.setValue(l);
        if (!this.nsPrefixTable.containsKey(this.mutableLong)) {
            this.nsPrefixTable.put(new MutableLong(l), prefixInfo);
        }
        return prefixInfo;
    }

    PrefixInfo getPrefixInfo(short s) throws BinXMLException {
        PrefixInfo prefixInfo = this.prefixTable.get(new Short(s));
        if (prefixInfo == null) {
            prefixInfo = this.getReservedPrefixInfo(s);
        }
        if (prefixInfo == null) {
            throw new BinXMLException(this.err.getMessage0(35000));
        }
        return prefixInfo;
    }

    String getPrefix(short s) throws BinXMLException {
        PrefixInfo prefixInfo = this.prefixTable.get(new Short(s));
        if (prefixInfo == null && s >= 1 && s <= 6) {
            return reservedPrefixTable.get(new Short(s));
        }
        if (prefixInfo == null) {
            throw new BinXMLException(this.err.getMessage0(35000));
        }
        return prefixInfo.prefix;
    }

    PrefixInfo getReservedPrefixInfo(short s) throws BinXMLException {
        String string = reservedPrefixTable.get(s);
        long l = 0L;
        switch (s) {
            case 1: {
                l = 1L;
                break;
            }
            case 2: {
                l = 2L;
                break;
            }
            case 3: {
                l = 3L;
                break;
            }
            case 4: {
                l = 4L;
                break;
            }
            case 5: {
                l = 4L;
                break;
            }
            case 6: {
                l = 5L;
                break;
            }
            default: {
                throw new BinXMLException(this.err.getMessage0(35000));
            }
        }
        return new PrefixInfo(s, string, l);
    }

    String getEventName() {
        String string = this.getEventPrefix();
        if (string == null || string.length() == 0) {
            return this.getEventLocalName();
        }
        return string + ":" + this.getEventLocalName();
    }

    String getEventLocalName() {
        return this.curElem.local;
    }

    String getEventPrefix() {
        return this.curElem.prefix;
    }

    String getEventURI() {
        return this.curElem.uri;
    }

    Attributes getEventAttrList() {
        return this.attrlist;
    }

    char[] getEventChars() throws BinXMLException {
        if (this.datastatus == 0) {
            return this.curChars;
        }
        this.getDataLen(this.opcode);
        switch (this.datatype) {
            case 1: {
                this.curChars = this.curStream.readChars((int)this.datalen);
                break;
            }
            default: {
                String string = this.getEventText(null);
                this.curChars = string.toCharArray();
                this.datalen = this.curChars.length;
            }
        }
        this.datastatus = 0;
        return this.curChars;
    }

    char[] getEventChars(int n) throws BinXMLException {
        if (this.datastatus == 0) {
            return this.curChars;
        }
        this.getDataLen(this.opcode);
        switch (this.datatype) {
            case 1: {
                if (this.datalen > (long)n) {
                    this.curChars = this.curStream.readChars((int)this.datalen, n);
                    break;
                }
                this.curChars = this.curStream.readChars((int)this.datalen);
                break;
            }
            default: {
                String string = this.getEventText(null);
                this.curChars = string.toCharArray();
                this.datalen = this.curChars.length;
            }
        }
        this.datastatus = 0;
        return this.curChars;
    }

    private int getCurElemType() throws BinXMLException {
        int n = 9;
        if (this.curElem.prop == null) {
            return n;
        }
        XSDNode xSDNode = this.curElem.prop.getXSDNode();
        XSDNode xSDNode2 = xSDNode instanceof XSDElement ? ((XSDElement)xSDNode).getType() : ((XSDAttribute)xSDNode).getType();
        if (xSDNode2 instanceof XSDSimpleType) {
            n = ((XSDSimpleType)xSDNode2).getBasicType();
        } else {
            XSDSimpleType xSDSimpleType = ((XSDComplexType)xSDNode2).getSimpleType();
            if (xSDSimpleType != null) {
                n = xSDSimpleType.getBasicType();
            }
        }
        return n;
    }

    private Calendar dateToCalendar(byte[] byArray) {
        int n;
        int[] nArray = new int[7];
        for (n = 0; n < 7; ++n) {
            nArray[n] = byArray[n] & 0xFF;
        }
        n = (nArray[0] - 100) * 100 + (nArray[1] - 100);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, n);
        calendar.set(2, nArray[2] - 1);
        calendar.set(5, nArray[3]);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private String calendarToString(Calendar calendar, int n, boolean bl, int n2, int n3) throws BinXMLException {
        int n4 = this.getCurElemType();
        StringBuffer stringBuffer = new StringBuffer();
        int n5 = 0;
        int n6 = calendar.get(1);
        if (n4 == 7 || n4 == 9 || n4 == 10 || n4 == 11) {
            if (calendar.get(0) == 0) {
                stringBuffer.append('-');
                n5 = 1;
            }
            stringBuffer.append(n6);
            while (stringBuffer.length() - n5 < 4) {
                stringBuffer.insert(n5, '0');
            }
        }
        if (n4 != 11 && n4 != 8) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append('-');
            }
            stringBuffer.append('-');
            if (n4 != 14) {
                n5 = calendar.get(2) + 1;
                if (n5 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n5);
            } else {
                stringBuffer.append('-');
            }
            if (n4 != 12 && n4 != 10) {
                if (n4 != 14) {
                    stringBuffer.append('-');
                }
                if ((n5 = calendar.get(5)) < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n5);
            }
        }
        if (n4 == 7 || n4 == 8) {
            if (n4 == 7) {
                stringBuffer.append('T');
            }
            if ((n5 = calendar.get(11)) < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n5);
            stringBuffer.append(':');
            n5 = calendar.get(12);
            if (n5 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n5);
            stringBuffer.append(':');
            n5 = calendar.get(13);
            if (n5 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n5);
            n5 = n / 1000000;
            if (n5 > 0) {
                int n7;
                stringBuffer.append('.');
                if (n5 < 100) {
                    stringBuffer.append('0');
                }
                if (n5 < 10) {
                    stringBuffer.append('0');
                }
                String string = String.valueOf(n5);
                for (n7 = string.length() - 1; n7 >= 0 && string.charAt(n7) == '0'; --n7) {
                }
                stringBuffer.append(string.substring(0, n7 + 1));
            }
        }
        if (bl) {
            if (n2 > 0) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('-');
                n2 = -n2;
            }
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2);
            stringBuffer.append(':');
            if (n3 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n3);
        }
        return stringBuffer.toString();
    }

    private String oratsToString() throws BinXMLException {
        int n;
        int n2;
        Timestamp timestamp;
        Object object;
        byte[] byArray = new byte[(int)this.datalen];
        this.curStream.readBytes(byArray, this.datalen);
        if (this.datalen == 13L) {
            if (this.tokenMngr == null || this.tokenMngr.metaProvider == null) {
                String string = this.err.getMessage0(35017);
                throw new BinXMLException(string);
            }
            object = ((DBBinXMLMetadataProviderImpl)this.tokenMngr.metaProvider).getConnection();
            if (object == null) {
                String string = this.err.getMessage0(35017);
                throw new BinXMLException(string);
            }
            try {
                timestamp = TIMESTAMPTZ.toTimestamp((Connection)object, (byte[])byArray);
            }
            catch (SQLException sQLException) {
                throw new BinXMLException(sQLException);
            }
        } else if (this.datalen == 11L) {
            try {
                timestamp = TIMESTAMP.toTimestamp((byte[])byArray);
            }
            catch (SQLException sQLException) {
                throw new BinXMLException(sQLException);
            }
        } else {
            throw new BinXMLException("Invalid ORATS data");
        }
        object = Calendar.getInstance();
        ((Calendar)object).setTime(timestamp);
        int n3 = 0;
        n3 = (byArray[7] & 0xFF) << 24;
        n3 |= (byArray[8] & 0xFF) << 16;
        n3 |= (byArray[9] & 0xFF) << 8;
        n3 |= byArray[10] & 0xFF & 0xFF;
        if (this.datalen == 13L && byArray[11] != 0 && (byArray[11] & 0xFFFFFF80) == 0) {
            n2 = byArray[11] - 20;
            n = byArray[12] - 60;
        } else {
            n2 = 0;
            n = 0;
        }
        boolean bl = n2 != 0 || n != 0;
        return this.calendarToString((Calendar)object, n3, bl, n2, n);
    }

    String getEventText(DecodeElem decodeElem) throws BinXMLException {
        if (this.datastatus == 0) {
            if (this.curValue == null && this.curChars != null) {
                this.curValue = new String(this.curChars, 0, (int)this.datalen);
            }
            return this.curValue;
        }
        this.getDataLen(this.opcode);
        block0 : switch (this.datatype) {
            case 1: {
                this.curValue = this.curStream.readString((int)this.datalen);
                break;
            }
            case 2: {
                if (this.datalen >= Integer.MAX_VALUE || this.datalen < 0L) {
                    String string = this.err.getMessage0(35017);
                    throw new BinXMLException(string);
                }
                this.curStream.readBytes(this.datalen);
                byte[] byArray = this.curStream.buf;
                if (this.curElem == null || this.curElem.prop == null || this.schema == null) {
                    String string = this.err.getMessage0(35017);
                    throw new BinXMLException(string);
                }
                int n = this.schema.getTypeId(this.curElem.prop.getXSDNode());
                switch (n) {
                    case 15: {
                        this.curValue = BinXMLUtil.convBytesToHexString(byArray);
                        break block0;
                    }
                    case 16: {
                        this.curValue = BinXMLUtil.convBytesToBase64String(byArray);
                        break block0;
                    }
                }
                throw new BinXMLException(this.err.getMessage0(35000));
            }
            case 4: {
                long l = 0L;
                switch ((int)this.datalen) {
                    case 1: {
                        l = this.readNum1();
                        break;
                    }
                    case 2: {
                        l = this.readNum2();
                        break;
                    }
                    case 4: {
                        l = this.readNum4();
                        break;
                    }
                    case 8: {
                        l = this.curStream.readLong8();
                        break;
                    }
                    default: {
                        throw new BinXMLException(this.err.getMessage0(35000));
                    }
                }
                this.curValue = Long.toString(l);
                break;
            }
            case 5: {
                switch ((int)this.datalen) {
                    case 1: {
                        this.curValue = Long.toString(this.curStream.readLong1());
                        break block0;
                    }
                    case 2: {
                        this.curValue = Long.toString(this.curStream.readLong2());
                        break block0;
                    }
                    case 4: {
                        this.curValue = Long.toString(this.curStream.readLong4());
                        break block0;
                    }
                    case 8: {
                        this.curValue = this.curStream.readBigInteger().toString();
                        break block0;
                    }
                }
                throw new BinXMLException(this.err.getMessage0(35000));
            }
            case 6: {
                int n = 0;
                switch ((int)this.datalen) {
                    case 4: {
                        n = this.decoder.bigeflt ? this.readNum4() : this.readNum4r();
                        float f = Float.intBitsToFloat(n);
                        this.curValue = Float.toString(f);
                        break block0;
                    }
                    case 8: {
                        long l = this.decoder.bigeflt ? this.curStream.readLong8() : this.curStream.readLong8r();
                        double d = Double.longBitsToDouble(l);
                        this.curValue = Double.toString(d);
                        break block0;
                    }
                }
                throw new BinXMLException(this.err.getMessage0(35000));
            }
            case 14: {
                long l = this.curStream.readLong8();
                double d = Double.longBitsToDouble(l);
                this.curValue = Double.toString(d);
                break;
            }
            case 7: {
                byte[] byArray = new byte[(int)this.datalen];
                this.curStream.readBytes(byArray, this.datalen);
                this.curValue = NUMBER.toString((byte[])byArray);
                break;
            }
            case 9: {
                this.curValue = this.oratsToString();
                break;
            }
            case 8: {
                byte[] byArray = new byte[(int)this.datalen];
                this.curStream.readBytes(byArray, this.datalen);
                Calendar calendar = this.dateToCalendar(byArray);
                this.curValue = this.calendarToString(calendar, 0, false, 0, 0);
                break;
            }
            case 10: {
                long l = this.datalen == 4L ? this.curStream.readLong4() : this.curStream.readLong8();
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(l * 1000L);
                this.curValue = this.calendarToString(calendar, 0, false, 0, 0);
                break;
            }
            case 11: {
                long l = this.datalen == 4L ? this.curStream.readLong4() : this.curStream.readLong8();
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(l * 1000L);
                l = this.readNum2();
                int n = (int)l / 60;
                int n2 = (int)l % 60;
                if (n2 < 0) {
                    n2 = -n2;
                }
                this.curValue = this.calendarToString(calendar, 0, true, n, n2);
                break;
            }
            case 13: {
                byte by = (byte)this.curStream.readLong1();
                long l = by == 4 ? this.curStream.readLong4() : this.curStream.readLong8();
                by = (byte)this.curStream.readLong1();
                short s = (short)this.curStream.readLong2();
                BinXMLQNameToken binXMLQNameToken = this.getToken(l);
                String string = binXMLQNameToken.getLocalName();
                if (by == 0) {
                    this.curValue = string;
                    break;
                }
                String string2 = this.getPrefix(s);
                this.curValue = string2 == null || string2.equals("") ? string : string2 + ":" + string;
                break;
            }
            case 12: {
                int n = this.datalen == 1L ? (int)this.curStream.readLong1() : (int)this.curStream.readLong2();
                if (decodeElem == null || decodeElem != null && !decodeElem.isAttr) {
                    DecodeElem decodeElem2 = this.peekElem();
                    if (decodeElem2 != null && decodeElem2.prop != null) {
                        this.curValue = decodeElem2.prop.getEnum(n);
                        break;
                    }
                    this.curValue = "";
                    break;
                }
                if (decodeElem != null && decodeElem.prop != null) {
                    this.curValue = decodeElem.prop.getEnum(n);
                    break;
                }
                this.curValue = "";
                break;
            }
            case 3: {
                byte by = (byte)this.curStream.readLong1();
                this.curValue = by == 0 ? "false" : "true";
                break;
            }
            default: {
                byte[] byArray = new byte[(int)this.datalen];
                this.curStream.readBytes(byArray, this.datalen);
                this.curValue = null;
            }
        }
        this.datastatus = 0;
        return this.curValue;
    }

    short nextCSXInstr() throws BinXMLException {
        int n;
        if (this.curStream.ladata > 0) {
            this.eventMark = this.curStream.ladata;
            this.curStream.ladata = 0;
            return this.opcode;
        }
        this.opcode = this.curStream.readOpcode();
        if (this.opcode != 254 && (this.opcode < 0 || this.opcode >= 243)) {
            throw new BinXMLException(this.err.getMessage0(35000));
        }
        if (this.opcode == 254) {
            this.opcode = this.curStream.readOpcode();
            if (this.opcode >= 5) {
                throw new BinXMLException(this.err.getMessage1(35015, "" + this.opcode));
            }
            this.opinfo = BinXMLFormat.extendedOpcodes[this.opcode];
            this.isExtendedOpcode = true;
        } else {
            this.opinfo = BinXMLFormat.opcodes[this.opcode];
        }
        block6: for (n = 0; n < this.opinfo.opnum; ++n) {
            switch (this.opinfo.oplen[n]) {
                case 1: {
                    this.opdata[n] = this.curStream.readLong1();
                    continue block6;
                }
                case 2: {
                    this.opdata[n] = this.curStream.readLong2();
                    continue block6;
                }
                case 4: {
                    this.opdata[n] = this.curStream.readLong4();
                    continue block6;
                }
                case 8: {
                    this.opdata[n] = this.curStream.readLong8();
                }
            }
        }
        if (this.printInst) {
            System.out.print("[" + this.eventMark + "-" + this.getLMark(this.eventMark) + "] " + this.opinfo.name + "   ");
            for (n = 0; n < this.opinfo.opnum; ++n) {
                if (n > 0) {
                    System.out.print(",");
                }
                System.out.print(" " + this.opdata[n]);
            }
            System.out.println("");
        }
        return this.opcode;
    }

    void skipData() throws BinXMLException {
        if (this.datastatus != 0) {
            this.getdatalen(this.opcode);
            this.skipBytes((int)this.datalen);
            this.datastatus = 0;
        }
    }

    long getDataLen() {
        return this.getDataLen(this.opcode);
    }

    long getDataLen(short s) {
        if (this.datastatus != 2) {
            if (this.datastatus == 1) {
                return this.datalen;
            }
            return 0L;
        }
        this.datastatus = 1;
        return this.getdatalen(s);
    }

    long getdatalen(short s) {
        if (this.opinfo.hasfixeddata) {
            this.datalen = this.opinfo.fixeddatalen;
            this.datatype = BinXMLFormat.dataType[s];
        } else if (this.opinfo.hasvardata) {
            if ((this.opinfo.flags & 8) > 0) {
                this.datalen = this.opdata[0];
                this.datatype = 1;
            } else if ((this.opinfo.flags & 4) == 0) {
                this.datalen = this.opdata[0];
                this.datatype = 1;
            } else {
                switch (this.opinfo.oplen[0]) {
                    case 1: {
                        BinXMLOpcode binXMLOpcode = BinXMLFormat.opcodes[(int)this.opdata[0]];
                        if (!binXMLOpcode.hasfixeddata) {
                            // empty if block
                        }
                        this.datalen = binXMLOpcode.fixeddatalen;
                        this.datatype = BinXMLFormat.dataType[(short)this.opdata[0]];
                        break;
                    }
                    case 2: {
                        this.datalen = this.opdata[0] & 0xFFFFFFFFFFFF3FFFL;
                        this.datatype = (byte)((this.opdata[0] & 0xC000L) == 0L ? 1 : 2);
                        break;
                    }
                    case 4: {
                        this.datalen = this.opdata[0] & 0xFFFFFFFF3FFFFFFFL;
                        this.datatype = (byte)((this.opdata[0] & 0xFFFFFFFFC0000000L) == 0L ? 1 : 2);
                        break;
                    }
                    case 8: {
                        this.datalen = this.opdata[0] & 0x3FFFFFFFFFFFFFFFL;
                        this.datatype = (byte)((this.opdata[0] & 0xC000000000000000L) == 0L ? 1 : 2);
                        break;
                    }
                }
            }
        } else {
            this.datalen = 0L;
            this.datatype = 1;
        }
        return this.datalen;
    }

    short readOpcode() throws BinXMLException {
        long l = this.readBytes(this.buf, 1L);
        if (l < 1L) {
            throw new BinXMLException(this.err.getMessage0(35001));
        }
        return (short)(this.buf[0] & 0xFF);
    }

    byte readNum1() throws BinXMLException {
        long l = this.readBytes(this.buf, 1L);
        if (l < 1L) {
            throw new BinXMLException(this.err.getMessage0(35001));
        }
        return this.buf[0];
    }

    short readNum2() throws BinXMLException {
        long l = this.readBytes(this.buf, 2L);
        if (l < 2L) {
            throw new BinXMLException(this.err.getMessage0(35001));
        }
        return (short)((this.buf[0] & 0xFF) << 8 | this.buf[1] & 0xFF);
    }

    int readNum4() throws BinXMLException {
        long l = this.readBytes(this.buf, 4L);
        if (l < 4L) {
            throw new BinXMLException(this.err.getMessage0(35001));
        }
        return (this.buf[0] & 0xFF) << 24 | (this.buf[1] & 0xFF) << 16 | (this.buf[2] & 0xFF) << 8 | this.buf[3] & 0xFF;
    }

    int readNum4r() throws BinXMLException {
        long l = this.readBytes(this.buf, 4L);
        if (l < 4L) {
            throw new BinXMLException(this.err.getMessage0(35001));
        }
        return (this.buf[3] & 0xFF) << 24 | (this.buf[2] & 0xFF) << 16 | (this.buf[1] & 0xFF) << 8 | this.buf[0] & 0xFF;
    }

    protected void resetSimple() throws BinXMLException {
        this.elemStack.clear();
        this.schemaStack.clear();
        this.nsStack.clear();
        this.streamStack.clear();
        this.schema = null;
        this.datastatus = 0;
        this.state = 1;
        if (this.curStream != null) {
            this.curStream.laElem = null;
            this.curStream.ladata = 0;
        }
        this.curStream = null;
        this.mark = 0;
    }

    protected void reset() throws BinXMLException {
        this.resetSimple();
        this.resetLocal();
        this.streamTable.clear();
        DecodeStream decodeStream = this.createStream(null);
        this.pushStream(decodeStream.id);
        this.pushElem(new DecodeElem());
    }

    private void initSpaceTables() {
        this.spcTable = new char[256];
        this.crspcTable = new char[256];
        this.wsBuf = new char[256];
        for (int i = 0; i < 256; ++i) {
            this.crspcTable[i] = 32;
            this.spcTable[i] = 32;
        }
        this.crspcTable[0] = 10;
    }

    private void registerTokenId(long l, String string, long l2, boolean bl) throws BinXMLException {
        this.localDefs = true;
        if (l2 == this.nsidnull) {
            l2 = 0L;
        }
        BinXMLQNameToken binXMLQNameToken = new BinXMLQNameToken(l, l2, string, bl);
        binXMLQNameToken.uri = this.getNamespace(l2);
        if (this.seqId) {
            this.qnTableSeq.set((int)l, binXMLQNameToken);
        } else {
            this.qnTable.put(new MutableLong(l), binXMLQNameToken);
        }
    }

    private void registerNamespace(long l, String string) {
        this.localDefs = true;
        if (this.seqId) {
            this.nsTableSeq.set((int)l, string);
        } else if (string != null) {
            this.nsTable.put(new MutableLong(l), string);
        }
    }

    private BinXMLQNameToken getToken(long l) throws BinXMLException {
        BinXMLQNameToken binXMLQNameToken = null;
        this.mutableLong.setValue(l);
        if (this.localDefs) {
            BinXMLQNameToken binXMLQNameToken2 = binXMLQNameToken = this.seqId ? this.qnTableSeq.get((int)l) : this.qnTable.get(this.mutableLong);
        }
        if (binXMLQNameToken == null) {
            binXMLQNameToken = this.tokenMngr.getToken(l);
            if (binXMLQNameToken != null && binXMLQNameToken.namespaceId == this.nsidnull) {
                binXMLQNameToken.namespaceId = 0L;
            }
            if (binXMLQNameToken.namespaceId != 0L && binXMLQNameToken.uri == null) {
                BinXMLNamespaceToken binXMLNamespaceToken = this.tokenMngr.getNamespaceToken(binXMLQNameToken.namespaceId);
                binXMLQNameToken.uri = binXMLNamespaceToken != null ? binXMLNamespaceToken.getLocalName() : null;
            }
        }
        return binXMLQNameToken;
    }

    private String getNamespace(long l) throws BinXMLException {
        if (l == 0L) {
            return "";
        }
        String string = null;
        this.mutableLong.setValue(l);
        if (this.localDefs) {
            String string2 = string = this.seqId ? this.nsTableSeq.get((int)l) : this.nsTable.get(this.mutableLong);
        }
        if (string == null) {
            BinXMLNamespaceToken binXMLNamespaceToken = this.tokenMngr.getNamespaceToken(l);
            string = binXMLNamespaceToken != null ? binXMLNamespaceToken.getLocalName() : null;
        }
        return string;
    }

    private void initLocal() {
        this.localDefs = false;
        this.seqId = false;
        this.qnTable = new ConcurrentHashMap(100);
        this.nsTable = new ConcurrentHashMap(25);
        this.qnTableSeq = new Vector(128);
        this.nsTableSeq = new Vector(128);
    }

    private void resetLocal() {
        this.localDefs = false;
        this.seqId = false;
        if (this.nsTable != null) {
            this.nsTable.clear();
        }
        if (this.qnTable != null) {
            this.qnTable.clear();
        }
    }

    private static String getHexString(byte[] byArray) {
        try {
            String string = "";
            String string2 = "";
            for (int i = 0; i < byArray.length; ++i) {
                string2 = Integer.toHexString(byArray[i] & 0xFF);
                if (string2.length() < 2) {
                    string2 = "0" + string2;
                }
                string = string + string2;
            }
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static {
        reservedPrefixTable = new HashMap();
        reservedPrefixTable.put((short)1, "xml");
        reservedPrefixTable.put((short)2, "xmlns");
        reservedPrefixTable.put((short)3, "xsi");
        reservedPrefixTable.put((short)4, "xsd");
        reservedPrefixTable.put((short)5, "xs");
        reservedPrefixTable.put((short)6, "csx");
        reservedNSPrefixTable = new HashMap();
        reservedNSPrefixTable.put(1L, "xml");
        reservedNSPrefixTable.put(2L, "xmlns");
        reservedNSPrefixTable.put(3L, "xsi");
        reservedNSPrefixTable.put(4L, "xsd");
        reservedNSPrefixTable.put(5L, "csx");
        reservedNSTable = new HashMap();
        reservedNSTable.put((short)1, "http://www.w3.org/XML/1998/namespace");
        reservedNSTable.put((short)2, "http://www.w3.org/XML/2000/xmlns/");
        reservedNSTable.put((short)3, "http://www.w3.org/2001/XMLSchema-instance");
        reservedNSTable.put((short)4, "http://www.w3.org/2001/XMLSchema");
        reservedNSTable.put((short)5, "http://xmlns.oracle.com/2004/csx");
        reservedNSTable.put((short)6, "http://xmlns.oracle.com/xdb");
        reservedNSTable.put((short)7, null);
    }

    private class MutableLong {
        long value;

        MutableLong(long l) {
            this.value = l;
        }

        void setValue(long l) {
            this.value = l;
        }

        public boolean equals(Object object) {
            if (object instanceof MutableLong) {
                return this.value == ((MutableLong)object).value;
            }
            return false;
        }

        public int hashCode() {
            return (int)this.value;
        }
    }

    class PrefixInfo {
        String prefix;
        String uri;
        long nsid;
        short pfxid;

        PrefixInfo(short s, String string, long l) throws BinXMLException {
            this.uri = l != 0L ? BinXMLDecodeReader.this.getNamespace(l) : null;
            this.pfxid = s;
            this.prefix = string;
            this.nsid = l;
        }

        String getUri() throws BinXMLException {
            if (this.uri != null) {
                return this.uri;
            }
            if (this.nsid == 0L) {
                return "";
            }
            return BinXMLDecodeReader.this.getNamespace(this.nsid);
        }

        protected Object clone() {
            try {
                PrefixInfo prefixInfo = new PrefixInfo(this.pfxid, this.prefix, this.nsid);
                prefixInfo.uri = this.uri;
                return prefixInfo;
            }
            catch (BinXMLException binXMLException) {
                return null;
            }
        }
    }

    class DecodeElem
    implements BinXMLConstants {
        byte streamId = (byte)-1;
        String local;
        String prefix;
        String uri;
        long nsid;
        int typeid;
        short pfxid;
        BinXMLProperty prop;
        boolean isAttr;
        short flags;
        long id;
        int offset;
        short kidnum;
        byte schid;
        int nsinx;

        void print() {
            System.out.println("[" + (this.isArrMode() ? "A" : " ") + (this.isSeqMode() ? "S" : " ") + (this.isKidMode() ? "K" : " ") + "](" + this.streamId + ") " + this.local);
        }

        DecodeElem(String string, String string2, String string3, long l, long l2, BinXMLProperty binXMLProperty) {
            this.uri = string;
            this.local = string2;
            this.nsid = l;
            this.prefix = string3;
            this.id = l2;
            this.prop = binXMLProperty;
            this.flags = 0;
            this.typeid = 0;
            this.kidnum = 0;
            this.pfxid = 0;
        }

        DecodeElem(DecodeElem decodeElem) {
            this.prop = decodeElem.prop;
            this.id = decodeElem.id;
            this.uri = decodeElem.uri;
            this.prefix = decodeElem.prefix;
            this.local = decodeElem.local;
            this.nsid = decodeElem.nsid;
            this.flags = 0;
            this.typeid = 0;
            this.kidnum = 0;
            this.pfxid = 0;
        }

        DecodeElem() {
            this.local = null;
            this.prop = null;
            this.id = 0L;
            this.prefix = null;
            this.flags = 0;
            this.pfxid = 0;
            this.typeid = 0;
        }

        protected Object clone() {
            DecodeElem decodeElem = new DecodeElem();
            decodeElem.streamId = this.streamId;
            decodeElem.prop = this.prop;
            decodeElem.id = this.id;
            decodeElem.uri = this.uri;
            decodeElem.prefix = this.prefix;
            decodeElem.local = this.local;
            decodeElem.nsid = this.nsid;
            decodeElem.flags = this.flags;
            decodeElem.typeid = this.typeid;
            decodeElem.kidnum = this.kidnum;
            decodeElem.pfxid = this.pfxid;
            return decodeElem;
        }

        void setArrMode(boolean bl) {
            this.flags = bl ? (short)(this.flags | 1) : (short)(this.flags & 0xFFFFFFFE);
        }

        void setSeqMode(boolean bl) {
            this.flags = bl ? (short)(this.flags | 2) : (short)(this.flags & 0xFFFFFFFD);
        }

        void setKidMode(boolean bl) {
            this.flags = bl ? (short)(this.flags | 0x10) : (short)(this.flags & 0xFFFFFFEF);
        }

        String setPrefix(String string) throws BinXMLException {
            this.prefix = string != null ? string : (this.nsid != 0L ? BinXMLDecodeReader.this.getNSPrefix(this.nsid) : (this.uri != null && this.uri.length() > 0 ? BinXMLDecodeReader.this.getNSPrefix(this.uri) : null));
            return this.prefix;
        }

        String getLocal() {
            return this.local == null ? "" : this.local;
        }

        String getPrefix() {
            return this.prefix == null ? "" : this.prefix;
        }

        String getURI() {
            if (this.uri == null && this.nsid != 0L) {
                try {
                    this.uri = BinXMLDecodeReader.this.getNamespace(this.nsid);
                }
                catch (BinXMLException binXMLException) {
                    this.uri = "";
                }
            }
            return this.uri == null ? "" : this.uri;
        }

        boolean isArrMode() {
            return (this.flags & 1) > 0;
        }

        boolean isSeqMode() {
            return (this.flags & 2) > 0;
        }

        boolean isKidMode() {
            return (this.flags & 0x10) > 0;
        }
    }

    class ElemStack {
        DecodeElem[] stack = new DecodeElem[this.size];
        int sp = 0;
        int size = 128;

        ElemStack() {
            for (int i = 0; i < this.size; ++i) {
                this.stack[i] = new DecodeElem();
            }
        }

        void clear() {
            this.sp = 0;
            if (this.size > 128) {
                this.shrink();
            }
        }

        void expand(int n) {
            this.size = n == -1 ? 128 + this.size : n;
            DecodeElem[] decodeElemArray = new DecodeElem[this.size];
            System.arraycopy(this.stack, 0, decodeElemArray, 0, this.sp);
            this.stack = decodeElemArray;
            for (int i = this.sp; i < this.size; ++i) {
                this.stack[i] = new DecodeElem();
            }
        }

        void shrink() {
            this.size = 128;
            DecodeElem[] decodeElemArray = new DecodeElem[this.size];
            System.arraycopy(this.stack, 0, decodeElemArray, 0, this.size);
            this.stack = decodeElemArray;
        }

        void push(DecodeElem decodeElem) {
            if (this.sp == this.size) {
                this.expand(-1);
            }
            if (this.stack[this.sp] != decodeElem) {
                this.stack[this.sp] = decodeElem;
            }
            ++this.sp;
        }

        DecodeElem pop() throws BinXMLException {
            if (this.sp <= 0) {
                throw new BinXMLException(BinXMLDecodeReader.this.err.getMessage0(35000));
            }
            if (this.sp < 128 && this.size > 256) {
                this.shrink();
            }
            --this.sp;
            return this.stack[this.sp];
        }

        DecodeElem peek() {
            if (this.sp <= 0) {
                return null;
            }
            return this.stack[this.sp - 1];
        }

        DecodeElem get(int n) {
            if (n < 0) {
                return null;
            }
            return this.stack[n];
        }

        DecodeElem getNew(DecodeElem decodeElem) {
            if (this.sp == this.size) {
                this.expand(-1);
            }
            DecodeElem decodeElem2 = this.stack[this.sp];
            decodeElem2.streamId = BinXMLDecodeReader.this.curStream.id;
            decodeElem2.prop = decodeElem.prop;
            decodeElem2.id = decodeElem.id;
            decodeElem2.uri = decodeElem.uri;
            decodeElem2.prefix = decodeElem.prefix;
            decodeElem2.local = decodeElem.local;
            decodeElem2.nsid = decodeElem.nsid;
            decodeElem2.flags = 0;
            decodeElem2.typeid = 0;
            decodeElem2.kidnum = 0;
            return decodeElem2;
        }

        DecodeElem getNew() {
            if (this.sp == this.size) {
                this.expand(-1);
            }
            DecodeElem decodeElem = this.stack[this.sp];
            decodeElem.flags = 0;
            decodeElem.typeid = 0;
            decodeElem.kidnum = 0;
            decodeElem.local = null;
            decodeElem.nsid = 0L;
            decodeElem.uri = null;
            decodeElem.id = 0L;
            return decodeElem;
        }

        int size() {
            return this.sp;
        }

        boolean empty() {
            return this.sp <= 0;
        }

        void copy(ElemStack elemStack) {
            if (this.size < elemStack.sp) {
                this.expand(elemStack.sp);
            }
            this.sp = elemStack.sp;
            for (int i = 0; i < elemStack.sp; ++i) {
                DecodeElem decodeElem = elemStack.get(i);
                this.stack[i].streamId = decodeElem.streamId;
                this.stack[i].prop = decodeElem.prop;
                this.stack[i].id = decodeElem.id;
                this.stack[i].uri = decodeElem.uri;
                this.stack[i].prefix = decodeElem.prefix;
                this.stack[i].local = decodeElem.local;
                this.stack[i].nsid = decodeElem.nsid;
                this.stack[i].flags = decodeElem.flags;
                this.stack[i].typeid = decodeElem.typeid;
                this.stack[i].kidnum = decodeElem.kidnum;
            }
        }

        void print() {
            System.out.println("\n-----------------------");
            for (int i = this.sp - 1; i >= 0; --i) {
                this.stack[i].print();
            }
            System.out.println("-----------------------");
        }
    }

    private class MarkInfo {
        byte id;
        int lmark;
        int gmark;
        int endmark;

        MarkInfo(byte by, int n, int n2) {
            this.id = by;
            this.lmark = n;
            this.gmark = n2;
            this.endmark = Integer.MAX_VALUE;
        }

        protected Object clone() {
            MarkInfo markInfo = new MarkInfo(this.id, this.lmark, this.gmark);
            markInfo.endmark = this.endmark;
            return markInfo;
        }
    }

    class DecodeStream {
        byte id;
        String href;
        BinXMLStreamImpl stream;
        ArrayList schemaTable;
        ConcurrentHashMap<Short, PrefixInfo> prefixTable;
        ConcurrentHashMap<MutableLong, PrefixInfo> nsPrefixTable;
        int ladata;
        DecodeElem laElem;
        private int readPos;
        private int pageid;
        private byte[] buffer;
        private byte[] buf;
        String locator;

        DecodeStream(BinXMLStreamImpl binXMLStreamImpl, byte by) {
            this.stream = binXMLStreamImpl;
            this.id = by;
            this.href = null;
            this.init();
        }

        DecodeStream(String string, byte by) throws BinXMLException {
            File file = new File(string);
            this.stream = (BinXMLStreamImpl)BinXMLDecodeReader.this.binXMLProc.createBinXMLStream(file);
            this.id = by;
            this.href = string;
            this.init();
        }

        private void init() {
            this.schemaTable = new ArrayList(10);
            this.prefixTable = new ConcurrentHashMap();
            this.nsPrefixTable = new ConcurrentHashMap();
            this.buffer = new byte[128];
            this.buffer = this.stream.load(0, false);
            this.pageid = 0;
            this.readPos = 0;
            this.ladata = 0;
            this.laElem = null;
            this.locator = null;
            this.buf = new byte[128];
        }

        void copy(DecodeStream decodeStream) {
            this.schemaTable = (ArrayList)decodeStream.schemaTable.clone();
            this.prefixTable = decodeStream.prefixTable;
            this.nsPrefixTable = decodeStream.nsPrefixTable;
            this.id = decodeStream.id;
            this.href = decodeStream.href;
            this.stream = decodeStream.stream;
        }

        short nextByte() throws BinXMLException {
            try {
                if (this.readPos >= BinXMLStreamImpl.BUFSIZE) {
                    this.stream.unload(this.pageid, false, this.buffer);
                    this.buffer = this.stream.load(++this.pageid, false);
                    this.readPos = 0;
                }
                return (short)(this.buffer[this.readPos] & 0xFF);
            }
            catch (Exception exception) {
                throw new BinXMLException(exception.toString());
            }
        }

        short nextByte2() throws BinXMLException {
            try {
                if (this.readPos + 1 >= BinXMLStreamImpl.BUFSIZE) {
                    this.stream.unload(this.pageid, false, this.buffer);
                    this.buffer = this.stream.load(++this.pageid, false);
                    short s = (short)(this.buffer[0] & 0xFF);
                    this.stream.unload(this.pageid, false, this.buffer);
                    this.buffer = this.stream.load(--this.pageid, false);
                    return s;
                }
                return (short)(this.buffer[this.readPos + 1] & 0xFF);
            }
            catch (Exception exception) {
                throw new BinXMLException(exception.toString());
            }
        }

        short readOpcode() throws BinXMLException {
            if (this.readPos >= BinXMLStreamImpl.BUFSIZE) {
                this.upload();
            }
            ++BinXMLDecodeReader.this.mark;
            if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
            }
            return (short)(this.buffer[this.readPos++] & 0xFF);
        }

        long readLong1() throws BinXMLException {
            if (this.readPos >= BinXMLStreamImpl.BUFSIZE) {
                this.upload();
            }
            ++BinXMLDecodeReader.this.mark;
            if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
            }
            return this.buffer[this.readPos++] & 0xFF;
        }

        long readLong2() throws BinXMLException {
            long l;
            if (this.readPos + 2 < BinXMLStreamImpl.BUFSIZE) {
                l = (this.buffer[this.readPos++] & 0xFF) << 8;
                l += (long)(this.buffer[this.readPos++] & 0xFF);
            } else {
                if (this.readPos >= BinXMLStreamImpl.BUFSIZE) {
                    this.upload();
                }
                l = (this.buffer[this.readPos++] & 0xFF) << 8;
                if (this.readPos >= BinXMLStreamImpl.BUFSIZE) {
                    this.upload();
                }
                l += (long)(this.buffer[this.readPos++] & 0xFF);
            }
            BinXMLDecodeReader.this.mark += 2;
            if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
            }
            return l;
        }

        long readLong4() throws BinXMLException {
            long l;
            if (this.readPos + 4 < BinXMLStreamImpl.BUFSIZE) {
                l = (this.buffer[this.readPos++] & 0xFF) << 24;
                l += (long)((this.buffer[this.readPos++] & 0xFF) << 16);
                l += (long)((this.buffer[this.readPos++] & 0xFF) << 8);
                l += (long)(this.buffer[this.readPos++] & 0xFF);
            } else {
                l = 0L;
                for (int i = 24; i >= 0; i -= 8) {
                    if (this.readPos >= BinXMLStreamImpl.BUFSIZE) {
                        this.upload();
                    }
                    l += (long)((this.buffer[this.readPos++] & 0xFF) << i);
                }
            }
            BinXMLDecodeReader.this.mark += 4;
            if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
            }
            return l;
        }

        BigInteger readBigInteger() throws BinXMLException {
            int n;
            byte[] byArray = new byte[9];
            byArray[0] = 0;
            if (this.readPos + 8 < BinXMLStreamImpl.BUFSIZE) {
                for (n = 1; n < 9; ++n) {
                    byArray[n] = this.buffer[this.readPos++];
                }
            } else {
                for (n = 1; n < 9; ++n) {
                    if (this.readPos >= BinXMLStreamImpl.BUFSIZE) {
                        this.upload();
                    }
                    byArray[n] = this.buffer[this.readPos++];
                }
            }
            BinXMLDecodeReader.this.mark += 8;
            if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
            }
            BigInteger bigInteger = new BigInteger(byArray);
            return bigInteger;
        }

        long readLong8() throws BinXMLException {
            int n;
            byte[] byArray = new byte[8];
            if (this.readPos + 8 < BinXMLStreamImpl.BUFSIZE) {
                for (n = 0; n < 8; ++n) {
                    byArray[n] = this.buffer[this.readPos++];
                }
            } else {
                for (n = 0; n < 8; ++n) {
                    if (this.readPos >= BinXMLStreamImpl.BUFSIZE) {
                        this.upload();
                    }
                    byArray[n] = this.buffer[this.readPos++];
                }
            }
            BinXMLDecodeReader.this.mark += 8;
            if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
            }
            BigInteger bigInteger = new BigInteger(byArray);
            return bigInteger.longValue();
        }

        long readLong8r() throws BinXMLException {
            long l = BinXMLDecodeReader.this.readNum4r();
            long l2 = BinXMLDecodeReader.this.readNum4r();
            if (l2 != 0L) {
                l2 *= 0x100000000L;
            }
            return l2 + l;
        }

        private String readString(long l) throws BinXMLException {
            String string;
            if (l >= Integer.MAX_VALUE || l < 0L) {
                String string2 = BinXMLDecodeReader.this.err.getMessage0(35017);
                throw new BinXMLException(string2);
            }
            long l2 = (long)this.readPos + l;
            try {
                if (l2 >= (long)BinXMLStreamImpl.BUFSIZE) {
                    this.readBytes(l);
                    string = new String(this.buf, 0, (int)l, "UTF-8");
                } else {
                    string = new String(this.buffer, this.readPos, (int)l, "UTF-8");
                    this.readPos = (int)l2;
                    BinXMLDecodeReader.this.mark = (int)((long)BinXMLDecodeReader.this.mark + l);
                    if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                        BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
                    }
                }
            }
            catch (Exception exception) {
                throw new BinXMLException(exception);
            }
            return string;
        }

        private int readCESU8orUTF8(byte[] byArray, int n, int n2) throws BinXMLException {
            return this.readCESU8orUTF8(byArray, n, n2, false);
        }

        private int readCESU8orUTF8(byte[] byArray, int n, int n2, boolean bl) throws BinXMLException {
            if (BinXMLDecodeReader.this.charbuf.length < n2) {
                BinXMLDecodeReader.this.charbuf = new char[n2];
            }
            int n3 = n + n2;
            int n4 = 0;
            boolean bl2 = true;
            while (n < n3) {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                if ((n10 = byArray[n++] & 0xFF) <= 127) {
                    BinXMLDecodeReader.this.charbuf[n4++] = (char)n10;
                    continue;
                }
                if (n10 <= 193) {
                    bl2 = false;
                    break;
                }
                if (n10 <= 223) {
                    if (n + 1 > n3) {
                        bl2 = false;
                        break;
                    }
                    if (128 > (n9 = byArray[n++] & 0xFF) || n9 > 191) {
                        bl2 = false;
                        break;
                    }
                    n8 = ((n10 & 0x1F) << 6) + (n9 & 0x3F);
                    if (128 > n8 || n8 > 2047) {
                        bl2 = false;
                        break;
                    }
                } else if (n10 <= 239) {
                    if (n + 2 > n3) {
                        bl2 = false;
                        break;
                    }
                    n9 = byArray[n++] & 0xFF;
                    n7 = byArray[n++] & 0xFF;
                    if (n10 == 224) {
                        n6 = 160;
                        n5 = 191;
                    } else if (225 <= n10 && n10 <= 236) {
                        n6 = 128;
                        n5 = 191;
                    } else if (n10 == 237) {
                        n6 = 128;
                        n5 = 191;
                    } else if (238 <= n10 && n10 <= 239) {
                        n6 = 128;
                        n5 = 191;
                    } else {
                        bl2 = false;
                        break;
                    }
                    if (128 > n7 || n7 > 191 || n6 > n9 || n9 > n5) {
                        bl2 = false;
                        break;
                    }
                    n8 = ((n10 & 0xF) << 12) + ((n9 & 0x3F) << 6) + (n7 & 0x3F);
                    if (n8 == 65535 || n8 == 65534 || 2048 > n8 || n8 > 65535) {
                        bl2 = false;
                        break;
                    }
                } else if (n10 <= 244) {
                    int n11;
                    if (n + 3 > n3) {
                        bl2 = false;
                        break;
                    }
                    n9 = byArray[n++] & 0xFF;
                    n7 = byArray[n++] & 0xFF;
                    n6 = byArray[n++] & 0xFF;
                    if (n10 == 240) {
                        n5 = 144;
                        n11 = 191;
                    } else if (241 <= n10 && n10 <= 243) {
                        n5 = 128;
                        n11 = 191;
                    } else if (n10 == 244) {
                        n5 = 128;
                        n11 = 143;
                    } else {
                        bl2 = false;
                        break;
                    }
                    if (128 > n7 || n7 > 191 || 128 > n6 || n6 > 191 || n5 > n9 || n9 > n11) {
                        bl2 = false;
                        break;
                    }
                    n8 = ((n10 & 7) << 18) + ((n9 & 0x3F) << 12) + ((n7 & 0x3F) << 6) + (n6 & 0x3F);
                    if (!Character.isSupplementaryCodePoint(n8)) {
                        bl2 = false;
                        break;
                    }
                } else {
                    bl2 = false;
                    break;
                }
                n4 += Character.toChars(n8, BinXMLDecodeReader.this.charbuf, n4);
            }
            if (!(bl2 || bl && n + 6 >= n3)) {
                throw new BinXMLException(BinXMLDecodeReader.this.err.getMessage0(20170));
            }
            return n4;
        }

        private char[] readChars(long l, int n) throws BinXMLException {
            long l2 = (long)this.readPos + l;
            BinXMLDecodeReader.this.datalen = 0L;
            try {
                if (l2 >= (long)BinXMLStreamImpl.BUFSIZE) {
                    this.readBytes(n);
                    this.skipBytes(l - (long)n);
                    BinXMLDecodeReader.this.datalen = this.readCESU8orUTF8(this.buf, 0, n);
                } else {
                    BinXMLDecodeReader.this.datalen = this.readCESU8orUTF8(this.buffer, this.readPos, (int)l);
                    this.readPos = (int)l2;
                    BinXMLDecodeReader.this.mark = (int)((long)BinXMLDecodeReader.this.mark + l);
                    if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                        BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
                    }
                }
            }
            catch (Exception exception) {
                throw new BinXMLException(exception.getMessage());
            }
            return BinXMLDecodeReader.this.charbuf;
        }

        private char[] readChars(long l) throws BinXMLException {
            long l2 = (long)this.readPos + l;
            BinXMLDecodeReader.this.datalen = 0L;
            try {
                if (l2 >= (long)BinXMLStreamImpl.BUFSIZE) {
                    this.readBytes(l);
                    BinXMLDecodeReader.this.datalen = this.readCESU8orUTF8(this.buf, 0, (int)l);
                } else {
                    BinXMLDecodeReader.this.datalen = this.readCESU8orUTF8(this.buffer, this.readPos, (int)l);
                    this.readPos = (int)l2;
                    BinXMLDecodeReader.this.mark = (int)((long)BinXMLDecodeReader.this.mark + l);
                    if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                        BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
                    }
                }
            }
            catch (Exception exception) {
                throw new BinXMLException(exception.getMessage());
            }
            return BinXMLDecodeReader.this.charbuf;
        }

        private long readBytes(byte[] byArray, long l) throws BinXMLException {
            try {
                for (long i = 0L; i < l; ++i) {
                    if (this.readPos >= BinXMLStreamImpl.BUFSIZE) {
                        this.stream.unload(this.pageid, false, this.buffer);
                        this.buffer = this.stream.load(++this.pageid, false);
                        this.readPos = 0;
                    }
                    byArray[(int)i] = this.buffer[this.readPos++];
                }
                BinXMLDecodeReader.this.mark = (int)((long)BinXMLDecodeReader.this.mark + l);
                if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                    BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
                }
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                throw new BinXMLException(string);
            }
            return l;
        }

        private final void readBytes(long l) throws BinXMLException {
            if (l >= Integer.MAX_VALUE || l < 0L) {
                String string = BinXMLDecodeReader.this.err.getMessage0(35017);
                throw new BinXMLException(string);
            }
            if ((long)this.buf.length >= l) {
                this.buf = new byte[(int)l];
                long l2 = this.readBytes(this.buf, l);
                if (l2 < l) {
                    String string = BinXMLDecodeReader.this.err.getMessage0(35001);
                    throw new BinXMLException(string);
                }
            } else {
                long l3;
                int n = 128;
                Object object = new byte[]{};
                for (long i = l; i > 0L; i -= l3) {
                    Object object2;
                    byte[] byArray;
                    if (i > (long)n) {
                        n *= 2;
                    }
                    if ((long)n > i) {
                        n = (int)i;
                    }
                    if ((l3 = this.readBytes(byArray = new byte[n], byArray.length)) != (long)byArray.length) {
                        object2 = BinXMLDecodeReader.this.err.getMessage0(35001);
                        throw new BinXMLException((String)object2);
                    }
                    object2 = new byte[((byte[])object).length + byArray.length];
                    System.arraycopy(object, 0, object2, 0, ((byte[])object).length);
                    System.arraycopy(byArray, 0, object2, ((byte[])object).length, byArray.length);
                    object = object2;
                }
                this.buf = object;
            }
        }

        void upload() throws BinXMLException {
            try {
                this.stream.unload(this.pageid, false, this.buffer);
                this.buffer = this.stream.load(++this.pageid, false);
                this.readPos = 0;
            }
            catch (Exception exception) {
                throw new BinXMLException(exception.getMessage());
            }
        }

        long skipBytes(long l) throws BinXMLException {
            if (l >= Integer.MAX_VALUE || l < 0L) {
                String string = BinXMLDecodeReader.this.err.getMessage0(35017);
                throw new BinXMLException(string);
            }
            int n = (int)l + this.readPos;
            try {
                if (n >= BinXMLStreamImpl.BUFSIZE) {
                    this.setLMark(BinXMLDecodeReader.this.mark + (int)l);
                } else {
                    this.readPos = n;
                }
                BinXMLDecodeReader.this.mark = (int)((long)BinXMLDecodeReader.this.mark + l);
                if (BinXMLDecodeReader.this.mark > BinXMLDecodeReader.this.lastmark) {
                    BinXMLDecodeReader.this.lastmark = BinXMLDecodeReader.this.mark;
                }
            }
            catch (Exception exception) {
                throw new BinXMLException(exception.getMessage());
            }
            return l;
        }

        void setLMark(int n) {
            int n2 = n / BinXMLStreamImpl.BUFSIZE;
            if (n2 != this.pageid) {
                this.stream.unload(this.pageid, false, this.buffer);
                this.pageid = n2;
                this.buffer = this.stream.load(this.pageid, false);
            }
            this.readPos = n % BinXMLStreamImpl.BUFSIZE;
            this.ladata = 0;
        }

        int getLMark() {
            return this.readPos + this.pageid * BinXMLStreamImpl.BUFSIZE;
        }
    }

    static class BinXMLLocator
    extends Locator2Impl
    implements XMLLocator {
        private String standalone = null;

        @Override
        public String getDeclEncoding() {
            return super.getEncoding();
        }

        void setStandalone(String string) {
            this.standalone = string;
        }

        @Override
        public String getStandalone() {
            return this.standalone;
        }
    }
}

