/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.emCfg.types.IStatusResourceType;

public class StatusResourceType
implements IStatusResourceType,
Serializable {
    private static final long serialVersionUID = -6807982548576563759L;
    private static final Set alreadyDefined = new HashSet();
    private static final List localizedMembers = new Vector();
    private static final int BASE_RESOURCE_IDENTIFIER = 1234;
    public static final StatusResourceType SUCCESS = new StatusResourceType(0, "Success", 1234);
    public static final StatusResourceType FAILURE = new StatusResourceType(-1, "Failure", 1235);
    public static final StatusResourceType NO_RESOURCE = new StatusResourceType(-1, "CfwStatus:No Resource Identifier for:", 1237);
    public static final StatusResourceType UNINMPLEMENTED_FEATURE = new StatusResourceType(-1, "This has not been implemented in this release.", 1238);
    private final int statusValue;
    private final int resourceIdent;
    private final String briefString;

    public StatusResourceType(int statusValue, String briefString) {
        this(statusValue, briefString, 0);
    }

    public StatusResourceType(int statusValue, String briefString, int resourceIdent) {
        this.statusValue = statusValue;
        this.briefString = briefString;
        this.resourceIdent = resourceIdent;
        if (resourceIdent == 0) {
            return;
        }
        if (alreadyDefined != null && alreadyDefined.contains(new Integer(resourceIdent))) {
            throw new Error("CfwStatus:Non-Unique Ident is given: " + briefString + ":" + resourceIdent);
        }
        alreadyDefined.add(new Integer(resourceIdent));
        localizedMembers.add(this);
    }

    public List getLocalizedStatuses() {
        return localizedMembers;
    }

    public String toString() {
        return this.briefString;
    }

    @Override
    public int getStatusValue() {
        return this.statusValue;
    }

    @Override
    public String getStatusBriefString() {
        return this.briefString;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StatusResourceType)) {
            return false;
        }
        StatusResourceType imposter = (StatusResourceType)o;
        if (imposter.resourceIdent != 0) {
            return this.resourceIdent == imposter.resourceIdent;
        }
        return this.briefString.equals(imposter.briefString);
    }

    public int hashCode() {
        return this.briefString.hashCode();
    }
}

