/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.types;

import java.util.List;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.AlternatingCustomizableType;
import oracle.sysman.emCfg.types.OperationType;

public final class PlugInType
extends AlternatingCustomizableType {
    public static final PlugInType PROVISION = new PlugInType(0, "provision");
    public static final PlugInType CONFIGURE = new PlugInType(1, "configure");
    public static final PlugInType ALTER_GENTLE = new PlugInType(2, "alter:gentle");
    public static final PlugInType CLONE_GENTLE = new PlugInType(3, "clone:gentle");
    public static final PlugInType PURGE_GENTLE = new PlugInType(4, "purge:gentle");
    public static final PlugInType UPDGRADE_GENTLE = new PlugInType(5, "upgrade:gentle");
    public static final PlugInType ALTER_DRASTIC = new PlugInType(6, "alter:drastic");
    public static final PlugInType CLONE_DRASTIC = new PlugInType(7, "clone:drastic");
    public static final PlugInType PURGE_DRASTIC = new PlugInType(8, "purge:drastic");
    public static final PlugInType UPDGRADE_DRASTIC = new PlugInType(9, "upgrade:drastic");
    public static final PlugInType ACTIVATE = new PlugInType(10, "activate");
    public static final PlugInType DEACTIVATE = new PlugInType(11, "deactivate");
    public static final PlugInType ADD_LANGUAGE = new PlugInType(12, "add_language");
    public static final PlugInType ADD_NODE = new PlugInType(13, "add_node");
    public static final PlugInType GENERALIZE = new PlugInType(14, "generalize");
    public static final PlugInType SIMPLIFY = new PlugInType(15, "simplify");
    public static final PlugInType GROW = new PlugInType(16, "grow");
    public static final PlugInType SHRINK = new PlugInType(16, "shrink");
    public static final PlugInType ADD = new PlugInType(17, "add");
    public static final PlugInType DELETE = new PlugInType(18, "delete");
    public static final PlugInType UNKNOWN = new PlugInType(19, "unknown");

    private PlugInType(int numVal, String brief) {
        super(numVal, brief);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PlugInType)) {
            throw new Error("PlugInType:equals:Object o is of a wrong type " + o);
        }
        return super.equals(o);
    }

    private static PlugInType newCustom(String flavor) {
        List members = PlugInType.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            PlugInType plugInType;
            Object obj = members.get(i);
            if (!(obj instanceof PlugInType) || !flavor.equals((plugInType = (PlugInType)obj).getStatusBriefString())) continue;
            return plugInType;
        }
        PlugInType custom = new PlugInType(PlugInType.getMembers().size(), flavor);
        return custom;
    }

    public boolean within(PlugInType[] types) {
        return super.within(types);
    }

    public static PlugInType getType(String typeName) throws CfwException {
        CfmUtil.preconditionNotNull(typeName, "typeName");
        if (typeName.equals(PROVISION.getStatusBriefString())) {
            return PROVISION;
        }
        if (typeName.equals(CONFIGURE.getStatusBriefString())) {
            return CONFIGURE;
        }
        if (typeName.equals(ALTER_GENTLE.getStatusBriefString())) {
            return ALTER_GENTLE;
        }
        if (typeName.equals(CLONE_GENTLE.getStatusBriefString())) {
            return CLONE_GENTLE;
        }
        if (typeName.equals(PURGE_GENTLE.getStatusBriefString())) {
            return PURGE_GENTLE;
        }
        if (typeName.equals(UPDGRADE_GENTLE.getStatusBriefString())) {
            return UPDGRADE_GENTLE;
        }
        if (typeName.equals(ALTER_DRASTIC.getStatusBriefString())) {
            return ALTER_DRASTIC;
        }
        if (typeName.equals(CLONE_DRASTIC.getStatusBriefString())) {
            return CLONE_DRASTIC;
        }
        if (typeName.equals(PURGE_DRASTIC.getStatusBriefString())) {
            return PURGE_DRASTIC;
        }
        if (typeName.equals(UPDGRADE_DRASTIC.getStatusBriefString())) {
            return UPDGRADE_DRASTIC;
        }
        if (typeName.equals(ACTIVATE.getStatusBriefString())) {
            return ACTIVATE;
        }
        if (typeName.equals(DEACTIVATE.getStatusBriefString())) {
            return DEACTIVATE;
        }
        if (typeName.equals(ADD_LANGUAGE.getStatusBriefString())) {
            return ADD_LANGUAGE;
        }
        if (typeName.equals(ADD_NODE.getStatusBriefString())) {
            return ADD_NODE;
        }
        if (typeName.equals(GENERALIZE.getStatusBriefString())) {
            return GENERALIZE;
        }
        if (typeName.equals(SIMPLIFY.getStatusBriefString())) {
            return SIMPLIFY;
        }
        if (typeName.equals(GROW.getStatusBriefString())) {
            return GROW;
        }
        if (typeName.equals(SHRINK.getStatusBriefString())) {
            return SHRINK;
        }
        if (typeName.equals(ADD.getStatusBriefString())) {
            return ADD;
        }
        if (typeName.equals(DELETE.getStatusBriefString())) {
            return DELETE;
        }
        if (typeName.equals(UNKNOWN.getStatusBriefString())) {
            return UNKNOWN;
        }
        if (typeName.startsWith("custom:")) {
            return PlugInType.newCustom(typeName);
        }
        throw new CfwException("\"" + typeName + "\" is not a valid PlugInType.");
    }

    public boolean within(ActionType[] types) {
        if (types == null || types.length == 0) {
            return false;
        }
        if (this.equals(PROVISION) && ActionType.PROVISIONING.within(types)) {
            return true;
        }
        if (this.equals(CONFIGURE) && ActionType.CONFIGURATION.within(types)) {
            return true;
        }
        if (this.equals(ALTER_GENTLE) && ActionType.ALTERATION_GENTLE.within(types)) {
            return true;
        }
        if (this.equals(CLONE_GENTLE) && ActionType.CLONING_GENTLE.within(types)) {
            return true;
        }
        if (this.equals(PURGE_GENTLE) && ActionType.PURGING_GENTLE.within(types)) {
            return true;
        }
        if (this.equals(UPDGRADE_GENTLE) && ActionType.PATCH_SET_CONFIGURE.within(types)) {
            return true;
        }
        if (this.equals(ALTER_DRASTIC) && ActionType.ALTERATION_DRASTIC.within(types)) {
            return true;
        }
        if (this.equals(CLONE_DRASTIC) && ActionType.CLONING_DRASTIC.within(types)) {
            return true;
        }
        if (this.equals(PURGE_DRASTIC) && ActionType.PURGING_DRASTIC.within(types)) {
            return true;
        }
        if (this.equals(UPDGRADE_DRASTIC) && ActionType.UPGRADE.within(types)) {
            return true;
        }
        if (this.equals(ACTIVATE) && ActionType.ACTIVATION.within(types)) {
            return true;
        }
        if (this.equals(DEACTIVATE) && ActionType.DEACTIVATION.within(types)) {
            return true;
        }
        if (this.equals(ADD_LANGUAGE) && ActionType.ADDING_LANGUAGE.within(types)) {
            return true;
        }
        if (this.equals(ADD_NODE) && ActionType.ADDING_NODE.within(types)) {
            return true;
        }
        return this.equals(UNKNOWN);
    }

    public boolean correspondsTo(ActionType type) {
        if (type == null) {
            throw new Error("null is not allowed");
        }
        if (this.equals(PROVISION) && type.equals(ActionType.PROVISIONING)) {
            return true;
        }
        if (this.equals(CONFIGURE) && type.equals(ActionType.CONFIGURATION)) {
            return true;
        }
        if (this.equals(ALTER_GENTLE) && type.equals(ActionType.ALTERATION_GENTLE)) {
            return true;
        }
        if (this.equals(CLONE_GENTLE) && type.equals(ActionType.CLONING_GENTLE)) {
            return true;
        }
        if (this.equals(PURGE_GENTLE) && type.equals(ActionType.PURGING_GENTLE)) {
            return true;
        }
        if (this.equals(UPDGRADE_GENTLE) && type.equals(ActionType.PATCH_SET_CONFIGURE)) {
            return true;
        }
        if (this.equals(ALTER_DRASTIC) && type.equals(ActionType.ALTERATION_DRASTIC)) {
            return true;
        }
        if (this.equals(CLONE_DRASTIC) && type.equals(ActionType.CLONING_DRASTIC)) {
            return true;
        }
        if (this.equals(PURGE_DRASTIC) && type.equals(ActionType.PURGING_DRASTIC)) {
            return true;
        }
        if (this.equals(UPDGRADE_DRASTIC) && type.equals(ActionType.UPGRADE)) {
            return true;
        }
        if (this.equals(ACTIVATE) && type.equals(ActionType.ACTIVATION)) {
            return true;
        }
        if (this.equals(DEACTIVATE) && type.equals(ActionType.DEACTIVATION)) {
            return true;
        }
        if (this.equals(ADD_LANGUAGE) && type.equals(ActionType.ADDING_LANGUAGE)) {
            return true;
        }
        if (this.equals(ADD_NODE) && type.equals(ActionType.ADDING_NODE)) {
            return true;
        }
        if (this.isCustom() && type.isCustom() && ((AlternatingCustomizableType)type).equals(this)) {
            return true;
        }
        return this.equals(UNKNOWN);
    }

    public boolean within(OperationType[] types) {
        if (types == null || types.length == 0) {
            return false;
        }
        if (this.equals(GENERALIZE) && OperationType.GENERALIZATION.within(types)) {
            return true;
        }
        if (this.equals(SIMPLIFY) && OperationType.SIMPLIFICATION.within(types)) {
            return true;
        }
        if (this.equals(GROW) && OperationType.GROWING.within(types)) {
            return true;
        }
        if (this.equals(SHRINK) && OperationType.SHRINKING.within(types)) {
            return true;
        }
        if (this.equals(ADD) && OperationType.ADDING.within(types)) {
            return true;
        }
        if (this.equals(DELETE) && OperationType.DELETION.within(types)) {
            return true;
        }
        return this.equals(UNKNOWN);
    }

    public boolean correspondsTo(OperationType type) {
        if (type == null) {
            throw new Error("null is not allowed");
        }
        if (this.equals(GENERALIZE) && type.equals(OperationType.GENERALIZATION)) {
            return true;
        }
        if (this.equals(SIMPLIFY) && type.equals(OperationType.SIMPLIFICATION)) {
            return true;
        }
        if (this.equals(GROW) && type.equals(OperationType.GROWING)) {
            return true;
        }
        if (this.equals(SHRINK) && type.equals(OperationType.SHRINKING)) {
            return true;
        }
        if (this.equals(ADD) && type.equals(OperationType.ADDING)) {
            return true;
        }
        if (this.equals(DELETE) && type.equals(OperationType.DELETION)) {
            return true;
        }
        return this.equals(UNKNOWN);
    }
}

