/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.types;

import java.util.List;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.types.StatusOrType;

public final class ParameterType
extends StatusOrType {
    public static final ParameterType SIMPLEST = new ParameterType(0, "SIMPLEST", "Simplest is the one that does most of the work");
    public static final ParameterType SIMPLEST_ARRAY = new ParameterType(1, "SIMPLEST_ARRAY", "An array of SIMPLEST parameters");
    public static final ParameterType SIMPLE = new ParameterType(2, "SIMPLE", "Simple that has SIMPLEST parameters");
    public static final ParameterType SIMPLE_ARRAY = new ParameterType(3, "SIMPLE_ARRAY", "An array of SIMPLE parameters");
    public static final ParameterType COMPLEX = new ParameterType(4, "COMPLEX", "Complex parameter that has any type parameters");
    public static final ParameterType ARRAY = new ParameterType(5, "ARRAY", "Array of parameters of the same but any type");
    public static final ParameterType UNRESOLVED = new ParameterType(6, "UNRESOLVED", "The parameter could not be found");
    private final String ident;

    private ParameterType(int numVal, String ident, String brief) {
        super(numVal, brief);
        this.ident = ident;
    }

    public String getIdent() {
        return this.ident;
    }

    public List getTypes() {
        return ParameterType.getMembers();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ParameterType)) {
            throw new Error("wrong type");
        }
        return super.equals(o);
    }

    public boolean within(ParameterType[] types) {
        return super.within(types);
    }

    public static ParameterType getType(String typeS) throws CfwException {
        if (typeS == null || (typeS = typeS.trim()).length() == 0) {
            throw new CfwException("ParameterType.getType: invalid (null or empty) request");
        }
        if (typeS.equalsIgnoreCase(SIMPLEST.getIdent())) {
            return SIMPLEST;
        }
        if (typeS.equalsIgnoreCase(SIMPLEST_ARRAY.getIdent())) {
            return SIMPLEST_ARRAY;
        }
        if (typeS.equalsIgnoreCase(SIMPLE.getIdent())) {
            return SIMPLE;
        }
        if (typeS.equalsIgnoreCase(SIMPLE_ARRAY.getIdent())) {
            return SIMPLE_ARRAY;
        }
        if (typeS.equalsIgnoreCase(COMPLEX.getIdent())) {
            return COMPLEX;
        }
        if (typeS.equalsIgnoreCase(ARRAY.getIdent())) {
            return ARRAY;
        }
        if (typeS.equalsIgnoreCase(UNRESOLVED.getIdent())) {
            return UNRESOLVED;
        }
        throw new CfwException("ParameterType.getType: invalid request " + typeS);
    }
}

