/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.types;

import java.util.List;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.types.IStatus;
import oracle.sysman.emCfg.types.StatusOrType;

public final class ParameterStatus
extends StatusOrType
implements IStatus {
    public static final ParameterStatus IS_DEFAULT = new ParameterStatus(0, "IS_DEFAULT", "Has default value");
    public static final ParameterStatus IS_ASSIGNED = new ParameterStatus(1, "IS_ASSIGNED", "Has successfully been assigned");
    public static final ParameterStatus ASSIGN_FAILED = new ParameterStatus(2, "ASSIGN_FAILED", "Assignment has failed");
    public static final ParameterStatus NO_DATA = new ParameterStatus(3, "NO_DATA", "No data");
    private String ident;

    private ParameterStatus(int numVal, String ident, String brief) {
        super(numVal, brief);
        this.ident = ident;
    }

    public String getIdent() {
        return this.ident;
    }

    public List getStatuses() {
        return ParameterStatus.getMembers();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ParameterStatus)) {
            throw new Error("wrong type");
        }
        return super.equals(o);
    }

    public boolean within(ParameterStatus[] types) {
        return super.within(types);
    }

    public static ParameterStatus getStatus(String statusS) throws CfwException {
        if (statusS == null || (statusS = statusS.trim()).length() == 0) {
            throw new CfwException("ParameterStatus.getStatus: invalid (null or empty) request");
        }
        if (statusS.equalsIgnoreCase(IS_DEFAULT.getIdent())) {
            return IS_DEFAULT;
        }
        if (statusS.equalsIgnoreCase(IS_ASSIGNED.getIdent())) {
            return IS_ASSIGNED;
        }
        if (statusS.equalsIgnoreCase(ASSIGN_FAILED.getIdent())) {
            return ASSIGN_FAILED;
        }
        if (statusS.equalsIgnoreCase(NO_DATA.getIdent())) {
            return NO_DATA;
        }
        throw new CfwException("ParameterStatus.getStatus: invalid request " + statusS);
    }
}

