/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.types;

import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.types.IStatus;
import oracle.sysman.emCfg.types.StatusOrType;

public class MicroStepStatus
extends StatusOrType
implements IStatus {
    private static List VALUES = new Vector();
    public static final MicroStepStatus NOT_PERFORMED = new MicroStepStatus(0, "NOT_PERFORMED", "Has never been performed", "CFM-10201");
    public static final MicroStepStatus PERFORMED_SUCCESS = new MicroStepStatus(1, "PERFORMED_SUCCESS", "Has successfully been performed", "CFM-10202");
    public static final MicroStepStatus PERFORMED_FAILED = new MicroStepStatus(2, "PERFORMED_FAILED", "Has failed its perform method", "CFM-10203");
    public static final MicroStepStatus FAILED_NOTREQUIRED = new MicroStepStatus(3, "FAILED_NOTREQUIRED", "Has failed its optional perform method", "CFM-10208");
    public static final MicroStepStatus IS_PERFORMING = new MicroStepStatus(4, "IS_PERFORMING", "Is running", "CFM-10205");
    public static final MicroStepStatus IS_ABORTING = new MicroStepStatus(5, "IS_ABORTING", "Currently is being aborted", "CFM-10206");
    public static final MicroStepStatus WAS_ABORTED = new MicroStepStatus(6, "WAS_ABORTED", "Has been aborted", "CFM-10207");
    public static final MicroStepStatus UNSPECIFIED_ERROR = new MicroStepStatus(7, "UNSPECIFIED_ERROR", "An unspecified error occurred while attempting to perform the MicroStep", "CFM-10214");
    public static final MicroStepStatus INACTIVE_PLUGIN = new MicroStepStatus(30, "PLUGIN_WAS_INACTIVE", "This MicroStep's PlugIn was set inactive", "CFM-10204");
    public static final MicroStepStatus USE_OF_UNINITIALIZED_PARAMETER = new MicroStepStatus(31, "USE_OF_UNINITIALIZED_PARAMETER", "A PlugIn argument referenced an uninitialized Parameter", "CFM-10213");
    public static final MicroStepStatus INVALID_TARGET = new MicroStepStatus(32, "INVALID_TARGET", "The specified external command or internal PlugIn could not be executed", "CFM-10215");
    public static final MicroStepStatus INACTIVE_PLUGININVOCATION = new MicroStepStatus(33, "PLUGININVOCATION_WAS_INACTIVE", "This MicroStep was set inactive", "CFM-10216");
    public static final MicroStepStatus ACTION_NOT_FOUND = new MicroStepStatus(40, "ACTION_NOT_FOUND", "An action of the specified type could not be found", "CFM-10210");
    public static final MicroStepStatus ACTION_ALREADY_REFERENCED = new MicroStepStatus(41, "ACTION_ALREADY_REFERENCED", "The action was already referred to by a previous MicroStep", "CFM-10212");
    public static final MicroStepStatus AGGREGATE_NOT_AVAILABLE = new MicroStepStatus(50, "AGGREGATE_NOT_AVAILABLE", "The referred aggregate could not be found", "CFM-10209");
    public static final MicroStepStatus AGGREGATE_INACTIVE = new MicroStepStatus(51, "AGGREGATE_INACTIVE", "The reference to the referred aggregate is set inactive", "CFM-10211");
    private final String ident;
    private final String resourceKey;

    private MicroStepStatus(int numVal, String ident, String brief, String resourceKey) {
        super(numVal, brief);
        this.ident = ident;
        this.resourceKey = resourceKey;
        VALUES.add(this);
    }

    public String getIdent() {
        return this.ident;
    }

    String getResourceKey() {
        return this.resourceKey;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MicroStepStatus)) {
            throw new Error("wrong type");
        }
        return super.equals(o);
    }

    public boolean within(MicroStepStatus[] types) {
        return super.within(types);
    }

    public static MicroStepStatus getStatus(String statusS) throws CfwException {
        if (statusS == null || (statusS = statusS.trim()).length() == 0) {
            throw new CfwException("MicroStepStatus.getStatus: invalid (null or empty) request");
        }
        for (MicroStepStatus curr : VALUES) {
            if (!statusS.equalsIgnoreCase(curr.getIdent())) continue;
            return curr;
        }
        throw new CfwException("MicroStepStatus.getStatus: invalid request " + statusS);
    }

    public String getLocalizedBriefString() {
        ResourceBundle rb = ResourceBundle.getBundle("oracle.sysman.emCfg.common.CfmRuntimeRes");
        return rb.getString(this.getResourceKey());
    }

    public boolean skipDuringRetry() {
        return this == PERFORMED_SUCCESS || this == ACTION_ALREADY_REFERENCED;
    }

    public boolean isFatalFailure() {
        return this != PERFORMED_SUCCESS && this != ACTION_ALREADY_REFERENCED && this != AGGREGATE_INACTIVE;
    }
}

