/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.types;

import java.util.List;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.types.StatusOrType;

public final class MicroStepFlavor
extends StatusOrType {
    public static final MicroStepFlavor EXTERNAL_JAVA_INVOCATION = new MicroStepFlavor(0, "EXTERNAL_JAVA_INVOCATION", "External Java PlugIn");
    public static final MicroStepFlavor EXTERNAL_PROGRAM_INVOCATION = new MicroStepFlavor(1, "EXTERNAL_PROGRAM_INVOCATION", "External Command PlugIn");
    public static final MicroStepFlavor INTERNAL_INVOCATION = new MicroStepFlavor(2, "INTERNAL_INVOCATION", "Internal PlugIn");
    public static final MicroStepFlavor ACTION_REF = new MicroStepFlavor(3, "ACTION_REF", "Reference to the specified Action within this Aggregate");
    public static final MicroStepFlavor AGGREGATE_ACTION_REF = new MicroStepFlavor(4, "AGGREGATE_ACTION_REF", "Reference to the specified Action in the specified Aggregate");
    public static final MicroStepFlavor UNRESOLVED_FLAVOR = new MicroStepFlavor(5, "UNRESOLVED_FLAVOR", "Unresolved type");
    private final String ident;

    private MicroStepFlavor(int numVal, String ident, String brief) {
        super(numVal, brief);
        this.ident = ident;
    }

    public String getIdent() {
        return this.ident;
    }

    public List getFlavors() {
        return MicroStepFlavor.getMembers();
    }

    public boolean isPlugInInvocation() {
        return this == EXTERNAL_JAVA_INVOCATION || this == EXTERNAL_PROGRAM_INVOCATION || this == INTERNAL_INVOCATION;
    }

    public boolean isExternalPlugInInvocation() {
        return this == EXTERNAL_JAVA_INVOCATION || this == EXTERNAL_PROGRAM_INVOCATION;
    }

    public boolean isInternalPlugInInvocation() {
        return this == INTERNAL_INVOCATION;
    }

    public boolean isJavaPlugInInvocation() {
        return this == EXTERNAL_JAVA_INVOCATION || this == INTERNAL_INVOCATION;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MicroStepFlavor)) {
            throw new Error("wrong type");
        }
        return super.equals(o);
    }

    public static MicroStepFlavor getFlavor(String flavorS) throws CfwException {
        if (flavorS == null || (flavorS = flavorS.trim()).length() == 0) {
            throw new CfwException("MicroStepFlavor.getFlavor: invalid (null or empty) request");
        }
        if (flavorS.equalsIgnoreCase(EXTERNAL_JAVA_INVOCATION.getIdent())) {
            return EXTERNAL_JAVA_INVOCATION;
        }
        if (flavorS.equalsIgnoreCase(EXTERNAL_PROGRAM_INVOCATION.getIdent())) {
            return EXTERNAL_PROGRAM_INVOCATION;
        }
        if (flavorS.equalsIgnoreCase(INTERNAL_INVOCATION.getIdent())) {
            return INTERNAL_INVOCATION;
        }
        if (flavorS.equalsIgnoreCase(ACTION_REF.getIdent())) {
            return ACTION_REF;
        }
        if (flavorS.equalsIgnoreCase(AGGREGATE_ACTION_REF.getIdent())) {
            return AGGREGATE_ACTION_REF;
        }
        throw new CfwException("MicroStepFlavor.getFlavor: invalid request " + flavorS);
    }
}

