/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.types;

import java.util.List;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.Constants;
import oracle.sysman.emCfg.types.StatusOrType;

public final class AggregateType
extends StatusOrType {
    public static final AggregateType SIMPLEST = new AggregateType(0, "SIMPLEST", "Simplest is the one that does most of the work");
    public static final AggregateType SIMPLEST_ARRAY = new AggregateType(1, "SIMPLEST_ARRAY", "An array of SIMPLEST aggregates");
    public static final AggregateType SIMPLE = new AggregateType(2, "SIMPLE", "Simple that has SIMPLEST aggregates");
    public static final AggregateType SIMPLE_ARRAY = new AggregateType(3, "SIMPLE_ARRAY", "An array of SIMPLE aggregates");
    public static final AggregateType COMPLEX = new AggregateType(4, "COMPLEX", "Complex Aggregate that has any type aggregates");
    public static final AggregateType ARRAY = new AggregateType(5, "ARRAY", "Array of aggregates of the same but any type");
    private final String ident;

    private AggregateType(int numVal, String ident, String brief) {
        super(numVal, brief);
        this.ident = ident;
    }

    public String getIdent() {
        return this.ident;
    }

    public List getTypes() {
        return AggregateType.getMembers();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AggregateType)) {
            throw new Error("wrong type");
        }
        return super.equals(o);
    }

    public boolean within(AggregateType[] types) {
        return super.within(types);
    }

    public static AggregateType getType(String typeS) throws CfwException {
        if (typeS == null || (typeS = typeS.trim()).length() == 0) {
            throw new CfwException("AggregateType.getType: invalid (null or empty) request");
        }
        if ((typeS = typeS.toUpperCase(Constants.NON_NLS_LOCALE)).equals(SIMPLEST.getIdent())) {
            return SIMPLEST;
        }
        if (typeS.equals(SIMPLEST_ARRAY.getIdent())) {
            return SIMPLEST_ARRAY;
        }
        if (typeS.equals(SIMPLE.getIdent())) {
            return SIMPLE;
        }
        if (typeS.equals(SIMPLE_ARRAY.getIdent())) {
            return SIMPLE_ARRAY;
        }
        if (typeS.equals(COMPLEX.getIdent())) {
            return COMPLEX;
        }
        if (typeS.equals(ARRAY.getIdent())) {
            return ARRAY;
        }
        throw new CfwException("AggregateType.getType: invalid request " + typeS);
    }
}

