/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.types;

import java.util.List;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.types.IStatus;
import oracle.sysman.emCfg.types.StatusOrType;

public final class AggregateStatus
extends StatusOrType
implements IStatus {
    public static final AggregateStatus UNKNOWN = new AggregateStatus(0, "UNKNOWN", "Unknown or access problem, no information is available");
    public static final AggregateStatus READY = new AggregateStatus(1, "READY", "It is in phase (\"C\") configured and is ready for actions");
    public static final AggregateStatus NOT_READY = new AggregateStatus(2, "NOT_READY", "It is in a phase that no actions could be performed");
    public static final AggregateStatus FAILURES_PRESENT = new AggregateStatus(3, "FAILURES_PRESENT", "There were failed actions performed on this aggregate");
    public static final AggregateStatus LOCKED = new AggregateStatus(4, "LOCKED", "Aggregate is locked and no information is available at this moment");
    private String ident;

    private AggregateStatus(int numVal, String ident, String brief) {
        super(numVal, brief);
        this.ident = ident;
    }

    public String getIdent() {
        return this.ident;
    }

    public List getStatuses() {
        return AggregateStatus.getMembers();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AggregateStatus)) {
            throw new Error("wrong type");
        }
        return super.equals(o);
    }

    public boolean within(AggregateStatus[] types) {
        return super.within(types);
    }

    public static AggregateStatus getStatus(String statusS) throws CfwException {
        if (statusS == null || (statusS = statusS.trim()).length() == 0) {
            throw new CfwException("AggregateStatus.getStatus: invalid (null or empty) request");
        }
        if (statusS.equalsIgnoreCase(UNKNOWN.getIdent())) {
            return UNKNOWN;
        }
        if (statusS.equalsIgnoreCase(READY.getIdent())) {
            return READY;
        }
        if (statusS.equalsIgnoreCase(NOT_READY.getIdent())) {
            return NOT_READY;
        }
        if (statusS.equalsIgnoreCase(FAILURES_PRESENT.getIdent())) {
            return FAILURES_PRESENT;
        }
        if (statusS.equalsIgnoreCase(LOCKED.getIdent())) {
            return LOCKED;
        }
        throw new CfwException("AggregateStatus.getStatus: invalid request " + statusS);
    }
}

