/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.types;

import java.util.List;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.types.AlternatingCustomizableType;
import oracle.sysman.emCfg.types.PlugInType;

public final class ActionType
extends AlternatingCustomizableType {
    public static final ActionType PROVISIONING = new ActionType(0, "provisioning");
    public static final ActionType CONFIGURATION = new ActionType(1, "configuration");
    public static final ActionType ALTERATION_GENTLE = new ActionType(2, "alteration:gentle");
    public static final ActionType CLONING_GENTLE = new ActionType(3, "cloning:gentle");
    public static final ActionType PURGING_GENTLE = new ActionType(4, "purging:gentle");
    public static final ActionType PATCH_SET_CONFIGURE = new ActionType(5, "patch_set_configure");
    public static final ActionType ALTERATION_DRASTIC = new ActionType(6, "alteration:drastic");
    public static final ActionType CLONING_DRASTIC = new ActionType(7, "cloning:drastic");
    public static final ActionType PURGING_DRASTIC = new ActionType(8, "purging:drastic");
    public static final ActionType UPGRADE = new ActionType(9, "upgrade");
    public static final ActionType ACTIVATION = new ActionType(10, "activation");
    public static final ActionType DEACTIVATION = new ActionType(11, "deactivation");
    public static final ActionType ADDING_LANGUAGE = new ActionType(12, "adding_language");
    public static final ActionType ADDING_NODE = new ActionType(13, "adding_node");
    public static final ActionType UNKNOWN = new ActionType(14, "UNKNOWN");
    public static final ActionType UPDGRADING_GENTLE = PATCH_SET_CONFIGURE;
    public static final ActionType UPDGRADING_DRASTIC = UPGRADE;

    private ActionType(int numVal, String brief) {
        super(numVal, brief);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ActionType)) {
            throw new Error("ActionType:equals: Object of wrong type=" + o);
        }
        return super.equals(o);
    }

    private static ActionType newCustom(String flavor) {
        List members = ActionType.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            ActionType actionType;
            Object obj = members.get(i);
            if (!(obj instanceof ActionType) || !flavor.equals((actionType = (ActionType)obj).getStatusBriefString())) continue;
            return actionType;
        }
        ActionType custom = new ActionType(ActionType.getMembers().size(), flavor);
        return custom;
    }

    public boolean within(ActionType[] types) {
        return super.within(types);
    }

    public boolean correspondsTo(PlugInType type) {
        if (type == null) {
            throw new Error("null is not allowed");
        }
        if (type.equals(PlugInType.PROVISION) && this.equals(PROVISIONING)) {
            return true;
        }
        if (type.equals(PlugInType.CONFIGURE) && this.equals(CONFIGURATION)) {
            return true;
        }
        if (type.equals(PlugInType.ALTER_GENTLE) && this.equals(ALTERATION_GENTLE)) {
            return true;
        }
        if (type.equals(PlugInType.CLONE_GENTLE) && this.equals(CLONING_GENTLE)) {
            return true;
        }
        if (type.equals(PlugInType.PURGE_GENTLE) && this.equals(PURGING_GENTLE)) {
            return true;
        }
        if (type.equals(PlugInType.UPDGRADE_GENTLE) && this.equals(PATCH_SET_CONFIGURE)) {
            return true;
        }
        if (type.equals(PlugInType.ALTER_DRASTIC) && this.equals(ALTERATION_DRASTIC)) {
            return true;
        }
        if (type.equals(PlugInType.CLONE_DRASTIC) && this.equals(CLONING_DRASTIC)) {
            return true;
        }
        if (type.equals(PlugInType.PURGE_DRASTIC) && this.equals(PURGING_DRASTIC)) {
            return true;
        }
        if (type.equals(PlugInType.UPDGRADE_DRASTIC) && this.equals(UPGRADE)) {
            return true;
        }
        if (type.equals(PlugInType.ACTIVATE) && this.equals(ACTIVATION)) {
            return true;
        }
        if (type.equals(PlugInType.DEACTIVATE) && this.equals(DEACTIVATION)) {
            return true;
        }
        if (type.equals(PlugInType.ADD_LANGUAGE) && this.equals(ADDING_LANGUAGE)) {
            return true;
        }
        if (type.equals(PlugInType.ADD_NODE) && this.equals(ADDING_NODE)) {
            return true;
        }
        if (this.isCustom() && type.isCustom() && ((AlternatingCustomizableType)type).equals(this)) {
            return true;
        }
        return type.equals(PlugInType.UNKNOWN);
    }

    public static ActionType getType(String typeName) throws CfwException {
        CfmUtil.preconditionNotNull(typeName, "typeName");
        if (typeName.equals(PROVISIONING.getStatusBriefString())) {
            return PROVISIONING;
        }
        if (typeName.equals(CONFIGURATION.getStatusBriefString())) {
            return CONFIGURATION;
        }
        if (typeName.equals(ALTERATION_GENTLE.getStatusBriefString())) {
            return ALTERATION_GENTLE;
        }
        if (typeName.equals(CLONING_GENTLE.getStatusBriefString())) {
            return CLONING_GENTLE;
        }
        if (typeName.equals(PURGING_GENTLE.getStatusBriefString())) {
            return PURGING_GENTLE;
        }
        if (typeName.equals(PATCH_SET_CONFIGURE.getStatusBriefString())) {
            return PATCH_SET_CONFIGURE;
        }
        if (typeName.equals(ALTERATION_DRASTIC.getStatusBriefString())) {
            return ALTERATION_DRASTIC;
        }
        if (typeName.equals(CLONING_DRASTIC.getStatusBriefString())) {
            return CLONING_DRASTIC;
        }
        if (typeName.equals(PURGING_DRASTIC.getStatusBriefString())) {
            return PURGING_DRASTIC;
        }
        if (typeName.equals(UPGRADE.getStatusBriefString())) {
            return UPGRADE;
        }
        if (typeName.equals(ACTIVATION.getStatusBriefString())) {
            return ACTIVATION;
        }
        if (typeName.equals(DEACTIVATION.getStatusBriefString())) {
            return DEACTIVATION;
        }
        if (typeName.equals(ADDING_LANGUAGE.getStatusBriefString())) {
            return ADDING_LANGUAGE;
        }
        if (typeName.equals(ADDING_NODE.getStatusBriefString())) {
            return ADDING_NODE;
        }
        if (typeName.startsWith("custom:")) {
            return ActionType.newCustom(typeName);
        }
        if (typeName.equals(UNKNOWN.getStatusBriefString())) {
            return UNKNOWN;
        }
        throw new CfwException("\"" + typeName + "\" is not a valid ActionType.");
    }
}

