/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.types;

import java.util.List;
import java.util.ResourceBundle;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.types.IStatus;
import oracle.sysman.emCfg.types.StatusOrType;

public final class ActionStepStatus
extends StatusOrType
implements IStatus {
    public static final ActionStepStatus NOT_PERFORMED = new ActionStepStatus(0, "NOT_PERFORMED", "Has never been performed");
    public static final ActionStepStatus PERFORMED_SUCCESS = new ActionStepStatus(1, "PERFORMED_SUCCESS", "Has successfully completed");
    public static final ActionStepStatus PERFORMED_FAILED = new ActionStepStatus(2, "PERFORMED_FAILED", "Has failed its perform method");
    public static final ActionStepStatus FAILED_NOTREQUIRED = new ActionStepStatus(3, "FAILED_NOTREQUIRED", "Has failed its optional perform method");
    public static final ActionStepStatus PREVENT_CONDITION_FALSE = new ActionStepStatus(4, "PREVENT_CONDITION_FALSE", "The invocation condition was not set");
    public static final ActionStepStatus INACTIVE_PLUGIN = new ActionStepStatus(5, "INACTIVE_PLUGIN", "There are no active PlugIns in this Step");
    public static final ActionStepStatus IS_PERFORMING = new ActionStepStatus(6, "IS_PERFORMING", "is running");
    public static final ActionStepStatus IS_ABORTING = new ActionStepStatus(7, "IS_ABORTING", "Currently is being aborted");
    public static final ActionStepStatus WAS_ABORTED = new ActionStepStatus(8, "WAS_ABORTED", "Has been aborted");
    private String ident;

    private ActionStepStatus(int numVal, String ident, String brief) {
        super(numVal, brief);
        this.ident = ident;
    }

    public String getIdent() {
        return this.ident;
    }

    public List getStatuses() {
        return ActionStepStatus.getMembers();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ActionStepStatus)) {
            throw new Error("wrong type");
        }
        return super.equals(o);
    }

    public boolean within(ActionStepStatus[] types) {
        return super.within(types);
    }

    public static ActionStepStatus getStatus(String statusS) throws CfwException {
        if (statusS == null || (statusS = statusS.trim()).length() == 0) {
            throw new CfwException("ActionStepStatus.getStatus: invalid (null or empty) request");
        }
        if (statusS.equalsIgnoreCase(NOT_PERFORMED.getIdent())) {
            return NOT_PERFORMED;
        }
        if (statusS.equalsIgnoreCase(PERFORMED_SUCCESS.getIdent())) {
            return PERFORMED_SUCCESS;
        }
        if (statusS.equalsIgnoreCase(PERFORMED_FAILED.getIdent())) {
            return PERFORMED_FAILED;
        }
        if (statusS.equalsIgnoreCase(PREVENT_CONDITION_FALSE.getIdent())) {
            return PREVENT_CONDITION_FALSE;
        }
        if (statusS.equalsIgnoreCase(INACTIVE_PLUGIN.getIdent())) {
            return INACTIVE_PLUGIN;
        }
        if (statusS.equalsIgnoreCase(IS_PERFORMING.getIdent())) {
            return IS_PERFORMING;
        }
        if (statusS.equalsIgnoreCase(IS_ABORTING.getIdent())) {
            return IS_ABORTING;
        }
        if (statusS.equalsIgnoreCase(WAS_ABORTED.getIdent())) {
            return WAS_ABORTED;
        }
        if (statusS.equalsIgnoreCase(FAILED_NOTREQUIRED.getIdent())) {
            return FAILED_NOTREQUIRED;
        }
        throw new CfwException("ActionStepStatus.getStatus: invalid request " + statusS);
    }

    public String getLocalizedBriefString() {
        ResourceBundle rb = ResourceBundle.getBundle("oracle.sysman.emCfg.common.CfmRuntimeRes");
        if (this.ident.equalsIgnoreCase(NOT_PERFORMED.getIdent())) {
            return rb.getString("CFM-10101");
        }
        if (this.ident.equalsIgnoreCase(PERFORMED_SUCCESS.getIdent())) {
            return rb.getString("CFM-10102");
        }
        if (this.ident.equalsIgnoreCase(PERFORMED_FAILED.getIdent())) {
            return rb.getString("CFM-10103");
        }
        if (this.ident.equalsIgnoreCase(PREVENT_CONDITION_FALSE.getIdent())) {
            return rb.getString("CFM-10104");
        }
        if (this.ident.equalsIgnoreCase(INACTIVE_PLUGIN.getIdent())) {
            return rb.getString("CFM-10105");
        }
        if (this.ident.equalsIgnoreCase(IS_PERFORMING.getIdent())) {
            return rb.getString("CFM-10106");
        }
        if (this.ident.equalsIgnoreCase(IS_ABORTING.getIdent())) {
            return rb.getString("CFM-10107");
        }
        if (this.ident.equalsIgnoreCase(WAS_ABORTED.getIdent())) {
            return rb.getString("CFM-10108");
        }
        if (this.ident.equalsIgnoreCase(FAILED_NOTREQUIRED.getIdent())) {
            return rb.getString("CFM-10109");
        }
        return this.ident;
    }
}

