/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.types;

import java.util.List;
import java.util.ResourceBundle;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.types.IStatus;
import oracle.sysman.emCfg.types.MicroStepStatus;
import oracle.sysman.emCfg.types.StatusOrType;

public final class ActionStatus
extends StatusOrType
implements IStatus {
    public static final ActionStatus NOT_PERFORMED = new ActionStatus(0, "NOT_PERFORMED", "Has never been performed");
    public static final ActionStatus PERFORMED_SUCCESS = new ActionStatus(1, "PERFORMED_SUCCESS", "Has successfully completed");
    public static final ActionStatus PERFORMED_FAILED = new ActionStatus(2, "PERFORMED_FAILED", "Has failed its perform method");
    public static final ActionStatus PREVENT_CONDITION_FALSE = new ActionStatus(3, "PREVENT_CONDITION_FALSE", "The invocation condition was not set");
    public static final ActionStatus INACTIVE_PLUGIN = new ActionStatus(4, "INACTIVE_PLUGIN", "There is no Active PlugIns in this Step");
    public static final ActionStatus IS_PERFORMING = new ActionStatus(5, "IS_PERFORMING", "is running");
    public static final ActionStatus IS_ABORTING = new ActionStatus(6, "IS_ABORTING", "Currently is being aborted");
    public static final ActionStatus WAS_ABORTED = new ActionStatus(7, "WAS_ABORTED", "Has been aborted");
    public static final ActionStatus UNRESOLVED_PLUGIN = new ActionStatus(8, "UNRESOLVED_PLUGIN", "A referred plugin could not be resolved");
    private final String ident;

    public static ActionStatus getStatus(String statusS) throws CfwException {
        if (statusS == null || (statusS = statusS.trim()).length() == 0) {
            throw new CfwException("ActionStatus.getStatus: invalid (null or empty) request");
        }
        if (statusS.equalsIgnoreCase(NOT_PERFORMED.getIdent())) {
            return NOT_PERFORMED;
        }
        if (statusS.equalsIgnoreCase(PERFORMED_SUCCESS.getIdent())) {
            return PERFORMED_SUCCESS;
        }
        if (statusS.equalsIgnoreCase(PERFORMED_FAILED.getIdent())) {
            return PERFORMED_FAILED;
        }
        if (statusS.equalsIgnoreCase(PREVENT_CONDITION_FALSE.getIdent())) {
            return PREVENT_CONDITION_FALSE;
        }
        if (statusS.equalsIgnoreCase(INACTIVE_PLUGIN.getIdent())) {
            return INACTIVE_PLUGIN;
        }
        if (statusS.equalsIgnoreCase(IS_PERFORMING.getIdent())) {
            return IS_PERFORMING;
        }
        if (statusS.equalsIgnoreCase(IS_ABORTING.getIdent())) {
            return IS_ABORTING;
        }
        if (statusS.equalsIgnoreCase(WAS_ABORTED.getIdent())) {
            return WAS_ABORTED;
        }
        if (statusS.equalsIgnoreCase(UNRESOLVED_PLUGIN.getIdent())) {
            return UNRESOLVED_PLUGIN;
        }
        throw new CfwException("Invalid ActionStatus: " + statusS);
    }

    public String getIdent() {
        return this.ident;
    }

    public static List getStatuses() {
        return ActionStatus.getMembers();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ActionStatus)) {
            throw new Error("wrong type");
        }
        return super.equals(o);
    }

    public boolean within(ActionStatus[] types) {
        return super.within(types);
    }

    private ActionStatus(int numVal, String ident, String brief) {
        super(numVal, brief);
        this.ident = ident;
    }

    public String getLocalizedBriefString() {
        ResourceBundle rb = ResourceBundle.getBundle("oracle.sysman.emCfg.common.CfmRuntimeRes");
        if (this.ident.equalsIgnoreCase(NOT_PERFORMED.getIdent())) {
            return rb.getString("CFM-10001");
        }
        if (this.ident.equalsIgnoreCase(PERFORMED_SUCCESS.getIdent())) {
            return rb.getString("CFM-10002");
        }
        if (this.ident.equalsIgnoreCase(PERFORMED_FAILED.getIdent())) {
            return rb.getString("CFM-10003");
        }
        if (this.ident.equalsIgnoreCase(PREVENT_CONDITION_FALSE.getIdent())) {
            return rb.getString("CFM-10004");
        }
        if (this.ident.equalsIgnoreCase(INACTIVE_PLUGIN.getIdent())) {
            return rb.getString("CFM-10005");
        }
        if (this.ident.equalsIgnoreCase(IS_PERFORMING.getIdent())) {
            return rb.getString("CFM-10006");
        }
        if (this.ident.equalsIgnoreCase(IS_ABORTING.getIdent())) {
            return rb.getString("CFM-10007");
        }
        if (this.ident.equalsIgnoreCase(WAS_ABORTED.getIdent())) {
            return rb.getString("CFM-10008");
        }
        if (this.ident.equalsIgnoreCase(UNRESOLVED_PLUGIN.getIdent())) {
            return rb.getString("CFM-10009");
        }
        return this.ident;
    }

    public MicroStepStatus getStatusForReferringMicroStep() {
        if (this == PERFORMED_SUCCESS || this == PREVENT_CONDITION_FALSE) {
            return MicroStepStatus.PERFORMED_SUCCESS;
        }
        if (this == WAS_ABORTED) {
            return MicroStepStatus.WAS_ABORTED;
        }
        return MicroStepStatus.PERFORMED_FAILED;
    }
}

