/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.support;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.logger.CfmLogger;

public class Shell {
    static CfmLogger cfmLogger = CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME);
    private final Runtime runtime = Runtime.getRuntime();
    private final boolean attached;
    private Process process = null;
    private boolean killed = false;

    public Shell() {
        this(false);
    }

    public Shell(boolean attached) {
        this.attached = attached;
    }

    public int run(String arg, String[] envp) throws CfwException {
        if (arg == null || arg.length() == 0) {
            throw new CfwException("Shell.run: At least 1 argument (the command) must be provided");
        }
        try {
            this.process = this.runtime.exec(arg, envp);
            return 0;
        }
        catch (IOException ioe) {
            throw new CfwException(ioe.toString(), ioe);
        }
    }

    public int run(String arg) throws CfwException {
        return this.run(arg, null);
    }

    public int run(String[] args, String[] envp) throws CfwException {
        if (args == null || args.length == 0) {
            throw new CfwException("Shell.run: At least 1 argument (the command) must be provided");
        }
        try {
            this.process = this.runtime.exec(args, envp);
            return 0;
        }
        catch (IOException ioe) {
            throw new CfwException(ioe.toString(), ioe);
        }
    }

    public int run(String[] args) throws CfwException {
        return this.run(args, null);
    }

    public int waitForProcess() {
        if (this.process != null) {
            while (true) {
                try {
                    return this.process.waitFor();
                }
                catch (InterruptedException ignore) {
                    cfmLogger.log(Level.FINEST, "Shell.waitForProcess: waitFor() was interrupted; retrying.");
                    continue;
                }
                break;
            }
        }
        return 0;
    }

    public int getExitStatusCode() {
        try {
            if (this.attached && this.process != null) {
                return this.process.exitValue();
            }
            return 0;
        }
        catch (IllegalThreadStateException ie) {
            throw new Error();
        }
    }

    public OutputStream getProcessInputChannel() {
        if (!this.attached || this.process == null || this.killed) {
            return null;
        }
        return new BufferedOutputStream(this.process.getOutputStream());
    }

    public InputStream getProcessOutputChannel() {
        if (!this.attached || this.process == null || this.killed) {
            return null;
        }
        return new BufferedInputStream(this.process.getInputStream());
    }

    public InputStream getProcessErrorOutputChannel() {
        if (!this.attached || this.process == null || this.killed) {
            return null;
        }
        return new BufferedInputStream(this.process.getErrorStream());
    }

    public void kill() {
        if (this.attached && this.process != null && !this.killed) {
            this.process.destroy();
        }
        this.killed = true;
    }
}

