/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.support;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import oracle.sysman.emCfg.support.CfmUtil;

public final class JarResources {
    private final Hashtable jarContents = new Hashtable();
    private static boolean debug = CfmUtil.isDebug();
    private final String jarFileName;

    public JarResources(String jarFileName) throws IOException {
        this.jarFileName = jarFileName;
        try {
            this.init();
        }
        catch (ZipException e) {
            throw new IOException("Unable to open " + jarFileName + ": " + e);
        }
    }

    public byte[] getResource(String name) {
        return (byte[])this.jarContents.get(name);
    }

    private void init() throws IOException {
        ZipEntry ze;
        Hashtable<String, Integer> htSizes = new Hashtable<String, Integer>();
        ZipFile zf = new ZipFile(this.jarFileName);
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze2 = e.nextElement();
            htSizes.put(ze2.getName(), new Integer((int)ze2.getSize()));
            if (!debug) continue;
            System.out.println("JarResources:init:entry found=" + this.dumpZipEntry(ze2));
        }
        zf.close();
        FileInputStream fis = new FileInputStream(this.jarFileName);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ZipInputStream zis = new ZipInputStream(bis);
        while ((ze = zis.getNextEntry()) != null) {
            int bytesThisChunk;
            Integer zipEntrySize;
            int size;
            if (ze.isDirectory()) continue;
            if (debug) {
                System.out.println("JarResources:init:ze.getName()=" + ze.getName() + "," + "getSize()=" + ze.getSize());
            }
            if ((size = (int)ze.getSize()) == -1 && (zipEntrySize = (Integer)htSizes.get(ze.getName())) != null) {
                size = zipEntrySize;
            }
            if (size == -1) continue;
            byte[] b = new byte[size];
            int readBytes = 0;
            while (size - readBytes > 0 && (bytesThisChunk = zis.read(b, readBytes, size - readBytes)) != -1) {
                readBytes += bytesThisChunk;
            }
            this.jarContents.put(ze.getName(), b);
            if (!debug) continue;
            System.out.println("JarResources:init:added new item=" + ze.getName() + "  rb=" + readBytes + ",size=" + size + ",csize=" + ze.getCompressedSize());
        }
    }

    private String dumpZipEntry(ZipEntry ze) {
        StringBuffer sb = new StringBuffer();
        if (ze.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (ze.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("deflated ");
        }
        sb.append(ze.getName());
        sb.append("\t");
        sb.append("" + ze.getSize());
        if (ze.getMethod() == 8) {
            sb.append("/" + ze.getCompressedSize());
        }
        return sb.toString();
    }
}

