/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.support;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import oracle.security.misc.Checksum;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.logger.CfmLogger;

public class Formatter {
    static CfmLogger cfmLogger = CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME);
    public static final String UTF8 = "UTF8";
    public static final String NULL_ELEMENT_KEY = "nullElem";
    public static final String HEXED_DATA_DELIMITER = " ";
    static char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static byte[] unHex2Bytes(String hexString) {
        return Formatter.hexStringToRawBytes(hexString);
    }

    public static String hex(byte[] bytes) throws NullPointerException {
        return Formatter.rawBytesToHexString(bytes);
    }

    public static String hex(String str) throws NullPointerException {
        return Formatter.normalStringToHexString(str);
    }

    public static String unHex2String(String s) {
        return Formatter.hexStringToNormalString(s);
    }

    public static String[] unHex2StringArray(String s) {
        return Formatter.hexArrayStringToNormalStringArray(s);
    }

    public static String[] unHex2StringArrayMD5(String str) throws CfwException, NullPointerException {
        return Formatter.hexArrayStringMD5ToNormalStringArray(str);
    }

    public static String hex(String[] inSA) {
        return Formatter.normalStringArrayToHexArrayString(inSA);
    }

    public static String hexMD5(String[] inSA) throws Exception {
        return Formatter.normalStringArrayToHexArrayStringMD5(inSA);
    }

    public static String[] tokenizeHexedDataArray(String hexedData) {
        return hexedData.split(HEXED_DATA_DELIMITER, -1);
    }

    public static byte hexCharToByte(char c) {
        if ('0' <= c && c <= '9') {
            return (byte)(c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        throw new NumberFormatException("Invalid hexadecimal character " + c);
    }

    public static String rawBytesToHexString(byte[] bytes) throws NullPointerException {
        int len = bytes.length;
        StringBuffer buf = new StringBuffer(len * 2);
        for (int pos = 0; pos < len; ++pos) {
            byte currByte = bytes[pos];
            buf.append(Formatter.rawByteHexCharFirst(currByte)).append(Formatter.rawByteHexCharSecond(currByte));
        }
        return buf.toString();
    }

    public static char rawByteHexCharFirst(byte b) {
        return HEX_DIGIT[b >>> 4 & 0xF];
    }

    public static char rawByteHexCharSecond(byte b) {
        return HEX_DIGIT[b & 0xF];
    }

    public static byte[] hexStringToRawBytes(String hexString) throws NullPointerException, StringIndexOutOfBoundsException {
        int numBytes = hexString.length() / 2;
        byte[] result = new byte[numBytes];
        for (int resultPos = 0; resultPos < numBytes; ++resultPos) {
            int hexPos = resultPos * 2;
            byte upper = Formatter.hexCharToByte(hexString.charAt(hexPos));
            byte lower = Formatter.hexCharToByte(hexString.charAt(hexPos + 1));
            result[resultPos] = (byte)((upper << 4) + lower);
        }
        return result;
    }

    public static String hexStringToNormalString(String hexedString, String charsetName) throws NullPointerException, UnsupportedEncodingException {
        if (charsetName != null) {
            return new String(Formatter.hexStringToRawBytes(hexedString), charsetName);
        }
        return Formatter.hexStringToNormalString(hexedString);
    }

    public static String hexStringToNormalString(String hexedString) throws NullPointerException {
        return new String(Formatter.hexStringToRawBytes(hexedString));
    }

    public static String normalStringToHexString(String str, String charsetName) throws NullPointerException, UnsupportedEncodingException {
        if (charsetName != null) {
            return Formatter.rawBytesToHexString(str.getBytes(charsetName));
        }
        return Formatter.normalStringToHexString(str);
    }

    public static String normalStringToHexString(String str) throws NullPointerException {
        return Formatter.rawBytesToHexString(str.getBytes());
    }

    public static String[] hexArrayStringToNormalStringArray(String hexArrStr, String charsetName) throws NullPointerException, UnsupportedEncodingException {
        String[] hexedStrings = Formatter.tokenizeHexedDataArray(hexArrStr);
        int length = hexedStrings.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Formatter.hexStringToNormalStringNullOk(hexedStrings[i], charsetName);
        }
        return result;
    }

    public static String hexStringToNormalStringNullOk(String hexedString, String charsetName) throws UnsupportedEncodingException {
        if (NULL_ELEMENT_KEY.equals(hexedString)) {
            return null;
        }
        return Formatter.hexStringToNormalString(hexedString, charsetName);
    }

    public static String[] hexArrayStringToNormalStringArray(String hexArrStr) throws NullPointerException {
        try {
            return Formatter.hexArrayStringToNormalStringArray(hexArrStr, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static String[] hexArrayStringMD5ToNormalStringArray(String hexArrStr, String charsetName) throws CfwException, NullPointerException, UnsupportedEncodingException {
        String[] hexedStrings = Formatter.tokenizeHexedDataArray(hexArrStr);
        int length = hexedStrings.length;
        String[] result = new String[length];
        for (int i = 0; i < length; ++i) {
            result[i] = Formatter.hexStringMD5ToNormalStringNullOk(hexedStrings[i], charsetName);
        }
        return result;
    }

    public static String hexStringMD5ToNormalStringNullOk(String hexStrMD5, String charsetName) throws CfwException, UnsupportedEncodingException {
        if (NULL_ELEMENT_KEY.equals(hexStrMD5)) {
            return null;
        }
        return Formatter.hexStringMD5ToNormalString(hexStrMD5, charsetName);
    }

    public static String[] hexArrayStringMD5ToNormalStringArray(String hexArrStr) throws CfwException, NullPointerException {
        try {
            return Formatter.hexArrayStringMD5ToNormalStringArray(hexArrStr, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static String normalStringArrayToHexArrayString(String[] strArray, String charsetName) throws NullPointerException, UnsupportedEncodingException {
        if (strArray.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Formatter.normalStringToHexStringNullOk(strArray[0], charsetName));
        for (int i = 1; i < strArray.length; ++i) {
            sb.append(HEXED_DATA_DELIMITER + Formatter.normalStringToHexStringNullOk(strArray[i], charsetName));
        }
        return sb.toString();
    }

    public static String normalStringToHexStringNullOk(String str, String charsetName) throws UnsupportedEncodingException {
        if (str == null) {
            return NULL_ELEMENT_KEY;
        }
        return Formatter.normalStringToHexString(str, charsetName);
    }

    public static String normalStringArrayToHexArrayString(String[] strArray) throws NullPointerException {
        try {
            return Formatter.normalStringArrayToHexArrayString(strArray, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static String normalStringArrayToHexArrayStringMD5(String[] strArray, String charsetName) throws NullPointerException, CfwException, UnsupportedEncodingException {
        if (strArray.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(Formatter.normalStringToHexStringMD5NullOk(strArray[0], charsetName));
        for (int i = 1; i < strArray.length; ++i) {
            sb.append(HEXED_DATA_DELIMITER + Formatter.normalStringToHexStringMD5NullOk(strArray[i], charsetName));
        }
        return sb.toString();
    }

    public static String normalStringToHexStringMD5NullOk(String str, String charsetName) throws NullPointerException, CfwException, UnsupportedEncodingException {
        if (str == null) {
            return NULL_ELEMENT_KEY;
        }
        return Formatter.normalStringToHexStringMD5(str, charsetName);
    }

    public static String normalStringArrayToHexArrayStringMD5(String[] strArray) throws NullPointerException, CfwException {
        try {
            return Formatter.normalStringArrayToHexArrayStringMD5(strArray, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static String normalStringToHexStringMD5(String str, String charsetName) throws NullPointerException, CfwException, UnsupportedEncodingException {
        return Formatter.hexStringToHexStringMD5(Formatter.normalStringToHexString(str, charsetName));
    }

    public static String hexStringMD5ToNormalString(String hexStrMD5, String charsetName) throws NullPointerException, CfwException, UnsupportedEncodingException {
        return Formatter.hexStringToNormalString(Formatter.hexStringMD5ToHexString(hexStrMD5), charsetName);
    }

    public static String hexStringToHexStringMD5(String hexStr) throws NullPointerException, CfwException {
        Misc m = new Formatter().new Misc();
        byte[] result = m.rawBytesToRawBytesMD5(Formatter.hexStringToRawBytes(hexStr));
        m = null;
        return Formatter.rawBytesToHexString(result);
    }

    public static String hexStringMD5ToHexString(String hexStrMD5) throws NullPointerException, CfwException {
        Misc m = new Formatter().new Misc();
        byte[] result = m.rawBytesMD5ToRawBytes(Formatter.hexStringToRawBytes(hexStrMD5));
        m = null;
        return Formatter.rawBytesToHexString(result);
    }

    public static String escapeXMLSequences(String src) {
        if (src == null) {
            return null;
        }
        src = src.replaceAll("&", "&amp;");
        src = src.replaceAll("\"", "&quot;");
        src = src.replaceAll("'", "&apos;");
        src = src.replaceAll(">", "&gt;");
        src = src.replaceAll("<", "&lt;");
        return src;
    }

    private class Misc {
        private byte[] key = null;

        public Misc() {
            try {
                this.key = new byte[]{49, 50, 57, 50, 48, 54, 58, 101, 97, 56, 101, 99, 52, 102, 49, 50, 48, 58, 45, 56, 48, 48, 48, 45, 49, 57, 53, 48, 55, 55, 53, 57, 56, 48};
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public byte[] rawBytesToRawBytesMD5(byte[] in) throws CfwException {
            try {
                return Checksum.MD5((byte[])in, (byte[])this.key);
            }
            catch (Exception e) {
                throw new CfwException(e);
            }
        }

        public byte[] rawBytesMD5ToRawBytes(byte[] inEnc) throws NullPointerException, CfwException {
            try {
                return Checksum.SHA((byte[])inEnc, (byte[])this.key);
            }
            catch (Exception e) {
                throw new CfwException(e);
            }
        }
    }

    public static class HexOutputStream
    extends OutputStream {
        private final Writer writer;

        public HexOutputStream(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void write(int b) throws IOException {
            this.writer.write(Formatter.rawByteHexCharFirst((byte)b));
            this.writer.write(Formatter.rawByteHexCharSecond((byte)b));
        }
    }
}

