/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.support;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.Chunker;
import oracle.sysman.emCfg.support.Shell;

public class Filer {
    private static String fileSeparator = System.getProperty("file.separator");
    private static String pathSeparator = System.getProperty("path.separator");
    private static boolean debug = CfmUtil.isDebug();
    static CfmLogger cfmLogger = CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME);

    public static String readFile(String fileName) throws IOException {
        return Filer.readFile(new File(fileName));
    }

    public static String readFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        int length = is.available();
        if (length == 0) {
            is.close();
            return "";
        }
        byte[] ba = new byte[length];
        is.read(ba);
        is.close();
        return new String(ba);
    }

    public static boolean isUnix() {
        return fileSeparator.equals("/") && pathSeparator.equals(":");
    }

    private static void shellOut(String cmdS) {
        Shell shell = new Shell(false);
        try {
            shell.run(cmdS);
            cfmLogger.log(Level.FINER, "shellOut: Command " + cmdS + " exit code = unknown");
        }
        catch (Exception e) {
            cfmLogger.log(Level.FINER, "shellOut: Command " + cmdS + " exception " + e);
        }
    }

    public static void chmodFile(String physPath, int code) {
        if (!Filer.isUnix()) {
            return;
        }
        if (physPath == null || physPath.trim().length() == 0) {
            return;
        }
        String cmdS = "chmod " + code + " " + physPath;
        Filer.shellOut(cmdS);
    }

    public static void chmodFile(String physPath, String code) {
        if (!Filer.isUnix()) {
            return;
        }
        if (physPath == null || physPath.trim().length() == 0) {
            return;
        }
        String cmdS = "chmod " + code + " " + physPath;
        Filer.shellOut(cmdS);
    }

    public static void chmodFile(File fl, int code) {
        if (!Filer.isUnix()) {
            return;
        }
        if (fl == null) {
            return;
        }
        String cmdS = "chmod " + code + " " + fl.getAbsolutePath();
        Filer.shellOut(cmdS);
    }

    public static void chownFile(File fl, String user) {
        if (!Filer.isUnix()) {
            return;
        }
        if (fl == null || user == null || user.trim().length() == 0) {
            return;
        }
        String cmdS = "chown " + user + " " + fl.getAbsolutePath();
        Filer.shellOut(cmdS);
    }

    public static void rmFile(String physPath) {
        if (physPath == null || physPath.trim().length() == 0) {
            return;
        }
        new File(physPath).delete();
    }

    public static void copyOneFile(String targetFilePath, String sourceFilePath, int fileChmod, boolean overwriteB) throws CfwException {
        FileOutputStream fio;
        String fullTargetName;
        if (targetFilePath == null || targetFilePath.trim().length() == 0) {
            return;
        }
        if (sourceFilePath == null || sourceFilePath.trim().length() == 0) {
            return;
        }
        try {
            String parentDir;
            int idx;
            File fl = new File(sourceFilePath);
            if (!fl.exists()) {
                throw new CfwException("Filer.copyOneFile: Source file (" + fl + ") does not exist");
            }
            if (fl.isDirectory()) {
                throw new CfwException("Filer.copyOneFile: Source file (" + fl + ") is a directory");
            }
            File fl2 = new File(targetFilePath);
            if (fl2.isDirectory()) {
                throw new CfwException("Filer.copyOneFile: Target file (" + fl2 + ") is a directory");
            }
            if (!overwriteB && fl2.exists()) {
                throw new CfwException("Filer.copyOneFile: Target file (" + fl2 + ") already exists");
            }
            if (fl.getCanonicalPath().equals(fl2.getCanonicalPath())) {
                throw new CfwException("Filer.copyOneFile: Unable to copy file to itself");
            }
            if (fl2.exists()) {
                Filer.rmFile(targetFilePath);
            }
            if ((idx = (parentDir = (fullTargetName = fl2.getAbsolutePath())).lastIndexOf(fileSeparator)) != -1) {
                parentDir = fullTargetName.substring(0, idx);
                File fl3 = new File(parentDir);
                if (debug) {
                    cfmLogger.log(Level.INFO, "Filer.copyOneFile: creating dirs for " + fl3.getAbsolutePath());
                }
                fl3.mkdirs();
            }
            if (debug) {
                cfmLogger.log(Level.INFO, "Filer.copyOneFile: about to create " + fullTargetName);
            }
            fio = new FileOutputStream(fullTargetName);
            if (fl.length() == 0L) {
                fio.flush();
                fio.close();
                return;
            }
        }
        catch (Exception e) {
            throw new CfwException("Filer.copyOneFile: Unable to create file " + targetFilePath + ": " + e.toString(), e);
        }
        try {
            Chunker fcr = new Chunker(sourceFilePath, 2048);
            long length = fcr.length();
            if (length <= 0L) {
                fcr.close();
                fio.flush();
                fio.close();
                return;
            }
            byte[] retBytes = fcr.readNext();
            while (retBytes != null) {
                fio.write(retBytes);
                retBytes = fcr.readNext();
            }
            fcr.close();
            fio.flush();
            fio.close();
            if (Filer.isUnix() && fileChmod >= 0) {
                Filer.chmodFile(fullTargetName, fileChmod);
            }
            return;
        }
        catch (Exception e) {
            throw new CfwException("Filer.copyOneFile: Unable to copy to " + targetFilePath);
        }
    }

    public static void copyOneFile(String filename, String targetFileDir, String sourceFileDir, int fileChmod, boolean overwriteB) throws CfwException {
        String src = sourceFileDir + File.separator + filename;
        String dest = targetFileDir + File.separator + filename;
        Filer.copyOneFile(dest, src, fileChmod, overwriteB);
    }

    public static void copyOneFile(String targetDir, String fileName, String baseDir, int fileChmod, int dirChmod) throws CfwException {
        int idx;
        File fl2;
        String parentDir;
        if (fileName == null || fileName.trim().length() == 0) {
            return;
        }
        if (targetDir == null || targetDir.trim().length() == 0) {
            return;
        }
        File fl = new File(fileName);
        String fullName = fl.getAbsolutePath();
        File fl1 = new File(baseDir);
        String fullBaseName = fl1.getAbsolutePath();
        if (!fullBaseName.endsWith(fileSeparator)) {
            fullBaseName = fullBaseName + fileSeparator;
        }
        if (!(parentDir = (fl2 = new File(targetDir)).getAbsolutePath()).endsWith(fileSeparator)) {
            parentDir = parentDir + fileSeparator;
        }
        String newName = (idx = fullName.indexOf(fullBaseName)) == -1 ? parentDir + fullName : parentDir + fullName.substring(idx + fullBaseName.length());
        File fl3 = new File(newName);
        try {
            if (fl.isDirectory()) {
                try {
                    if (!fl3.exists()) {
                        fl3.mkdirs();
                    }
                    if (Filer.isUnix()) {
                        Filer.chmodFile(fl3, dirChmod);
                    }
                }
                catch (Exception e) {
                    throw new CfwException("Filer.copyOneFile: Unable to create directory " + fl.getName());
                }
                return;
            }
            fl2.mkdirs();
            FileOutputStream fio = new FileOutputStream(newName);
            if (new File(fileName).length() == 0L) {
                fio.flush();
                fio.close();
                return;
            }
            Chunker fcr = new Chunker(fileName, 2048);
            long length = fcr.length();
            if (length <= 0L) {
                fcr.close();
                fio.flush();
                fio.close();
                return;
            }
            byte[] retBytes = fcr.readNext();
            while (retBytes != null) {
                fio.write(retBytes);
                retBytes = fcr.readNext();
            }
            fcr.close();
            fio.flush();
            fio.close();
            if (Filer.isUnix()) {
                Filer.chmodFile(newName, fileChmod);
            }
            return;
        }
        catch (Exception e) {
            try {
                throw new CfwException("Filer.copyOneFile: Unable to create file " + fl3.getName(), e);
            }
            catch (Exception e1) {
                throw new CfwException("Filer.copyOneFile: Unable to copy file", e1);
            }
        }
    }

    public static boolean isLink(File file) throws IOException {
        File absoluteFile;
        File canonicalFile = file.getCanonicalFile();
        return !canonicalFile.equals(absoluteFile = file.getAbsoluteFile());
    }

    public static boolean removeFiles(String dir) throws IOException {
        return Filer.removeFiles(new File(dir));
    }

    public static boolean removeFiles(File dir) throws IOException {
        File fl = dir;
        if (!fl.exists()) {
            return false;
        }
        if (Filer.isLink(fl) || !fl.isDirectory()) {
            fl.delete();
            return true;
        }
        File[] list = fl.listFiles();
        if (list == null) {
            fl.delete();
            return true;
        }
        for (int i = 0; i < list.length; ++i) {
            File currFile = list[i];
            if (currFile.isDirectory()) {
                Filer.removeFiles(currFile);
            }
            currFile.delete();
        }
        return fl.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String contents, String fileName, String encoding, boolean append) throws IOException {
        CfmUtil.preconditionNotNull(fileName, "fileName");
        CfmUtil.preconditionNotNull(contents, "contents");
        CfmUtil.preconditionNotNull(encoding, "encoding");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, append), encoding));){
            writer.write(contents);
            writer.flush();
        }
    }

    public static void writeToFile(String contents, String fileName, String encoding) throws IOException {
        Filer.writeToFile(contents, fileName, encoding, false);
    }

    public static void writeToFile(String contents, String fileName) throws IOException {
        CfmUtil.preconditionNotNull(fileName, "fileName");
        CfmUtil.preconditionNotNull(contents, "contents");
        try (PrintWriter writer = new PrintWriter(new FileWriter(fileName));){
            writer.println(contents);
            writer.flush();
        }
    }

    public static void writeToFileUTF8(String contents, String fileName, boolean append) throws IOException {
        Filer.writeToFile(contents, fileName, "UTF8", append);
    }

    public static void writeToFileUTF8(String contents, String fileName) throws IOException {
        Filer.writeToFileUTF8(contents, fileName, false);
    }

    public static byte[] fileToByteArray(InputStream stream) {
        if (stream == null) {
            return null;
        }
        try {
            DataInputStream _reader = new DataInputStream(stream);
            if (_reader == null) {
                return null;
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream(_reader.available());
            try {
                while (true) {
                    byte b = _reader.readByte();
                    output.write(b);
                }
            }
            catch (EOFException eOFException) {
                _reader.close();
                return output.toByteArray();
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public static byte[] fileToByteArray(File fileIn) {
        if (fileIn == null) {
            return null;
        }
        try {
            if (!fileIn.canRead()) {
                return null;
            }
        }
        catch (SecurityException e) {
            return null;
        }
        try {
            return Filer.fileToByteArray(new FileInputStream(fileIn));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static byte[] fileToByteArray(String filename) {
        if (filename == null || filename.length() == 0) {
            return null;
        }
        return Filer.fileToByteArray(new File(filename));
    }

    public static URL createURL(File f) {
        try {
            String path = f.getAbsolutePath();
            String fs = System.getProperty("file.separator");
            if (fs.length() == 1) {
                char sep = fs.charAt(0);
                if (sep != '/') {
                    path = path.replace(sep, '/');
                }
                if (path.charAt(0) != '/') {
                    path = '/' + path;
                }
            }
            path = "file://" + path;
            URL url = new URL(path);
            return url;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static URL createURL(String fileName) {
        try {
            URL url = new URL(fileName);
            return url;
        }
        catch (MalformedURLException ex) {
            return Filer.createURL(new File(fileName));
        }
    }

    public static void createParentDirectories(File child) {
        File parent = child.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    public static void createSecureFile(File f) throws IOException {
        if (f.exists()) {
            f.delete();
        }
        f.createNewFile();
        Filer.chmodFile(f.getAbsolutePath(), "og-rwx");
    }
}

