/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.support;

import java.io.IOException;
import java.io.RandomAccessFile;
import oracle.sysman.emCfg.common.CfwException;

public class Chunker {
    private RandomAccessFile ra = null;
    private byte[] storage = null;
    private long length = 0L;

    public Chunker(String fileName, int chunkSize) throws CfwException {
        if (chunkSize <= 0) {
            throw new CfwException("Requested readable chunk size must be positive");
        }
        try {
            this.ra = new RandomAccessFile(fileName, "r");
            this.ra.seek(0L);
            this.length = this.ra.length();
            if (this.length() == 0L) {
                this.close();
                throw new CfwException("Zero length file");
            }
            if ((long)chunkSize > this.length()) {
                chunkSize = (int)this.length;
            }
            this.storage = new byte[chunkSize];
        }
        catch (IOException ioe) {
            throw new CfwException("Unable to access file " + fileName);
        }
    }

    public long length() {
        return this.length;
    }

    public void close() {
        this.storage = null;
        if (this.ra != null) {
            try {
                this.ra.close();
                this.ra = null;
            }
            catch (IOException ex) {
                this.ra = null;
            }
        }
    }

    public byte[] readNext() throws CfwException {
        if (this.ra == null) {
            throw new CfwException("Chunker: File not open");
        }
        if (this.storage == null || this.storage.length <= 0) {
            throw new CfwException("Chunker: File not open");
        }
        try {
            int readBytes = this.ra.read(this.storage);
            if (readBytes == -1) {
                this.close();
                return null;
            }
            if (readBytes < this.storage.length) {
                byte[] newStorage = new byte[readBytes];
                for (int i = 0; i < readBytes; ++i) {
                    newStorage[i] = this.storage[i];
                }
                this.storage = newStorage;
            }
            return this.storage;
        }
        catch (IOException ioe) {
            throw new CfwException(ioe.toString());
        }
    }
}

