/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.ValidationEvent;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.emCfg.support.JarClassLoader;
import org.xml.sax.Locator;

public class CfmUtil {
    private static boolean Support_Debug = false;
    private static final String SET_CONTEXT_CLASS_LOADER_PROPERTY = "oracle.installer.setContextClassLoaderForConfig";
    private static int UidCount = 0;
    private static Object countLock = new Object();
    private static final Comparator longComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return (int)((Long)o2 - (Long)o1);
        }
    };

    public static void setDebug(boolean isDebug) {
        Support_Debug = isDebug;
    }

    public static boolean isDebug() {
        return Support_Debug;
    }

    public static Object genericGet(Class returnType, Object jaxbObject, String memberName) {
        String method = returnType.getName().endsWith("Boolean") ? "is" + memberName : "get" + memberName;
        return CfmUtil.privateGenericGet(returnType, jaxbObject, method);
    }

    private static Object privateGenericGet(Class returnType, Object jaxbObject, String methodName) {
        if (jaxbObject != null) {
            try {
                Class<?> jaxbClass = jaxbObject.getClass();
                Method methodGetId = jaxbClass.getMethod(methodName, new Class[0]);
                if (methodGetId == null) {
                    if (Support_Debug) {
                        System.out.println("CfmUtil.privateGenericGet no methods found for:" + methodName);
                    }
                    return null;
                }
                Object retObject = methodGetId.invoke(jaxbObject, new Object[0]);
                if (retObject != null && returnType.isInstance(retObject)) {
                    return retObject;
                }
                if (retObject == null) {
                    if (Support_Debug) {
                        System.out.println("CfmUtil.privateGenericGet value obtained is null for:" + methodName + ":method.");
                    }
                } else if (!returnType.isInstance(retObject) && Support_Debug) {
                    System.out.println("CfmUtil.privateGenericGet returnType is missmatched for:" + methodName + ":method. Return type is not as Expected=" + returnType.getName());
                }
            }
            catch (NoSuchMethodException nme) {
                if (Support_Debug) {
                    System.out.println("CfmUtil.privateGenericGet:NoSuchMethodException Occured on " + jaxbObject.getClass().getName() + " class." + nme.getMessage());
                }
                return null;
            }
            catch (IllegalAccessException nme) {
                if (Support_Debug) {
                    System.out.println("CfmUtil.privateGenericGet:IllegalAccessException Occured on " + jaxbObject.getClass().getName() + " class." + nme.getMessage());
                }
                return null;
            }
            catch (InvocationTargetException nme) {
                if (Support_Debug) {
                    System.out.println("CfmUtil.privateGenericGet:InvocationTargetException Occured on " + jaxbObject.getClass().getName() + " class." + nme.getMessage());
                }
                return null;
            }
        }
        return null;
    }

    public static Object getTheObject(String className, Class[] constructorType, Object[] values, String additionalJars) throws CfwException {
        return CfmUtil.getTheObject(className, constructorType, values, additionalJars, null);
    }

    public static Object getTheObject(String className, Class[] constructorType, Object[] values, String additionalJars, CfmLogger logger) throws CfwException {
        Class<?> fromClass = null;
        if (additionalJars == null || additionalJars.length() == 0) {
            try {
                fromClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new CfwException("The specified class (" + className + ") could not be found on the default classpath and no additional jars were specified.", e);
            }
        }
        String[] jars = additionalJars.split(File.pathSeparator);
        try {
            ClassLoader actual;
            ClassLoader jcl = JarClassLoader.getClassLoaderForJars(jars);
            if (System.getProperty(SET_CONTEXT_CLASS_LOADER_PROPERTY, "false").compareToIgnoreCase("true") == 0) {
                Thread.currentThread().setContextClassLoader(jcl);
            }
            if ((actual = (fromClass = Class.forName(className, true, jcl)).getClassLoader()) != jcl && logger != null) {
                logger.log(Level.WARNING, "Class " + className + " was loaded by a parent class loader, provided classpath (" + additionalJars + ") will not be available from this class");
            }
        }
        catch (MalformedURLException e) {
            throw new CfwException("Unable to load from additional jars (" + additionalJars + ") :" + e, e);
        }
        catch (ClassNotFoundException e) {
            StringBuffer errorMessage = new StringBuffer();
            errorMessage.append("The specified class (").append(className).append(") could not be found on the default classpath or in additional jars: ").append(additionalJars);
            throw new CfwException(errorMessage.toString(), e);
        }
        try {
            Constructor<?> constructor = fromClass.getConstructor(constructorType);
            return constructor.newInstance(values);
        }
        catch (IllegalAccessException e) {
            throw new CfwException("The specified class (" + className + ") was found, but its constructor is inaccessible: " + e.toString(), e);
        }
        catch (NoSuchMethodException e) {
            throw new CfwException("The specified class (" + className + ") was found, but a valid constructor could not be found: " + e.toString(), e);
        }
        catch (InvocationTargetException e) {
            throw new CfwException("The specified class (" + className + ") was found, but its constructor threw an exception: " + e.getCause().toString(), e.getCause());
        }
        catch (InstantiationException e) {
            throw new CfwException("The specified class (" + className + ") was found, but it could not be instantiated: " + e.toString(), e);
        }
    }

    public static Method getTheMethod(Object theObject, String methodName, Class[] parmTypes) throws CfwException {
        try {
            Class<?> fromClass = theObject.getClass();
            Method theMethod = fromClass.getMethod(methodName, parmTypes);
            return theMethod;
        }
        catch (NoSuchMethodException e) {
            throw new CfwException("Unable to get Method=" + methodName + ": " + e.toString(), e);
        }
    }

    public static CfmLogger getCfmLogger(IAggregate aggregate) {
        try {
            String loggerName = aggregate.getSelfID() + "|" + aggregate.getOracleHome();
            return CfmLogger.getCfmLogger(loggerName);
        }
        catch (CfwException e) {
            return CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME);
        }
    }

    public static String getNumericUniqueId() {
        StringBuffer uid = new StringBuffer(new SimpleDateFormat("yyyyMMddhhmmssSSS").format(new Date()));
        int mCnt = CfmUtil.getIntCounter();
        uid.append(CfmUtil.padString(Integer.toString(mCnt)));
        int randN = (int)(Math.random() * 9999.0);
        uid.append(CfmUtil.padString(Integer.toString(randN)));
        return uid.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getIntCounter() {
        Object object = countLock;
        synchronized (object) {
            if (++UidCount > 9999) {
                UidCount = 1;
            }
            return UidCount;
        }
    }

    private static String padString(String s) {
        int len = (s = s.trim()).length();
        if (len < 1) {
            return "0000";
        }
        if (len < 2) {
            return "000" + s;
        }
        if (len < 3) {
            return "00" + s;
        }
        if (len < 4) {
            return "0" + s;
        }
        if (len == 4) {
            return s;
        }
        return s.substring(len - 4);
    }

    public static String getCurrentTimeAsString() {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS:");
        return df.format(new Date());
    }

    public static String getTimestamp() {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
        return df.format(new Date());
    }

    public static void dprint(String message) {
        System.out.println(CfmUtil.getCurrentTimeAsString() + message);
    }

    public static String arrayToString(Object[] array, String separator, String valueWhenEmpty) {
        StringBuffer result = new StringBuffer();
        if (array.length < 1) {
            return valueWhenEmpty;
        }
        result.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            result.append(separator);
            result.append(array[i]);
        }
        return result.toString();
    }

    public static String arrayToString(Object[] array, String separator) {
        return CfmUtil.arrayToString(array, separator, " <no elements>");
    }

    public static String collectionToString(Collection c, String separator, String valueWhenEmpty) {
        StringBuffer result = new StringBuffer();
        Iterator i = c.iterator();
        if (!i.hasNext()) {
            return valueWhenEmpty;
        }
        result.append(i.next());
        while (i.hasNext()) {
            result.append(separator);
            result.append(i.next());
        }
        return result.toString();
    }

    public static String collectionToString(Collection c, String separator) {
        return CfmUtil.collectionToString(c, separator, " <no elements>");
    }

    public static String throwableToString(Throwable t) {
        StringBuffer sb = new StringBuffer();
        sb.append(t.toString());
        for (Throwable curr = t.getCause(); curr != null; curr = curr.getCause()) {
            sb.append("\n  caused by: " + curr.toString());
        }
        return sb.toString();
    }

    public static String throwableToStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String name, ClassLoader loader) {
        String SUFFIX = ".properties";
        CfmUtil.preconditionNotNull(name, "name");
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (name.endsWith(".properties")) {
            name = name.substring(0, name.length() - ".properties".length());
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if (!(name = name.replace('.', '/')).endsWith(".properties")) {
            name = name.concat(".properties");
        }
        InputStream in = loader.getResourceAsStream(name);
        Properties result = new Properties(System.getProperties());
        if (in != null) {
            try {
                result.load(in);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return result;
    }

    public static Properties loadProperties(String name) {
        return CfmUtil.loadProperties(name, Thread.currentThread().getContextClassLoader());
    }

    public static boolean getBoolean(Properties properties, String propertyName) {
        return CfmUtil.getBoolean(properties, propertyName, false);
    }

    public static boolean getBoolean(Properties properties, String propertyName, boolean defaultValue) {
        String bool = properties.getProperty(propertyName);
        if (bool == null) {
            return defaultValue;
        }
        return Boolean.valueOf(bool.trim());
    }

    public static String toXMLEscapeSequences(String src) {
        return Formatter.escapeXMLSequences(src);
    }

    public static String locatorToString(Locator locator) {
        return CfmUtil.locationToString(locator.getLineNumber(), locator.getColumnNumber());
    }

    public static String locationToString(int line, int col) {
        return "(line=" + line + ",col=" + col + ")";
    }

    public static String severityToString(ValidationEvent event) {
        switch (event.getSeverity()) {
            case 0: {
                return "WARNING";
            }
            case 1: {
                return "ERROR";
            }
            case 2: {
                return "FATAL ERROR";
            }
        }
        return "UNKNOWN";
    }

    public static String getCanonicalOrAbsolute(File path, CfmLogger logger) {
        try {
            return path.getCanonicalPath();
        }
        catch (IOException e) {
            String absolutePath = path.getAbsolutePath();
            if (logger != null) {
                logger.log(Level.INFO, "Failed to canonicalize the path " + path.toString() + ", (using " + absolutePath + " instead): " + e.toString());
            }
            return absolutePath;
        }
    }

    public static void myAssert(boolean expressionThatMustBeTrue) {
        if (!expressionThatMustBeTrue) {
            AssertionError e = new AssertionError((Object)"Assert failed");
            throw e;
        }
    }

    public static void myAssert(String explanation, boolean expressionThatMustBeTrue) {
        if (!expressionThatMustBeTrue) {
            AssertionError e = new AssertionError((Object)("Assert failed: " + explanation));
            throw e;
        }
    }

    public static void preconditionNotNull(Object object, String varName) {
        if (object == null) {
            throw new IllegalArgumentException(varName + " cannot be null.");
        }
    }

    public static String combinePaths(String path1, String path2) {
        if (path1.length() == 0 || path2.length() == 0) {
            return path1 + path2;
        }
        return path1 + File.pathSeparator + path2;
    }

    public static String evaluatePath(String thisPath, String parentPath) {
        return CfmUtil.evaluatePath(new File(thisPath), parentPath);
    }

    public static String evaluatePath(File thisPath, String parentPath) {
        if (thisPath.isAbsolute()) {
            return thisPath.getPath();
        }
        return parentPath + File.separator + thisPath.getPath();
    }

    public static Set union(Set x, Set y) {
        HashSet join = new HashSet(x);
        join.addAll(y);
        return join;
    }

    public static boolean intersect(Set x, Set y) {
        HashSet intersection = new HashSet(x);
        intersection.retainAll(y);
        return !intersection.isEmpty();
    }

    public static String noNull(String desiredValue, String defaultValue) {
        if (desiredValue != null) {
            return desiredValue;
        }
        return defaultValue;
    }

    public static String trimmedNoNullOrEmptyString(String desiredValue, String defaultValue) {
        if (desiredValue != null && (desiredValue = desiredValue.trim()).length() != 0) {
            return desiredValue;
        }
        return defaultValue;
    }

    public static PrintStream noNullPrintStream(PrintStream stream) {
        if (stream != null) {
            return stream;
        }
        return new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
    }

    public static boolean nullOrEqual(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static int longCompare(long l1, long l2) {
        return l1 < l2 ? -1 : (l1 == l2 ? 0 : 1);
    }

    public static int intCompare(int i1, int i2) {
        return i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
    }

    public static Comparator getLongComparator() {
        return longComparator;
    }
}

