/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.support;

import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;

public class Arguments {
    static CfmLogger cfmLogger = CfmLogger.getCfmLogger(CfmLogger.CFM_LOGGER_NAME);
    private final String[] freeStandingArgs;
    private final Map argTable = new Hashtable();

    public Arguments(String[] inputArgs) {
        if (inputArgs == null) {
            inputArgs = new String[]{};
        }
        if (inputArgs.length == 0) {
            this.freeStandingArgs = new String[0];
            return;
        }
        int lastOptionIndex = -1;
        for (int i = 0; i < inputArgs.length; ++i) {
            String option = inputArgs[i];
            int j = i + 1;
            String value = j < inputArgs.length && inputArgs[j] != null ? inputArgs[j] : "";
            if (!this.isOption(option)) continue;
            if (!((option = Arguments.getOption(option)) == null | option.length() == 0)) {
                if (this.isOption(value)) {
                    this.argTable.put(option, "");
                } else {
                    this.argTable.put(option, value);
                    if (j < inputArgs.length) {
                        // empty if block
                    }
                }
            }
            lastOptionIndex = ++i;
        }
        int firstNonOptionIndex = lastOptionIndex + 1;
        int freeStandingArgc = inputArgs.length - firstNonOptionIndex;
        this.freeStandingArgs = new String[freeStandingArgc];
        for (int i2 = 0; i2 < freeStandingArgc; ++i2) {
            this.freeStandingArgs[i2] = inputArgs[i2 + firstNonOptionIndex];
            ++i2;
        }
    }

    public String[] getFreeStandingArgs() {
        return this.freeStandingArgs;
    }

    public String getString(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        return (String)this.argTable.get(name);
    }

    public boolean contains(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return this.argTable.get(name) != null;
    }

    public String toString() {
        return "Options:\n" + this.argTable.toString() + "\nFree-Standing Args: " + CfmUtil.arrayToString(this.getFreeStandingArgs(), "\n");
    }

    public boolean validateOptions(String optionList) {
        if (this.argTable.isEmpty() || optionList == null || optionList.length() == 0) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(optionList, " ,");
        int cnt = st.countTokens();
        if (cnt == 0) {
            return true;
        }
        String[] opts = new String[cnt];
        for (int i = 0; i < cnt; ++i) {
            opts[i] = st.nextToken();
        }
        for (String key : this.argTable.keySet()) {
            if (key == null || key.length() == 0) continue;
            boolean found = false;
            for (int i = 0; i < cnt; ++i) {
                if (!opts[i].equals(key)) continue;
                found = true;
                break;
            }
            if (found) continue;
            cfmLogger.log(Level.INFO, "'" + key + "' not valid ");
            return false;
        }
        return true;
    }

    private boolean isOption(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (s.charAt(0) == '-') {
            return s.length() <= 1 || !Character.isDigit(s.charAt(1));
        }
        return false;
    }

    private static String getOption(String s) {
        return s.substring(1).trim();
    }
}

