/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.oraxdk;

import java.io.PrintWriter;
import oracle.sysman.emCfg.oraxdk.BuilderArgOrParamRef;
import oracle.sysman.emCfg.oraxdk.BuilderConditionRef;
import oracle.sysman.emCfg.oraxdk.BuilderObject;
import oracle.sysman.emCfg.oraxdk.BuilderPlugInInvocation;
import oracle.sysman.emCfg.oraxdk.IStepBuilder;
import oracle.sysman.emCfg.types.ActionType;

class BuilderStep
extends BuilderObject
implements IStepBuilder {
    private int stepID = 0;
    private int priority = 0;
    private boolean isStandAloneOnly = false;
    private boolean required = true;
    private ActionType actionType;
    private String owner = null;
    private String idref = null;

    BuilderStep(BuilderObject parent, String name, int pri) {
        super(4);
        this.priority = pri;
        this.indent = parent.indent + "\t";
        this.setId(parent.ident, name);
    }

    @Override
    public void addConditionRef(String idref) {
        this.addItem(new BuilderConditionRef(this, idref));
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.required = isRequired;
    }

    @Override
    public void setStandalonely(boolean isStandalonely) {
        this.isStandAloneOnly = isStandalonely;
    }

    @Override
    public void setStandAloneOnly(boolean isStandAloneOnly) {
        this.isStandAloneOnly = isStandAloneOnly;
    }

    @Override
    public void addActionRef(String idref) {
        this.idref = idref;
    }

    @Override
    public void addAggregateActionRef(ActionType actionType, String owner, String idref) {
        this.actionType = actionType;
        this.owner = owner;
        this.idref = idref;
    }

    @Override
    public void addPlugInInvocation(String plugInRef, BuilderArgOrParamRef[] refs) {
        this.addPlugInInvocation(plugInRef, refs, null);
    }

    @Override
    public void addPlugInInvocation(String plugInRef, BuilderArgOrParamRef[] refs, String cp) {
        BuilderPlugInInvocation plugInInvocation = new BuilderPlugInInvocation(this, this.stepID++, plugInRef, refs);
        plugInInvocation.setClassPath(cp);
        this.addItem(plugInInvocation);
    }

    @Override
    void expressHead(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        sb.append("<agg:ActionStep standaloneonly=\"" + this.isStandAloneOnly + "\" required=\"" + this.required + "\" priority=\"");
        sb.append(this.priority);
        sb.append("\" desc=\"");
        sb.append("BuilderGenerated Description named for scope of ActionStep ");
        sb.append(this.ident);
        sb.append(" having its priority set to ");
        sb.append(this.priority + "\">");
        pw.println(sb.toString());
    }

    @Override
    void expressTail(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        if (this.actionType != null || this.owner != null || this.idref != null) {
            if (this.owner == null) {
                sb.append("\t <Agg:ActionRef idref=\"" + this.idref + "\" />\n" + this.indent);
            } else {
                sb.append("\t <Agg:AggregateActionRef owner=\"" + this.owner + "\"");
                if (this.idref != null) {
                    sb.append(" idref=\"" + this.idref + "\"");
                } else if (this.actionType != null) {
                    sb.append(" type=\"" + this.actionType.getStatusBriefString() + "\"");
                } else {
                    throw new Error("IStepBuilder:idref or ActionType must be specified to match referred Action!");
                }
            }
            sb.append(" />\n" + this.indent);
        }
        sb.append("</agg:ActionStep>");
        pw.println(sb.toString());
    }
}

