/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.oraxdk;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.sysman.emCfg.oraxdk.BuilderArgOrParam;
import oracle.sysman.emCfg.oraxdk.BuilderArgOrParamRef;
import oracle.sysman.emCfg.oraxdk.BuilderObject;
import oracle.sysman.emCfg.oraxdk.IBuilderPlugIn;
import oracle.sysman.emCfg.types.PlugInInvocation;
import oracle.sysman.emCfg.types.PlugInMode;
import oracle.sysman.emCfg.types.PlugInType;

class BuilderPlugIn
extends BuilderObject
implements IBuilderPlugIn {
    String modelRef;
    String plugName;
    boolean needParams = false;
    String cmd;
    BuilderArgOrParamRef[] argsOrParamsRefs;
    PlugInMode mode = PlugInMode.RERUNNABLE;
    PlugInInvocation invocation = PlugInInvocation.WAITFOR;
    boolean displayVisible = true;
    List withTypes = new Vector();

    BuilderPlugIn(BuilderObject parent, String plugName, String command, String modelRef, BuilderArgOrParamRef[] argsOrParamsRefs) {
        super(8);
        this.indent = parent.indent + "\t";
        this.cmd = command;
        this.argsOrParamsRefs = argsOrParamsRefs;
        this.modelRef = modelRef;
        this.plugName = plugName;
        if (argsOrParamsRefs != null && argsOrParamsRefs.length > 0) {
            this.needParams = true;
        }
        this.setId(parent.ident, plugName);
        this.addItem(new BuilderArgOrParam(this, argsOrParamsRefs));
    }

    @Override
    public void setMode(PlugInMode mode) {
        this.mode = mode;
    }

    @Override
    public void setInvocation(PlugInInvocation invocation) {
        this.invocation = invocation;
    }

    @Override
    public void setDisplay(boolean displayVisible) {
        this.displayVisible = displayVisible;
    }

    @Override
    public void addType(PlugInType type) {
        this.withTypes.add(type);
    }

    @Override
    void expressHead(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        sb.append("<agg:PlugIn id=\"");
        sb.append(this.self + "\" display=\"" + Boolean.toString(this.displayVisible) + "\" mode=\"" + this.mode.toString() + "\" invocation=\"" + this.invocation.toString() + "\" ");
        if (this.withTypes.isEmpty()) {
            throw new Error("BuilderPlugIn:PlugInType MUST be specified!");
        }
        String plugSupportedTypes = "";
        Iterator subtypes = this.withTypes.iterator();
        while (subtypes.hasNext()) {
            PlugInType n = (PlugInType)subtypes.next();
            plugSupportedTypes = plugSupportedTypes + n.getStatusBriefString();
            if (!subtypes.hasNext()) continue;
            plugSupportedTypes = plugSupportedTypes + " ";
        }
        sb.append(" types=\"" + plugSupportedTypes + "\"");
        sb.append(" desc=\"Descr. for " + this.plugName + "\">");
        if (this.cmd != null) {
            if (this.cmd.indexOf("/") >= 0) {
                sb.append("\n" + this.indent + "\t<agg:CmdExec>" + this.cmd + "</agg:CmdExec>");
            } else if (this.cmd.indexOf(":") >= 0) {
                sb.append("\n" + this.indent + "\t<agg:JavaClassMethod>" + this.cmd + "</agg:JavaClassMethod>");
            } else {
                sb.append("\n" + this.indent + "\t<agg:JavaClass>" + this.cmd + "</agg:JavaClass>");
            }
        } else {
            sb.append("\n" + this.indent + "\t<agg:PlugInModelRef idref=\"" + this.modelRef + "\"/>");
        }
        pw.println(sb.toString());
    }

    @Override
    void expressTail(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        sb.append("</agg:PlugIn>");
        pw.println(sb.toString());
    }
}

