/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.oraxdk;

import java.io.PrintWriter;
import java.util.List;
import java.util.Vector;
import oracle.sysman.emCfg.oraxdk.BuilderObject;
import oracle.sysman.emCfg.oraxdk.BuilderParamValueDataType;
import oracle.sysman.emCfg.oraxdk.BuilderParameter;
import oracle.sysman.emCfg.oraxdk.BuilderRef;
import oracle.sysman.emCfg.oraxdk.BuilderSelfConstraint;
import oracle.sysman.emCfg.oraxdk.IParamModelBuilder;
import oracle.sysman.emCfg.oraxdk.IParameterBuilder;
import oracle.sysman.emCfg.types.BuilderDataTypes;
import oracle.sysman.emCfg.types.BuilderParamModelType;
import oracle.sysman.emCfg.types.BuilderParamRefType;
import oracle.sysman.emCfg.types.BuilderParameterType;

class BuilderParameterModel
extends BuilderObject
implements IParamModelBuilder {
    String modelName;
    BuilderParamModelType modelType;
    int count = 0;
    int idNum = 0;
    List members = new Vector();
    IParameterBuilder parameterBuilder = null;

    public BuilderParameterModel(BuilderObject parent, String modelName, BuilderParamModelType modelType) {
        super(18);
        this.modelName = modelName;
        this.modelType = modelType;
        this.indent = parent.indent + "\t";
        this.setId(parent.ident, modelName);
    }

    @Override
    public IParameterBuilder getParameterBuilder() {
        return this.parameterBuilder;
    }

    @Override
    public IParameterBuilder addParameter(String parameterName, BuilderParameterType parameterType, String defaultValue) {
        this.parameterBuilder = new BuilderParameter(this, parameterName, parameterType, defaultValue);
        this.members.add(this.parameterBuilder);
        return this.parameterBuilder;
    }

    @Override
    public void addModelRef(BuilderParamRefType referenceType, String idref) {
        this.members.add(new BuilderRef(this, referenceType, idref));
    }

    @Override
    public void addModelDataType(String valueName, BuilderDataTypes valueDataType, String prefix) {
        this.members.add(new BuilderParamValueDataType(this, valueName, valueDataType, prefix));
    }

    @Override
    public void addSelfConstraints(String constraintName, String[] cmdToConstrain) {
        for (int i = 0; i < cmdToConstrain.length; ++i) {
            this.members.add(new BuilderSelfConstraint(this, constraintName + "_" + i, cmdToConstrain[i]));
        }
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    void expressHead(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        sb.append("<agg:" + this.modelType.getStatusBriefString() + " id=\"" + this.self + "\"");
        if (this.count != 0) {
            sb.append(" count=\"" + this.count + "\"");
        }
        sb.append(">");
        pw.println(sb.toString());
        for (BuilderObject o : this.members) {
            o.expressHead(pw);
            o.expressSelf(pw);
            o.expressTail(pw);
        }
    }

    @Override
    void expressTail(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        sb.append("</agg:" + this.modelType.getStatusBriefString() + ">");
        pw.println(sb.toString());
    }
}

