/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.oraxdk;

import java.io.PrintWriter;
import java.util.List;
import java.util.Vector;
import oracle.sysman.emCfg.oraxdk.BuilderArgOrParamRef;
import oracle.sysman.emCfg.oraxdk.BuilderConstraint;
import oracle.sysman.emCfg.oraxdk.BuilderExtDependency;
import oracle.sysman.emCfg.oraxdk.BuilderObject;
import oracle.sysman.emCfg.oraxdk.BuilderParam;
import oracle.sysman.emCfg.oraxdk.BuilderRef;
import oracle.sysman.emCfg.oraxdk.BuilderSelfConstraint;
import oracle.sysman.emCfg.oraxdk.BuilderSelfDependency;
import oracle.sysman.emCfg.oraxdk.IParamBuilder;
import oracle.sysman.emCfg.oraxdk.IParameterBuilder;
import oracle.sysman.emCfg.types.BuilderParamRefType;
import oracle.sysman.emCfg.types.BuilderParameterType;
import oracle.sysman.emCfg.types.ParameterMode;
import oracle.sysman.emCfg.types.ParameterScope;

class BuilderParameter
extends BuilderObject
implements IParameterBuilder {
    String defaultValue = null;
    BuilderParameterType paramType = null;
    String paramName = null;
    boolean encryptB = false;
    boolean transientB = false;
    ParameterScope scope = ParameterScope.VISIBLE;
    ParameterMode mode = ParameterMode.SETTABLE;
    private String paramSchemaType = "Parameter";
    private int count = 0;
    private List members = new Vector();

    BuilderParameter(BuilderObject parent, String parameterName, BuilderParameterType parameterType, String defaultVal) {
        super(9);
        this.defaultValue = defaultVal;
        this.paramType = parameterType;
        this.paramName = parameterName;
        this.indent = parent.indent + "\t";
        this.setId(parent.ident, this.paramName);
        if (this.paramType.equals(BuilderParameterType.BUILDER_PARAMETER_VIRTUAL)) {
            this.paramSchemaType = BuilderParameterType.BUILDER_PARAMETER_VIRTUAL.getStatusBriefString();
        }
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void setEncrypt(boolean isEncrypt) {
        this.encryptB = isEncrypt;
    }

    @Override
    public void setTransient(boolean isTransient) {
        this.transientB = isTransient;
    }

    @Override
    public void setMode(ParameterMode mode) {
        this.mode = mode;
    }

    @Override
    public void setScope(ParameterScope scope) {
        this.scope = scope;
    }

    @Override
    public IParamBuilder addParam(String paramName, BuilderParameterType parameterType) {
        BuilderParam prm = new BuilderParam(this, paramName, parameterType);
        this.members.add(prm);
        return prm;
    }

    @Override
    public void addSelfConstraint(String id, String cmdToExec) {
        this.members.add(new BuilderSelfConstraint(this, id, cmdToExec));
    }

    @Override
    public void addConstraint(String id, String classMethod, BuilderArgOrParamRef[] refs) {
        if (!this.paramType.equals(BuilderParameterType.BUILDER_PARAMETER_VIRTUAL)) {
            throw new Error("Constraint can be attached to VirtualParameter or Aggregates only!");
        }
        this.members.add(new BuilderConstraint(this, id, classMethod, refs, !this.paramType.equals(BuilderParameterType.BUILDER_PARAMETER_VIRTUAL)));
    }

    @Override
    public void addSelfDependency(String id, String classMethod, BuilderArgOrParamRef[] refs) {
        this.members.add(new BuilderSelfDependency(this, id, classMethod, refs));
    }

    @Override
    public void addExtDependency(String id, String classMethod, BuilderArgOrParamRef derivedRef) {
        if (!this.paramType.equals(BuilderParameterType.BUILDER_PARAMETER_VIRTUAL)) {
            throw new Error("ExtDependency can be attached to VirtualParameter only!");
        }
        this.members.add(new BuilderExtDependency(this, id, classMethod, derivedRef));
    }

    @Override
    public void addModelRef(BuilderParamRefType refType, String idref) {
        this.members.add(new BuilderRef(this, refType, idref));
    }

    @Override
    public void addModelRef(BuilderParamRefType refType, String owner, String idref) {
        this.members.add(new BuilderRef(this, refType, owner, idref));
    }

    @Override
    void expressHead(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        sb.append("<agg:" + this.paramSchemaType + " id=\"" + this.self + "\"");
        if (!this.paramType.equals(BuilderParameterType.BUILDER_PARAMETER_VIRTUAL)) {
            sb.append(" encrypt=\"" + Boolean.toString(this.encryptB) + "\"" + " transient=\"" + Boolean.toString(this.transientB) + "\"" + " mode=\"" + this.mode.toString() + "\"" + " scope=\"" + this.scope.toString() + "\"");
        }
        if (this.paramType.equals(BuilderParameterType.BUILDER_PARAMETER_ARRAY) || this.paramType.equals(BuilderParameterType.BUILDER_PARAMETER_SIMPLEST_ARRAY) || this.paramType.equals(BuilderParameterType.BUILDER_PARAMETER_SIMPLE_ARRAY)) {
            sb.append(" count=\"" + this.count + "\"");
        }
        sb.append(">");
        pw.println(sb.toString());
        for (BuilderObject o : this.members) {
            o.expressHead(pw);
            o.expressSelf(pw);
            o.expressTail(pw);
        }
    }

    @Override
    void expressTail(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        sb.append("</agg:" + this.paramSchemaType + ">");
        pw.println(sb.toString());
    }
}

