/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.oraxdk;

import java.io.PrintWriter;
import java.util.List;
import java.util.Vector;
import oracle.sysman.emCfg.oraxdk.BuilderArgOrParamRef;
import oracle.sysman.emCfg.oraxdk.BuilderObject;
import oracle.sysman.emCfg.oraxdk.BuilderParamValueDataType;
import oracle.sysman.emCfg.oraxdk.BuilderRef;
import oracle.sysman.emCfg.oraxdk.BuilderSelfConstraint;
import oracle.sysman.emCfg.oraxdk.BuilderSelfDependency;
import oracle.sysman.emCfg.oraxdk.IParamBuilder;
import oracle.sysman.emCfg.types.BuilderDataTypes;
import oracle.sysman.emCfg.types.BuilderParamRefType;
import oracle.sysman.emCfg.types.BuilderParameterType;

class BuilderParam
extends BuilderObject
implements IParamBuilder {
    String paramName;
    BuilderParameterType paramType;
    int count = 0;
    int idNum = 0;
    List members = new Vector();
    IParamBuilder paramBuilder = null;

    public BuilderParam(BuilderObject parent, String paramName, BuilderParameterType paramType) {
        super(18);
        this.paramName = paramName;
        this.paramType = paramType;
        this.indent = parent.indent + "\t";
        this.setId(parent.ident, paramName);
        this.paramBuilder = this;
    }

    @Override
    public IParamBuilder getParamBuilder() {
        return this;
    }

    @Override
    public IParamBuilder addParam(String paramName, BuilderParameterType paramType) {
        this.paramBuilder = new BuilderParam(this, paramName, paramType);
        this.members.add(this.paramBuilder);
        return this.paramBuilder;
    }

    @Override
    public void addModelRef(BuilderParamRefType referenceType, String idref) {
        this.members.add(new BuilderRef(this, referenceType, idref));
    }

    @Override
    public void addModelRef(BuilderParamRefType referenceType, String owner, String idref) {
        this.members.add(new BuilderRef(this, referenceType, owner, idref));
    }

    @Override
    public void addSelfConstraint(String constraintName, String cmdToConstrain) {
        this.members.add(new BuilderSelfConstraint(this, constraintName, cmdToConstrain));
    }

    @Override
    public void addSelfConstraints(String constraintName, String[] cmdsToConstrain) {
        for (int i = 0; i < cmdsToConstrain.length; ++i) {
            this.members.add(new BuilderSelfConstraint(this, constraintName + "_" + i, cmdsToConstrain[i]));
        }
    }

    @Override
    public void addSelfDependency(String id, String classMethod, BuilderArgOrParamRef[] refs) {
        this.members.add(new BuilderSelfDependency(this, id, classMethod, refs));
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void addParamValueDataType(String paramValueName, BuilderDataTypes paramValueDataType) {
        this.members.add(new BuilderParamValueDataType(this, paramValueName, paramValueDataType));
    }

    @Override
    public void addParamValueDataType(String paramValueName, BuilderDataTypes paramValueDataType, String prefix) {
        this.members.add(new BuilderParamValueDataType(this, paramValueName, paramValueDataType, prefix));
    }

    @Override
    void expressHead(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        sb.append("<agg:" + this.paramType.getStatusBriefString() + " id=\"" + this.self + "\"");
        if (this.count != 0) {
            sb.append(" count=\"" + this.count + "\"");
        }
        sb.append(">");
        pw.println(sb.toString());
        for (BuilderObject o : this.members) {
            o.expressHead(pw);
            o.expressSelf(pw);
            o.expressTail(pw);
        }
    }

    @Override
    void expressTail(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        sb.append("</agg:" + this.paramType.getStatusBriefString() + ">");
        pw.println(sb.toString());
    }
}

