/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.oraxdk;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.Constants;
import oracle.sysman.emCfg.oraxdk.BuilderAggregate;
import oracle.sysman.emCfg.oraxdk.IAggregateBuilder;
import oracle.sysman.emCfg.oraxdk.IDescriptionBuilder;
import oracle.sysman.emCfg.oraxdk.ModelBuilder;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.Filer;
import oracle.sysman.emCfg.types.BuilderAggregateType;

public class BuilderDescription
extends ModelBuilder
implements IDescriptionBuilder {
    private static final String SCHEMA_VERSION = "1.0.0";
    private IAggregateBuilder ab;
    private String aggrName;
    private String inheritanceNameSpace = null;
    private String includes = "common";
    private AggregateVersion descriptionVersion = Constants.DEFAULT_AGGREGATE_VERSION;

    public BuilderDescription(String aggrName, BuilderAggregateType aggrType) {
        super(0);
        this.aggrName = aggrName;
        this.ab = new BuilderAggregate(this, aggrName, aggrType);
        this.addItem((BuilderAggregate)this.ab);
    }

    public BuilderDescription(String descriptionName) {
        super(0);
        this.aggrName = descriptionName;
    }

    @Override
    public void setIncludes(String includes) {
        this.includes = includes;
    }

    @Override
    public void setInheritance(String nameSpace) {
        this.inheritanceNameSpace = nameSpace;
    }

    @Override
    public void setVersion(AggregateVersion version) {
        CfmUtil.preconditionNotNull(version, "version");
        this.descriptionVersion = version;
    }

    @Override
    public IAggregateBuilder addAggregate(String aggrName, BuilderAggregateType aggrType) {
        this.aggrName = aggrName;
        this.ab = new BuilderAggregate(this, aggrName, aggrType);
        this.addItem((BuilderAggregate)this.ab);
        return this.ab;
    }

    @Override
    public IAggregateBuilder getAggregateBuilder() {
        return this.ab;
    }

    @Override
    void expressHead(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- This XML generated by EmCfg's Description Builder -->\n<agg:Descriptions version=\"").append(SCHEMA_VERSION).append("\" xmlns:agg=\"http://www.oracle.com/sysman/emCfg/AggregateDescriptions\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ").append("xsi:schemaLocation=\"http://www.oracle.com/sysman/emCfg/AggregateDescriptions oracle/sysman/emCfg/main/AggregateDescriptions.xsd\">");
        if (this.inheritanceNameSpace != null) {
            sb.append("\n\t<agg:Inheritance ns=\"" + this.inheritanceNameSpace + "\" includes=\"" + this.includes + "\" />");
        }
        pw.println(sb.toString());
    }

    @Override
    void expressTail(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        sb.append("</agg:Descriptions>");
        pw.println(sb.toString());
    }

    @Override
    public void save() throws IOException {
        this.saveToPath(this.getDefaultOutputPath());
    }

    @Override
    public void saveToDirectory(String directory) throws IOException {
        this.saveToPath(directory + File.separator + this.getDefaultOutputFilename());
    }

    private void saveToPath(String path) throws IOException {
        FileOutputStream fos = null;
        PrintWriter pw = null;
        File aggrFile = null;
        try {
            aggrFile = File.createTempFile(this.aggrName, ".xml");
            fos = new FileOutputStream(aggrFile);
            pw = new PrintWriter(fos, true);
            this.expressHead(pw);
            this.expressSelf(pw);
            this.expressTail(pw);
        }
        catch (Exception e) {
            throw new IOException("BuilderDescription: unable to save: " + e.toString());
        }
        finally {
            try {
                if (pw != null) {
                    pw.flush();
                    pw.close();
                }
                if (fos != null) {
                    fos.close();
                }
                Filer.copyOneFile(path, aggrFile.getAbsolutePath(), 777, true);
                aggrFile.delete();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public String getDefaultOutputPath() {
        return this.getDefaultOutputDirectory() + this.getDefaultOutputFilename();
    }

    @Override
    public String getDefaultOutputFilename() {
        return this.aggrName + "." + this.descriptionVersion.toFilenameString() + ".xml";
    }

    @Override
    public String getDefaultOutputDirectory() {
        return Constants.DEFAULT_DESCRIPTIONS_PATH + File.separator;
    }
}

