/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.oraxdk;

import java.io.PrintWriter;
import oracle.sysman.emCfg.oraxdk.BuilderArgOrParamRef;
import oracle.sysman.emCfg.oraxdk.BuilderObject;

class BuilderConstraint
extends BuilderObject {
    private String cmd = null;
    private String id;
    private BuilderArgOrParamRef[] refs;
    private boolean skip = false;
    private boolean headsOn = false;

    BuilderConstraint(BuilderObject parent, String id, String cmdToConstrain, BuilderArgOrParamRef[] refs, boolean expressBefore) {
        super(19);
        this.cmd = cmdToConstrain;
        this.refs = refs;
        this.id = id;
        this.headsOn = expressBefore;
        this.indent = parent.indent + "\t";
        this.setId(parent.ident, id);
        if (cmdToConstrain == null) {
            this.skip = true;
        }
    }

    private void expressRefs(StringBuffer sb) {
        if (this.cmd.indexOf(":") > 0) {
            sb.append("\t<agg:JavaClassMethod>" + this.cmd + "</agg:JavaClassMethod>");
        } else {
            sb.append(this.indent + "\t<agg:CmdExec>" + this.cmd + "</agg:CmdExec>");
        }
        for (int i = 0; i < this.refs.length; ++i) {
            sb.append("\n\t" + this.indent + "<agg:" + this.refs[i].getSchemaConstruct());
            if (this.refs[i].getOwner() != null) {
                sb.append(" owner=\"" + this.refs[i].getOwner() + "\"");
            }
            if (this.refs[i].getIdref() != null) {
                sb.append(" idref=\"" + this.refs[i].getIdref() + "\"");
            }
            sb.append(" />");
        }
    }

    @Override
    void expressHead(PrintWriter pw) {
        if (this.skip) {
            return;
        }
        StringBuffer sb = new StringBuffer(this.indent);
        sb.append("<agg:Constraint id=\"" + this.id + "\">");
        if (this.headsOn) {
            sb.append("\n" + this.indent);
            this.expressRefs(sb);
        }
        pw.println(sb.toString());
    }

    @Override
    void expressTail(PrintWriter pw) {
        if (this.skip) {
            return;
        }
        StringBuffer sb = new StringBuffer(this.indent);
        if (!this.headsOn) {
            this.expressRefs(sb);
            sb.append("\n" + this.indent);
        }
        sb.append("</agg:Constraint>");
        pw.println(sb.toString());
    }
}

