/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.oraxdk;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.sysman.emCfg.oraxdk.BuilderAction;
import oracle.sysman.emCfg.oraxdk.BuilderArgOrParamRef;
import oracle.sysman.emCfg.oraxdk.BuilderCondition;
import oracle.sysman.emCfg.oraxdk.BuilderConstraint;
import oracle.sysman.emCfg.oraxdk.BuilderDependency;
import oracle.sysman.emCfg.oraxdk.BuilderObject;
import oracle.sysman.emCfg.oraxdk.BuilderParameter;
import oracle.sysman.emCfg.oraxdk.BuilderPlugIn;
import oracle.sysman.emCfg.oraxdk.IActionBuilder;
import oracle.sysman.emCfg.oraxdk.IAggregateBuilder;
import oracle.sysman.emCfg.oraxdk.IBuilderPlugIn;
import oracle.sysman.emCfg.oraxdk.IParameterBuilder;
import oracle.sysman.emCfg.oraxdk.ModelBuilder;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.BuilderAggregateType;
import oracle.sysman.emCfg.types.BuilderParameterType;
import oracle.sysman.emCfg.types.DescriptionAggregateRef;

class BuilderAggregate
extends ModelBuilder
implements IAggregateBuilder {
    private BuilderAggregateType aggrType;
    private List referred = new Vector();
    private int count = 0;

    public BuilderAggregate(BuilderObject parent, String name) {
        this(parent, name, BuilderAggregateType.BUILDER_AGGREGATE_SIMPLEST);
    }

    public BuilderAggregate(BuilderObject parent, String name, BuilderAggregateType typeAggregate) {
        super(1);
        this.aggrType = typeAggregate;
        this.indent = parent.indent + "\t";
        this.setId(parent.ident, name);
    }

    @Override
    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public void addAggRef(DescriptionAggregateRef ref) {
        if (this.aggrType.equals(BuilderAggregateType.BUILDER_AGGREGATE_SIMPLEST)) {
            throw new Error("IAggregateBuilder:SimplestAggregate may not have references to other aggregates!");
        }
        this.referred.add(ref.getXMLString());
    }

    @Override
    public void addDependency(String id, String classMethod, BuilderArgOrParamRef derivedRef, BuilderArgOrParamRef[] refs) {
        this.addItem(new BuilderDependency(this, id, classMethod, derivedRef, refs));
    }

    @Override
    public void addConstraint(String id, String classMethod, BuilderArgOrParamRef[] refs) {
        this.addItem(new BuilderConstraint(this, id, classMethod, refs, true));
    }

    @Override
    public void addCondition(String name, boolean value) {
        this.addItem(new BuilderCondition(this, name, value));
    }

    @Override
    public IActionBuilder addAction(String name, ActionType[] actionTypes) {
        BuilderAction act = new BuilderAction(this, name, actionTypes);
        this.addItem(act);
        return act;
    }

    @Override
    public IBuilderPlugIn addPlugIn(String plugInName, String cmdToExec, String modelRef, BuilderArgOrParamRef[] refs) {
        BuilderPlugIn plug = new BuilderPlugIn(this, plugInName, cmdToExec, modelRef, refs);
        this.addItem(plug);
        return plug;
    }

    @Override
    public IParameterBuilder addParameterShell(String parameterName, BuilderParameterType parameterType, String defaultVal) {
        if (this.aggrType.equals(BuilderAggregateType.BUILDER_AGGREGATE_SIMPLEST) && parameterType.equals(BuilderParameterType.BUILDER_PARAMETER_VIRTUAL)) {
            throw new Error("IAggregateBuilder:SimplestAggregate may not have VirtualParameters!");
        }
        if (!this.aggrType.equals(BuilderAggregateType.BUILDER_AGGREGATE_SIMPLEST) && !parameterType.equals(BuilderParameterType.BUILDER_PARAMETER_VIRTUAL)) {
            throw new Error("IAggregateBuilder:Only SimplestAggregate may have Parameters!");
        }
        BuilderParameter bp = new BuilderParameter(this, parameterName, parameterType, defaultVal);
        this.addItem(bp);
        return bp;
    }

    @Override
    void expressHead(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        sb.append("<agg:" + this.aggrType.getStatusBriefString() + " id=\"" + this.self + "\"");
        if (this.aggrType.equals(BuilderAggregateType.BUILDER_AGGREGATE_ARRAY) || this.aggrType.equals(BuilderAggregateType.BUILDER_AGGREGATE_SIMPLEST_ARRAY) || this.aggrType.equals(BuilderAggregateType.BUILDER_AGGREGATE_SIMPLE_ARRAY)) {
            sb.append(" count=\"" + this.count + "\"");
        }
        sb.append(" >");
        pw.println(sb.toString());
    }

    @Override
    void expressTail(PrintWriter pw) {
        StringBuffer sb = new StringBuffer(this.indent);
        Iterator i = this.referred.iterator();
        while (i.hasNext()) {
            sb.append("\t" + (String)i.next() + "\n" + this.indent);
        }
        sb.append("</agg:" + this.aggrType.getStatusBriefString() + ">");
        pw.println(sb.toString());
    }
}

