/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.main;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.support.Arguments;
import oracle.sysman.emCfg.support.Filer;
import oracle.xml.jaxb.orajaxb;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;

public class Driver {
    private static Arguments myArgs;
    private static String xsltString;
    static DOMParser parser;

    static boolean processArgs(String[] args, String options) {
        myArgs = new Arguments(args);
        return myArgs.validateOptions(options);
    }

    static String usage() {
        return "usage: \r\n\tjava oracle.sysman.emCfg.main.Driver [-verbose] -merge XSL INFILE_1 INFILE_2 ... \r\n\tjava oracle.sysman.emCfg.main.Driver [-verbose] [-prexslt XSL] -schema XSD_FILE -outputDir OUT_DIR -targetPkg JAVA_PKG\r\n";
    }

    public static void main(String[] args) throws Exception {
        if (!Driver.processArgs(args, "verbose,merge,schema,prexslt,outputDir,targetPkg")) {
            System.out.println(Driver.usage());
            System.exit(-1);
        }
        boolean debugB = myArgs.contains("verbose");
        if (myArgs.contains("merge")) {
            String mergeXSL = myArgs.getString("merge");
            String[] files2merge = myArgs.getFreeStandingArgs();
            if (files2merge == null || files2merge.length == 0) {
                System.out.println("There are no files to merge");
                System.exit(0);
            }
            if (debugB) {
                for (int i = 0; i < files2merge.length; ++i) {
                    System.out.println("File to merge[" + i + "] = \"" + files2merge[i] + "\"");
                }
            }
            Driver.merge(mergeXSL, files2merge, System.err, System.out);
        } else if (myArgs.contains("schema")) {
            String preXsltFile = myArgs.getString("prexslt");
            String schemaFile = myArgs.getString("schema");
            String outputDir = myArgs.getString("outputDir");
            String targetPkg = myArgs.getString("targetPkg");
            try {
                if (debugB) {
                    System.err.println("Driver: about to invoke  OraXdk gen for schema " + schemaFile);
                }
                Driver.oraxdkInvoker(debugB, preXsltFile, schemaFile, outputDir, targetPkg);
            }
            catch (CfwException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        System.exit(0);
    }

    public static void oraxdkInvoker(boolean debugB, String preXsltFile, String schemaFile, String outputDir, String targetPkg) throws CfwException {
        String schemaName;
        if (preXsltFile == null) {
            schemaName = schemaFile;
        } else {
            PrintStream ps;
            File tmpFile;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream psErr = new PrintStream(baos);
            try {
                tmpFile = File.createTempFile("cleandoc", "xsd");
                ps = new PrintStream(new FileOutputStream(tmpFile));
            }
            catch (Exception e) {
                throw new CfwException("CfmUtil.oraxdkInvoker: Unable to create tmp file for XSLT results:\n", e);
            }
            Driver.xsltOnFiles(preXsltFile, schemaFile, psErr, ps);
            psErr.close();
            ps.close();
            String errors = baos.toString();
            if (errors != null && errors.length() > 0) {
                throw new CfwException("CfmUtil.oraxdkInvoker: XSLT processing has caused:\n" + errors + "\n");
            }
            schemaName = tmpFile.getAbsolutePath();
        }
        try {
            String[] newArgs = new String[]{"-schema", schemaName, "-outputDir", outputDir, "-targetPkg", targetPkg};
            orajaxb.main((String[])newArgs);
            if (debugB) {
                System.out.println("CfmUtil.oraxdkInvoker: Done!");
            }
        }
        catch (Exception e) {
            new CfwException("CfmUtil.oraxdkInvoker: orajaxb.main raised exception:\n", e);
        }
    }

    public static String argsToString(String[] args) {
        int i;
        if (args == null || args.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < args.length - 1; ++i) {
            sb.append("\"" + args[i] + "\" ");
        }
        sb.append("\"" + args[i] + "\"");
        return sb.toString();
    }

    public static void merge(String xslt, String[] fileNames, PrintStream stderr, PrintStream stdout) throws Exception {
        if (fileNames.length == 0) {
            stderr.println("Processor.merge: no xml documents to merge");
            return;
        }
        if (fileNames.length == 1) {
            Driver.printFile(fileNames[0], stdout);
            return;
        }
        try {
            String xsltString = Filer.readFile(xslt);
            String xmlString = Driver.makeMergeXML(fileNames);
            Driver.xsltOnStrings(xsltString, xmlString, stderr, stdout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void merge(String[] fileNames, PrintStream stderr, PrintStream stdout) throws Exception {
        if (fileNames.length == 0) {
            stderr.println("Processor.merge: no aggregates to merge");
            return;
        }
        if (fileNames.length == 1) {
            Driver.printFile(fileNames[0], stdout);
            return;
        }
        try {
            String xmlString = Driver.makeMergeXML(fileNames);
            Driver.xsltOnStrings(xsltString, xmlString, stderr, stdout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String makeMergeXML(String[] filenames) throws Exception {
        try {
            StringBuffer xmlSB = new StringBuffer();
            if (filenames != null && filenames.length > 1) {
                xmlSB.append("<?xml version=\"1.0\"?>\n");
                xmlSB.append("<files>\n");
                for (int f = 0; f < filenames.length; ++f) {
                    block7: {
                        File fileIn = new File(filenames[f]);
                        if (fileIn == null) continue;
                        try {
                            if (!fileIn.canRead()) {
                                System.err.println("File " + filenames[f] + " cannot be read");
                            }
                            break block7;
                        }
                        catch (SecurityException e) {
                            System.err.println("File " + filenames[f] + " cannot be read " + e);
                        }
                        continue;
                    }
                    xmlSB.append("\t<file>" + Filer.createURL(filenames[f]).toString() + "</file>\n");
                }
                xmlSB.append("</files>");
                return xmlSB.toString();
            }
            throw new Exception("no files to merge");
        }
        catch (Exception e) {
            System.err.println("Failure making the dynamic XML document listing files to merge");
            e.printStackTrace();
            throw e;
        }
    }

    public static void xsltOnStrings(String xslString, String xmlString, PrintStream stderr, PrintStream stdout) throws Exception {
        try {
            File tmpFile = File.createTempFile("somedoc", "xsl");
            PrintWriter pw = new PrintWriter(new FileWriter(tmpFile));
            pw.println(xsltString);
            pw.flush();
            pw.close();
            URL xslURL = Filer.createURL(tmpFile);
            parser.parse(xslURL);
            XMLDocument xsldoc = parser.getDocument();
            XMLDocument xml = Driver.xmlDocFromString(xmlString);
            XSLProcessor processor = new XSLProcessor();
            processor.setBaseURL(xslURL);
            XSLStylesheet xsl = processor.newXSLStylesheet(xsldoc);
            processor.showWarnings(true);
            processor.setErrorStream((OutputStream)stderr);
            processor.processXSL(xsl, xml, (OutputStream)stdout);
        }
        catch (Exception e) {
            throw new Exception("Unable to perform XSLT", e);
        }
    }

    public static XMLDocument xmlDocFromString(String xsltString) throws Exception {
        try {
            File tmpFile = File.createTempFile("somedoc", "xml");
            PrintWriter pw = new PrintWriter(new FileWriter(tmpFile));
            pw.println(xsltString);
            pw.flush();
            pw.close();
            URL xslURL = Filer.createURL(tmpFile);
            parser.parse(xslURL);
            return parser.getDocument();
        }
        catch (Exception e) {
            throw new Exception("Failure making XML doc from string", e);
        }
    }

    public static void xsltOnFiles(String xslFile, String xmlFile, PrintStream stderr, PrintStream stdout) {
        try {
            URL xslURL = Filer.createURL(xslFile);
            parser.parse(xslURL);
            XMLDocument xsldoc = parser.getDocument();
            XMLDocument xml = Driver.xmlDocFromFile(xmlFile);
            XSLProcessor processor = new XSLProcessor();
            processor.setBaseURL(xslURL);
            XSLStylesheet xsl = processor.newXSLStylesheet(xsldoc);
            processor.showWarnings(true);
            processor.setErrorStream((OutputStream)stderr);
            processor.processXSL(xsl, xml, (OutputStream)stdout);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printFile(String filename, PrintStream stdout) {
        byte[] ar = Filer.fileToByteArray(filename);
        if (ar != null) {
            stdout.write(ar, 0, ar.length);
            stdout.flush();
        }
    }

    public static XMLDocument xmlDocFromFile(String fileName) throws Exception {
        try {
            URL xslURL = Filer.createURL(fileName);
            parser.parse(xslURL);
            return parser.getDocument();
        }
        catch (Exception e) {
            throw new Exception("Failure making XML doc from file", e);
        }
    }

    static {
        xsltString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\r\n<xsl:output method=\"xml\" version=\"1.0\" encoding=\"UTF-8\" indent=\"yes\"/>\r\n<xsl:template match=\"/\">\r\n<agg:Descriptions xmlns:agg=\"http://www.oracle.com/sysman/emCfg/AggregateDescriptions\"\r\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\nxsi:schemaLocation=\"http://www.oracle.com/sysman/emCfg/AggregateDescriptions oracle/sysman/emCfg/main/AggregateDescriptions.xsd\">\r\n<xsl:for-each select=\"files/file\">\r\n<xsl:variable name=\"file\" select=\"document(text())\"/>\r\n<xsl:copy-of select=\"$file/agg:Descriptions/child::*\"/>\r\n</xsl:for-each>\r\n</agg:Descriptions>\r\n</xsl:template>\r\n</xsl:stylesheet>";
        parser = new DOMParser();
        parser.setPreserveWhitespace(true);
    }
}

