/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.main;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import oracle.sysman.emCfg.client.CfwClient;
import oracle.sysman.emCfg.support.Arguments;

public class CfwClientDriver {
    private static Arguments myArgs;

    static boolean processArgs(String[] args, String options) {
        myArgs = new Arguments(args);
        return myArgs.validateOptions(options);
    }

    static String usage() {
        return "usage: \r\n\tjava oracle.sysman.emCfg.main.CfwClientDriver [-verbose] -loadAndPlay\r\n\t\t\t\t[-descriptionsPath DIR_NAME -instancesPath DIR_NAME]\r\n\t\t\t\t-aggregates AGGREGATE_IDs\r\n\t\t\t\t-clientClass CLASS_NAME\r\n";
    }

    public static void main(String[] args) throws Exception {
        if (!CfwClientDriver.processArgs(args, "verbose,loadAndPlay,clientClass,descriptionsPath,instancesPath,aggregates")) {
            System.out.println(CfwClientDriver.usage());
            System.exit(-1);
        }
        String descriptionsPath = null;
        if (myArgs.contains("descriptionsPath")) {
            descriptionsPath = myArgs.getString("descriptionsPath");
        }
        String instancesPath = null;
        if (myArgs.contains("instancesPath")) {
            instancesPath = myArgs.getString("instancesPath");
        }
        boolean useDefaultPaths = true;
        if (descriptionsPath != null || instancesPath != null) {
            useDefaultPaths = false;
            if (descriptionsPath == null || instancesPath == null) {
                System.out.println(CfwClientDriver.usage());
                System.exit(-1);
            }
        }
        boolean verbose = myArgs.contains("verbose");
        if (myArgs.contains("loadAndPlay")) {
            List<String> aggregateIDsAsList = null;
            String[] almostAllAggregateIDs = myArgs.getFreeStandingArgs();
            if (almostAllAggregateIDs != null) {
                String[] aggregateIDs = new String[1 + almostAllAggregateIDs.length];
                aggregateIDs[0] = myArgs.getString("aggregates");
                System.arraycopy(almostAllAggregateIDs, 0, aggregateIDs, 1, almostAllAggregateIDs.length);
                aggregateIDsAsList = Arrays.asList(aggregateIDs);
            } else {
                aggregateIDsAsList = new Vector<String>();
                aggregateIDsAsList.add(myArgs.getString("aggregates"));
            }
            CfwClient connectedCfwClient = useDefaultPaths ? CfwClient.connect(verbose, aggregateIDsAsList) : CfwClient.connect(verbose, "", descriptionsPath, instancesPath, aggregateIDsAsList);
            System.out.println("Connected as " + connectedCfwClient.getClass().getName());
            String clientClassName = myArgs.getString("clientClass");
            Class<?> clientClass = Class.forName(clientClassName);
            Class[] paramTypes = new Class[]{CfwClient.class};
            Constructor<?> clientClassConstructor = clientClass.getDeclaredConstructor(paramTypes);
            Object[] params = new Object[]{connectedCfwClient};
            Object clientInstance = clientClassConstructor.newInstance(params);
            Method jobMethod = clientClass.getMethod("job", null);
            try {
                jobMethod.invoke(clientInstance, null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        System.exit(0);
    }
}

