/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.logger;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.sysman.emCfg.common.Constants;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;

public class CfmSimpleFormatter
extends Formatter {
    public static final String LINE_SEPARATOR = "line.separator";
    private static String s_lineSeparator = CfmLogger.loggerProperties.getProperty("line.separator");
    private static final String S_SEPERATOR = ": ";
    private static int FINE = Level.FINE.intValue();
    private static boolean b_putTimestamp = CfmUtil.getBoolean(CfmLogger.loggerProperties, "CFM_LOG_PUTTIMESTAMP");

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        String message = this.formatMessage(record);
        try {
            Object[] parameters = record.getParameters();
            if (parameters != null && parameters.length != 0) {
                message = MessageFormat.format(message, parameters);
            }
        }
        catch (IllegalArgumentException parameters) {
            // empty catch block
        }
        Level level = record.getLevel();
        if (!level.equals(Level.OFF)) {
            sb.append(record.getLevel().getLocalizedName());
            sb.append(S_SEPERATOR);
        }
        if (b_putTimestamp) {
            Date dateNow = new Date();
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
            sb.append(df.format(dateNow));
            sb.append(S_SEPERATOR);
        }
        if (level.intValue() <= FINE) {
            sb.append(record.getSourceClassName());
            sb.append(S_SEPERATOR);
            sb.append(record.getSourceMethodName());
            sb.append(S_SEPERATOR);
        }
        sb.append(message);
        sb.append(s_lineSeparator);
        return sb.toString();
    }

    static {
        if (Constants.VERBOSE_OUTPUT) {
            b_putTimestamp = true;
        }
    }
}

