/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.logger;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;
import oracle.sysman.emCfg.common.Constants;
import oracle.sysman.emCfg.logger.CfmConsoleHandler;
import oracle.sysman.emCfg.logger.CfmErrorManager;
import oracle.sysman.emCfg.logger.CfmFileHandler;
import oracle.sysman.emCfg.logger.CfmLoggerUtil;
import oracle.sysman.emCfg.logger.CfmSimpleFormatter;
import oracle.sysman.emCfg.logger.CfmXMLFormatter;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.Filer;

public class CfmLogger
extends Logger {
    public static final String PROPERTY_NAME_LOG_LEVEL = "oracle.installer.logLevel";
    public static final String PROPERTY_NAME_PUT_TIMESTAMP = "CFM_LOG_PUTTIMESTAMP";
    public static final String PROPERTY_NAME_TIMESTAMPED_LOG_FILES = "CFM_TIMESTAMPED_LOG_FILES";
    public static final String LOGGER_NAME_DELIMITER = "|";
    private static final String S_SEPERATOR = ": ";
    private static final String SEVERE = "severe";
    private static final String WARNING = "warning";
    private static final String INFO = "info";
    private static final String CONFIG = "config";
    private static final String FINE = "fine";
    private static final String FINER = "finer";
    private static final String FINEST = "finest";
    public static final String BASIC = "BASIC";
    public static final String GENERAL = "GENERAL";
    public static final String DETAILED = "DETAILED";
    public static final String TRACE = "TRACE";
    public static final String XML_FORMAT = "XML";
    public static final String SIMPLE_FORMAT = "SIMPLE";
    public static final Properties loggerProperties = CfmUtil.loadProperties(Constants.CFM_LOGGER_PROPERTIES_NAME);
    public static final String LOG_DIR_RELATIVE_PATH = loggerProperties.getProperty("CFM_LOG_DIR", "cfgtoollogs/cfgfw").trim();
    public static final String LOG_SCRATCHPATH = "oracle.installer.logScratchPath";
    public static final String LOG_DIR_SCRATCHPATH = System.getProperty("oracle.installer.logScratchPath", "/tmp");
    public static final String LOG_DIR = Constants.DEFAULT_ORACLE_HOME + File.separator + LOG_DIR_RELATIVE_PATH;
    public static final String CFM_LOGGER_NAME = loggerProperties.getProperty("CFM_LOGGER", "CfmLogger").trim();
    public static final boolean TIMESTAMPED_LOG_FILES = CfmUtil.getBoolean(loggerProperties, "CFM_TIMESTAMPED_LOG_FILES", true);
    private static Level defaultLogLevel = CfmLogger.getLogLevel(loggerProperties.getProperty("oracle.installer.logLevel", "info").trim());
    private static CfmLogger defaultLogger = CfmLogger.getCfmLogger("CfmDefaultLogger", true);
    private static boolean b_putTimestamp = CfmUtil.getBoolean(loggerProperties, "CFM_LOG_PUTTIMESTAMP");
    private Hashtable hashHandlers = new Hashtable();
    private static Hashtable hashManagers;
    String prefix;

    protected CfmLogger(String name, String resourceBundleName, boolean useParent) {
        super(name, resourceBundleName);
        String logLevelStr = loggerProperties.getProperty("oracle.installer." + name + ".logLevel");
        Level logLevel = CfmLogger.getLogLevel(logLevelStr);
        if (logLevel != null) {
            this.setLevel(logLevel);
        } else {
            this.setLevel(defaultLogLevel);
        }
        this.setUseParentHandlers(useParent);
        if (defaultLogger == null) {
            this.initLoggerServer();
        }
    }

    public static synchronized CfmLogger getCfmLogger(String name) {
        return CfmLogger.getCfmLogger(name, null);
    }

    public static synchronized CfmLogger getCfmLogger(String name, boolean useParent) {
        return CfmLogger.getCfmLogger(name, null, useParent);
    }

    public static synchronized CfmLogger getCfmLogger(String name, String resourceBundleName) {
        return CfmLogger.getCfmLogger(name, resourceBundleName, false);
    }

    public static synchronized CfmLogger getCfmLogger(String name, String resourceBundleName, boolean useParent) {
        LogManager manager = LogManager.getLogManager();
        Logger result = manager.getLogger(name);
        if (result == null) {
            CfmLogger logger;
            if (hashManagers == null) {
                hashManagers = new Hashtable();
            }
            if ((logger = (CfmLogger)hashManagers.get(name)) == null) {
                result = new CfmLogger(name, resourceBundleName, useParent);
                manager.addLogger(result);
                result = manager.getLogger(name);
                hashManagers.put(name, result);
            } else {
                result = logger;
            }
            result = new CfmLogger(name, resourceBundleName, useParent);
            manager.addLogger(result);
            result = manager.getLogger(name);
        } else if (!(result instanceof CfmLogger)) {
            return null;
        }
        return (CfmLogger)result;
    }

    public static void say(String what) {
        defaultLogger.log(Level.INFO, what);
    }

    public static void bark(String what) {
        defaultLogger.log(Level.SEVERE, what);
    }

    public static String getAvailableHandlers() {
        return "";
    }

    public void setHandlerLevel(String handlerName, Level level) {
        Handler handler = (Handler)this.hashHandlers.get(handlerName);
        if (handler != null) {
            handler.setLevel(level);
        }
    }

    public void stop() {
    }

    public void initLoggerServer() {
    }

    private static Level getLogLevel(String sLogLevel) {
        if (sLogLevel == null) {
            return null;
        }
        if ((sLogLevel = sLogLevel.trim()).equalsIgnoreCase(SEVERE)) {
            return Level.SEVERE;
        }
        if (sLogLevel.equalsIgnoreCase(WARNING)) {
            return Level.WARNING;
        }
        if (sLogLevel.equalsIgnoreCase(BASIC) || sLogLevel.equalsIgnoreCase(INFO)) {
            return Level.INFO;
        }
        if (sLogLevel.equalsIgnoreCase(CONFIG)) {
            return Level.CONFIG;
        }
        if (sLogLevel.equalsIgnoreCase(GENERAL) || sLogLevel.equalsIgnoreCase(FINE)) {
            return Level.FINE;
        }
        if (sLogLevel.equalsIgnoreCase(DETAILED) || sLogLevel.equalsIgnoreCase(FINER)) {
            return Level.FINER;
        }
        if (sLogLevel.equalsIgnoreCase(TRACE) || sLogLevel.equalsIgnoreCase(FINEST)) {
            return Level.FINEST;
        }
        return Level.ALL;
    }

    public String addCfmFileHandler() {
        return this.addCfmFileHandler(null, null, null, TIMESTAMPED_LOG_FILES);
    }

    public String addCfmFileHandler(String dir, Level level, String format, boolean timestamp) {
        String ext;
        Formatter formatter;
        dir = CfmUtil.noNull(dir, LOG_DIR);
        if (System.getProperty(LOG_SCRATCHPATH, null) != null) {
            dir = LOG_DIR_SCRATCHPATH;
        }
        if (level == null) {
            level = Level.ALL;
        }
        new File(dir).mkdirs();
        if (XML_FORMAT.equals(format)) {
            formatter = new CfmXMLFormatter();
            ext = ".xml";
        } else {
            formatter = new CfmSimpleFormatter();
            ext = ".log";
        }
        String filename = this.getName();
        int index = filename.lastIndexOf(LOGGER_NAME_DELIMITER);
        if (index != -1) {
            filename = filename.substring(0, index);
        }
        String logFilePath = timestamp ? dir + File.separator + filename + "_" + CfmLoggerUtil.getTimeStamp() + ext : dir + File.separator + filename + ext;
        return this._addCfmFileHandler(logFilePath, level, formatter);
    }

    private String _addCfmFileHandler(String logFilePath, Level level, Formatter formatter) {
        if (this.hashHandlers.get(logFilePath) != null) {
            return logFilePath;
        }
        try {
            File f = new File(logFilePath);
            Filer.createSecureFile(f);
            CfmFileHandler handler = new CfmFileHandler(logFilePath);
            if (level != null) {
                handler.setLevel(level);
            }
            handler.setFormatter(formatter);
            this.addHandler(handler);
            this.hashHandlers.put(handler.getHandlerName(), handler);
            return handler.getHandlerName();
        }
        catch (IOException e) {
            System.err.println("CfmLogger.addFileHandler:Error while adding file handler - " + logFilePath);
            return null;
        }
    }

    public String addCfmConsoleHandler(Level level, String format) {
        Formatter formatter = XML_FORMAT.equals(format) ? new XMLFormatter() : new SimpleFormatter();
        if (this.hashHandlers.get("CfmConsoleHandler") != null) {
            return "CfmConsoleHandler";
        }
        CfmConsoleHandler handler = new CfmConsoleHandler();
        if (level != null) {
            handler.setLevel(level);
        }
        handler.setFormatter(formatter);
        this.addHandler(handler);
        this.hashHandlers.put(handler.getHandlerName(), handler);
        return handler.getHandlerName();
    }

    public void removeHandler(String handlerName) {
        Handler handler = (Handler)this.hashHandlers.get(handlerName);
        if (handler != null) {
            this.removeHandler(handler);
        }
    }

    public Handler setLogLocationWithTimestamp(String dir, String file, String extension) {
        return this.setLogLoc(dir, file, extension, null, null, true);
    }

    public Handler setLogLocationWithTimestamp(String dir, String file, String extension, Level level, Formatter formatter) {
        return this.setLogLoc(dir, file, extension, level, formatter, true);
    }

    public Handler setLogLocation(String dir, String file, String extension) {
        return this.setLogLoc(dir, file, extension, null, null, false);
    }

    public Handler setLogLocation(String dir, String file, String extension, Level level, Formatter formatter) {
        return this.setLogLoc(dir, file, extension, level, formatter, false);
    }

    private Handler setLogLoc(String dir, String file, String extension, Level level, Formatter formatter, boolean timestamp) {
        dir = CfmUtil.noNull(dir, LOG_DIR);
        file = CfmUtil.noNull(file, "installActions");
        extension = CfmUtil.noNull(extension, ".log");
        if (level == null) {
            level = Level.FINEST;
        }
        if (formatter == null) {
            formatter = new CfmSimpleFormatter();
        }
        new File(dir).mkdirs();
        String filePath = timestamp ? dir + File.separator + file + "_" + CfmLoggerUtil.getTimeStamp() + extension : dir + File.separator + file + extension;
        String handlerName = this._addCfmFileHandler(filePath, level, formatter);
        if (handlerName != null) {
            return (Handler)this.hashHandlers.get(handlerName);
        }
        return null;
    }

    public void resetLogger() {
        Handler[] handlers = this.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            this.removeHandler(handler);
            handler.close();
        }
        this.hashHandlers.clear();
    }

    public static void resetLoggers() {
        LogManager.getLogManager().reset();
        Enumeration<String> names = LogManager.getLogManager().getLoggerNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Logger logger = LogManager.getLogManager().getLogger(name);
            if (!(logger instanceof CfmLogger)) continue;
            ((CfmLogger)logger).resetLogger();
        }
    }

    public void flushHandlers() {
        Handler[] handlers = this.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            handler.flush();
        }
    }

    public boolean checkError() {
        Handler[] handlers = this.getHandlers();
        boolean retValue = false;
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            ErrorManager errorManager = handler.getErrorManager();
            if (!(errorManager instanceof CfmErrorManager) || !((CfmErrorManager)errorManager).getErr()) continue;
            retValue = true;
            ((CfmErrorManager)errorManager).setErr(false);
        }
        return retValue;
    }

    public void writeLogWithTimestamp(Level level, String message, Object[] params) {
        ResourceBundle resourceBundle;
        String sMessage = message;
        if (!b_putTimestamp) {
            Date dateNow = new Date();
            DateFormat df = DateFormat.getDateTimeInstance(3, 1);
            sMessage = sMessage + S_SEPERATOR + df.format(dateNow);
        }
        if ((resourceBundle = this.getResourceBundle()) != null) {
            try {
                sMessage = sMessage + S_SEPERATOR + resourceBundle.getString(message);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.log(level, sMessage, params);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void log(Level level, String msg) {
        if (this.prefix != null && this.prefix.length() > 0) {
            msg = this.prefix + ":" + msg;
        }
        super.log(level, msg);
    }

    public void logCollection(Level level, Collection collection) {
        Iterator i = collection.iterator();
        if (!i.hasNext()) {
            this.log(level, " <no elements>");
        } else {
            do {
                this.log(level, i.next().toString());
            } while (i.hasNext());
        }
    }

    public void dprint(Level level, String message) {
        this.log(level, CfmUtil.getCurrentTimeAsString() + message);
    }

    public String[] getLogDirectory() {
        ArrayList<String> logDirectory = new ArrayList<String>();
        Handler[] handlers = this.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            CfmFileHandler fileHandler;
            File logFile;
            String logDir;
            if (!(handlers[i] instanceof CfmFileHandler) || (logDir = (logFile = new File((fileHandler = (CfmFileHandler)handlers[i]).getLogFileName())).getParentFile().getAbsolutePath()) == null || logDirectory.contains(logDir)) continue;
            logDirectory.add(logDir);
        }
        return logDirectory.toArray(new String[0]);
    }

    static {
        if (Constants.VERBOSE_OUTPUT) {
            b_putTimestamp = true;
        }
        hashManagers = new Hashtable();
    }
}

