/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

class StreamGobbler
extends Thread {
    final InputStream inputStream;
    final PrintStream ps;
    final PrintStream err;
    final ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
    boolean running = false;

    static StreamGobbler processOutputStream(InputStream inputStream, PrintStream ps, PrintStream err) {
        StreamGobbler result = new StreamGobbler(inputStream, ps, err);
        if (inputStream != null && ps != null) {
            result.running = true;
            result.start();
        }
        return result;
    }

    static StreamGobbler processOutputStream(InputStream inputStream, PrintStream ps) {
        return StreamGobbler.processOutputStream(inputStream, ps, ps);
    }

    public void waitFor() {
        while (this.running) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private StreamGobbler(InputStream inputStream, PrintStream ps, PrintStream err) {
        this.inputStream = inputStream;
        this.ps = ps;
        this.err = err;
    }

    public String getStream() {
        return this.tempStream.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            PrintStream printStream = this.ps;
            synchronized (printStream) {
                int currByte;
                while ((currByte = this.inputStream.read()) != -1) {
                    this.ps.write(currByte);
                    this.tempStream.write(currByte);
                }
                this.ps.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace(this.err);
        }
        finally {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
            this.running = false;
        }
    }
}

