/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.Serializable;
import oracle.sysman.emCfg.common.AggregateFamilyIdentifier;
import oracle.sysman.emCfg.common.AggregateVersion;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IStateReference;
import oracle.sysman.emCfg.common.OHAbsolute;
import oracle.sysman.emCfg.core.ICfmPair;

abstract class StateReference
implements IStateReference,
Serializable {
    private final String aggID;
    private final AggregateVersion version;
    private final String ns;
    private final String familyName;
    private final OHAbsolute oh;
    private final String selfID;
    private final Class cfmClass;
    private final String asString;

    public StateReference(ICfmPair pair) {
        this.aggID = pair.getAggregateHolder().getSelfID();
        this.version = pair.getAggregateHolder().getVersion();
        this.ns = pair.getAggregateHolder().getNS();
        this.familyName = pair.getFamilyName();
        this.oh = pair.getAggregateHolder().getOracleHomeAbs();
        this.selfID = pair.getSelfID();
        this.cfmClass = pair.getClass();
        this.asString = pair.toString();
    }

    @Override
    public String getAggregateID() {
        return this.aggID;
    }

    @Override
    public String getOH() {
        return this.oh.toString();
    }

    @Override
    public String getOwnerID() {
        return this.aggID;
    }

    @Override
    public String getVersionID() {
        return this.version.toString();
    }

    @Override
    public String getNameSpace() {
        return this.ns;
    }

    @Override
    public String getFamily() {
        return this.familyName;
    }

    @Override
    public String getSelfID() {
        return this.selfID;
    }

    @Override
    public Class getCfmClass() {
        return this.cfmClass;
    }

    @Override
    public AggregateFamilyIdentifier getOwnerFamily() {
        AggregateVersion actualVersion;
        try {
            actualVersion = AggregateVersion.versionFromString(this.getVersionID());
        }
        catch (CfwException e) {
            throw new Error("An illegal StateReference was encountered");
        }
        return new AggregateFamilyIdentifier(this.getAggregateID(), this.getNameSpace(), actualVersion, this.getFamily(), this.oh);
    }

    public String toString() {
        return "ref:" + this.asString;
    }
}

