/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.sysman.emCfg.common.CfwException;

public class SpawnExternal {
    private void startMethod(String classToStart, String methodToStart, String[] newArgs) throws Exception {
        Method theMethod;
        Object theObject;
        Class<?> theClass;
        try {
            theClass = Class.forName(classToStart);
        }
        catch (Throwable t) {
            throw new CfwException("Failed to load class " + classToStart + ": " + t.toString(), t);
        }
        try {
            theObject = theClass.newInstance();
        }
        catch (Throwable t) {
            throw new CfwException("Failed to instantiate class " + classToStart + " using nullary constructor: " + t.toString(), t);
        }
        Class[] paramTypes = new Class[]{String[].class};
        try {
            theMethod = theClass.getMethod(methodToStart, paramTypes);
        }
        catch (Throwable t) {
            throw new CfwException("Method " + methodToStart + "(String[]) does not exist in " + classToStart + ": " + t.toString(), t);
        }
        Object[] values = new Object[]{newArgs};
        try {
            theMethod.invoke(theObject, values);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            throw new CfwException("Method " + methodToStart + " threw exception: " + t, t);
        }
    }

    public static void main(String[] args) throws Exception {
        String classToStart = args[0];
        String methodToStart = args[1];
        try {
            String[] arguments = new String[args.length - 2];
            System.arraycopy(args, 2, arguments, 0, args.length - 2);
            SpawnExternal spawnExternal = new SpawnExternal();
            spawnExternal.startMethod(classToStart, methodToStart, arguments);
        }
        catch (Throwable t) {
            throw new CfwException("SpawnExternal.startMethod: Failed to invoke method " + methodToStart + " in " + classToStart + ": " + t.toString(), t);
        }
    }
}

