/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmAggregateRef;
import oracle.sysman.emCfg.core.IResolvable;
import oracle.sysman.emCfg.support.CfmUtil;

class Resolver {
    private static final boolean debugB = Cfm.isDebug();
    private List unresolvedList = new Vector();
    private List aggregateRefs = new ArrayList();
    private List unresolvedRefs = new Vector();

    Resolver() {
    }

    List getUnresolvedList() {
        return new Vector(this.unresolvedList);
    }

    int getUnresolvedCount() {
        return this.unresolvedList.size();
    }

    void addUnresolved(IResolvable obj) {
        if (this.unresolvedList.contains(obj)) {
            return;
        }
        this.unresolvedList.add(obj);
    }

    void addAggregateReference(CfmAggregateRef aggRef) {
        this.aggregateRefs.add(aggRef);
    }

    List getAggregateReferences() {
        return this.aggregateRefs;
    }

    List getUnresolvedReferences() {
        return this.unresolvedRefs;
    }

    boolean resolve() {
        this.unresolvedRefs.clear();
        if (debugB) {
            Cfm.getLogger().log(Level.FINEST, "Resolver.resolve: starting size = " + this.unresolvedList.size());
        }
        Iterator i = this.unresolvedList.iterator();
        while (i.hasNext()) {
            IResolvable obj = (IResolvable)i.next();
            if (debugB) {
                Cfm.getLogger().log(Level.FINEST, "Resolver.resolve: about to try to do resolve() on " + obj);
            }
            if (obj.resolve()) {
                if (debugB) {
                    Cfm.getLogger().log(Level.FINEST, "Resolver.resolve: resolved " + obj);
                }
                i.remove();
                continue;
            }
            if (debugB) {
                Cfm.getLogger().log(Level.FINEST, "Resolver.resolve: NOT resolved " + obj + ", i.e. " + obj.getClass().getName());
            }
            if (!(obj instanceof CfmAggregateRef)) continue;
            CfmAggregateRef aggregateRef = (CfmAggregateRef)obj;
            if (!this.unresolvedRefs.contains(aggregateRef.getAggRefIdentifier())) {
                this.unresolvedRefs.add(aggregateRef.getAggRefIdentifier());
            }
            if (!debugB) continue;
            Cfm.getLogger().log(Level.FINEST, "Resolver.resolve: aggregateRef origin points to nsRef=" + aggregateRef.getNsRef() + ", idref=" + aggregateRef.getIdref());
        }
        if (this.unresolvedList.size() == 0) {
            if (debugB) {
                Cfm.getLogger().log(Level.FINEST, "Resolver.resolve: nothing more to do");
            }
            return true;
        }
        if (debugB) {
            i = this.unresolvedList.iterator();
            while (i.hasNext()) {
                Cfm.getLogger().log(Level.FINEST, "Resolver.resolve: still UNRESOLVED " + i.next());
            }
            Cfm.getLogger().log(Level.FINEST, "Resolver.resolve: There were " + this.unresolvedList.size() + " total unresolved references");
        }
        return false;
    }

    public void verifyAllRequiredResolved() throws CfwException {
        LinkedList<IResolvable> requiredUnresolvedList = new LinkedList<IResolvable>();
        for (IResolvable resolvable : this.unresolvedList) {
            if (!resolvable.isRequired()) continue;
            requiredUnresolvedList.add(resolvable);
        }
        int count = requiredUnresolvedList.size();
        if (debugB) {
            Cfm.getLogger().log(Level.FINEST, "Resolver.resolve: There were " + count + " required unresolved references");
        }
        if (count > 0) {
            throw new CfwException("Found " + count + " required unresolved reference(s):\n" + CfmUtil.collectionToString(requiredUnresolvedList, "\n"));
        }
    }
}

