/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.Serializable;
import oracle.sysman.emCfg.common.AggregateFamilyIdentifier;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IObject;
import oracle.sysman.emCfg.common.IReference;
import oracle.sysman.emCfg.core.ICfm;

abstract class Reference
implements IReference,
Serializable {
    private final transient Class cfmClass;
    private final String selfID;
    private final AggregateFamilyIdentifier ownerFamily;

    @Override
    public Class getCfmClass() {
        return this.cfmClass;
    }

    @Override
    public String getSelfID() {
        return this.selfID;
    }

    @Override
    public String getOwnerID() {
        return this.ownerFamily.getSelfID();
    }

    @Override
    public String getVersionID() {
        return this.ownerFamily.getVersion().toString();
    }

    @Override
    public String getNameSpace() {
        return this.ownerFamily.getNamespace();
    }

    @Override
    public String getFamily() {
        return this.ownerFamily.getFamily();
    }

    @Override
    public AggregateFamilyIdentifier getOwnerFamily() {
        return this.ownerFamily;
    }

    Reference(Class cfmClass, String selfID, AggregateFamilyIdentifier ownerFamily) {
        this.cfmClass = cfmClass;
        this.selfID = selfID;
        this.ownerFamily = ownerFamily;
    }

    Reference(Class cfmClass, AggregateFamilyIdentifier ident) {
        this.cfmClass = cfmClass;
        this.selfID = ident.getSelfID();
        this.ownerFamily = ident;
    }

    public String toString() {
        return this.getSelfID() + ":" + this.getOwnerID() + ":" + this.getVersionID() + ":" + this.getNameSpace();
    }

    abstract IObject getReferredObject(ICfm var1) throws CfwException;
}

