/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmMicroStepPair;
import oracle.sysman.emCfg.core.PlugInInvocationState;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.emCfg.types.MicroStepFlavor;
import oracle.sysman.emCfg.types.MicroStepStatus;

class PlugInInvocationStateInternal
extends PlugInInvocationState {
    private String javaClass;

    PlugInInvocationStateInternal() {
    }

    public void setJavaClass(String javaClass) {
        this.javaClass = javaClass;
    }

    @Override
    public String getCommand() {
        return this.javaClass;
    }

    @Override
    public MicroStepFlavor getFlavor() {
        return MicroStepFlavor.INTERNAL_INVOCATION;
    }

    @Override
    public void save(StringBuffer sb, MicroStepStatus status) {
        sb.append("\t\t\t<ins:InternalInvocation status=\"" + Formatter.escapeXMLSequences(status.getIdent()) + "\" ");
        if (this.getStatusDetails() != null) {
            sb.append("status_details=\"" + Formatter.escapeXMLSequences(this.getStatusDetails()) + "\" ");
        }
        sb.append("javaClass=\"" + Formatter.escapeXMLSequences(this.javaClass) + "\" ");
        sb.append("isActive=\"" + this.isActive() + "\" >\n");
        String exception = this.getExceptionNoException();
        if (exception != null && exception.length() > 0) {
            sb.append("\t\t\t<exception>" + Formatter.escapeXMLSequences(exception) + "</exception>\n");
        }
        this.saveArgs(sb);
        sb.append("\t\t\t</ins:InternalInvocation>\n");
    }

    @Override
    public void initPrivate(CfmMicroStepPair microStepInstance, boolean isSilent) throws CfwException {
        this.javaClass = microStepInstance.getJavaClass(!isSilent);
        CfmUtil.myAssert(this.javaClass != null);
    }
}

