/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmExpandableString;
import oracle.sysman.emCfg.core.CfmMicroStepPair;
import oracle.sysman.emCfg.core.PlugInInvocationState;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.emCfg.types.MicroStepFlavor;
import oracle.sysman.emCfg.types.MicroStepStatus;

class PlugInInvocationStateExternalProgram
extends PlugInInvocationState {
    private String displayExecutable;
    private CfmExpandableString actualExecutable;

    PlugInInvocationStateExternalProgram() {
    }

    public void setExecutable(String executable) {
        this.displayExecutable = executable;
    }

    @Override
    public String getCommand() {
        return this.displayExecutable;
    }

    public CfmExpandableString getCmdExec() {
        return this.actualExecutable;
    }

    @Override
    public MicroStepFlavor getFlavor() {
        return MicroStepFlavor.EXTERNAL_PROGRAM_INVOCATION;
    }

    @Override
    public void save(StringBuffer sb, MicroStepStatus status) {
        String stdout;
        sb.append("\t\t\t<ins:ExternalProgramInvocation status=\"" + Formatter.escapeXMLSequences(status.getIdent()) + "\" ");
        if (this.getStatusDetails() != null) {
            sb.append("status_details=\"" + Formatter.escapeXMLSequences(this.getStatusDetails()) + "\" ");
        }
        sb.append("executable=\"" + Formatter.escapeXMLSequences(this.displayExecutable) + "\" ");
        sb.append("isActive=\"" + this.isActive() + "\" ");
        String stderr = this.getStderr();
        if (stderr != null && stderr.length() > 0) {
            sb.append("stderr=\"" + Formatter.escapeXMLSequences(stderr) + "\" ");
        }
        if ((stdout = this.getStdout()) != null && stdout.length() > 0) {
            sb.append("stdout=\"" + Formatter.escapeXMLSequences(stdout) + "\" ");
        }
        sb.append("errorcode=\"" + this.getExitCodeNoException() + "\" >\n");
        this.saveArgs(sb);
        sb.append("\t\t\t</ins:ExternalProgramInvocation>\n");
    }

    @Override
    public void initPrivate(CfmMicroStepPair microStepInstance, boolean isSilent) throws CfwException {
        this.actualExecutable = microStepInstance.getCmdExec(!isSilent).asExpandableString();
        this.displayExecutable = microStepInstance.getCmdExec(!isSilent).asString(microStepInstance.getAggregateHolder(), true);
        CfmUtil.myAssert(this.displayExecutable != null);
    }
}

