/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.core.CfmMicroStepPair;
import oracle.sysman.emCfg.core.PlugInInvocationState;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.emCfg.types.MicroStepFlavor;
import oracle.sysman.emCfg.types.MicroStepStatus;

class PlugInInvocationStateExternalJava
extends PlugInInvocationState {
    private String javaClassMethod;

    PlugInInvocationStateExternalJava() {
    }

    public void setJavaClassMethod(String javaClassMethod) {
        this.javaClassMethod = javaClassMethod;
    }

    @Override
    public String getCommand() {
        return this.javaClassMethod;
    }

    @Override
    public MicroStepFlavor getFlavor() {
        return MicroStepFlavor.EXTERNAL_JAVA_INVOCATION;
    }

    @Override
    public void save(StringBuffer sb, MicroStepStatus status) {
        String stdout;
        sb.append("\t\t\t<ins:ExternalJavaInvocation status=\"" + Formatter.escapeXMLSequences(status.getIdent()) + "\" ");
        if (this.getStatusDetails() != null) {
            sb.append("status_details=\"" + Formatter.escapeXMLSequences(this.getStatusDetails()) + "\" ");
        }
        sb.append("javaClassMethod=\"" + Formatter.escapeXMLSequences(this.javaClassMethod) + "\" ");
        sb.append("isActive=\"" + this.isActive() + "\" ");
        String stderr = this.getStderr();
        if (stderr != null && stderr.length() > 0) {
            sb.append("stderr=\"" + Formatter.escapeXMLSequences(stderr) + "\" ");
        }
        if ((stdout = this.getStdout()) != null && stdout.length() > 0) {
            sb.append("stdout=\"" + Formatter.escapeXMLSequences(stdout) + "\" ");
        }
        sb.append("errorcode=\"" + this.getExitCodeNoException() + "\">\n");
        this.saveArgs(sb);
        sb.append("\t\t\t</ins:ExternalJavaInvocation>\n");
    }

    @Override
    public void initPrivate(CfmMicroStepPair microStepInstance, boolean isSilent) throws CfwException {
        this.javaClassMethod = microStepInstance.getJavaClassMethod(!isSilent);
        CfmUtil.myAssert(this.javaClassMethod != null);
    }
}

