/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IObject;
import oracle.sysman.emCfg.common.IObjectState;
import oracle.sysman.emCfg.common.IPlugInInvocationState;
import oracle.sysman.emCfg.common.IStateReference;
import oracle.sysman.emCfg.core.CfmMicroStepPair;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.Formatter;
import oracle.sysman.emCfg.types.IStatus;
import oracle.sysman.emCfg.types.MicroStepFlavor;
import oracle.sysman.emCfg.types.MicroStepStatus;

abstract class PlugInInvocationState
implements IPlugInInvocationState {
    private CfmMicroStepPair microStepPair;
    private String exception;
    private String statusDetails;
    private String argument;
    private String stderr;
    private String stdout;
    private long exitCode;
    private boolean isActive = true;

    PlugInInvocationState() {
    }

    void setMicroStepPair(CfmMicroStepPair microStepPair) {
        this.microStepPair = microStepPair;
    }

    public abstract MicroStepFlavor getFlavor();

    public boolean isFlavor(MicroStepFlavor flavor) {
        return this.getFlavor().equals(flavor);
    }

    public abstract void save(StringBuffer var1, MicroStepStatus var2);

    public final void init(CfmMicroStepPair microStepInstance, boolean isSilent) throws CfwException {
        this.initPrivate(microStepInstance, isSilent);
    }

    protected abstract void initPrivate(CfmMicroStepPair var1, boolean var2) throws CfwException;

    public void resetStatus() {
        this.exception = "";
        this.stderr = "";
        this.stdout = "";
        this.exitCode = -1L;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public void setStatusDetails(String detailString) {
        this.statusDetails = detailString;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public void setArg(String argument) {
        this.argument = argument;
    }

    @Override
    public String getArg() {
        return this.argument;
    }

    public void saveArgs(StringBuffer sb) {
        String args = this.getArg();
        if (args != null && args.length() > 0) {
            sb.append("\t\t\t\t<ins:Argument>" + Formatter.escapeXMLSequences(args) + "</ins:Argument>\n");
        }
    }

    public void setArguments(String[] args) {
        this.setArg(CfmUtil.arrayToString(args, " ", ""));
    }

    @Override
    public String getPlugInID() {
        return this.microStepPair.getCfmMicroStep().getPlugInInvocation().getPlugInIdRef();
    }

    @Override
    public abstract String getCommand();

    public void setStdout(String stdout) {
        CfmUtil.myAssert("PlugInInvocationState.setStdout: valid only for EXTERNAL invocation, not for " + this.getFlavor(), this.getFlavor().isExternalPlugInInvocation());
        this.stdout = stdout;
    }

    @Override
    public String getStdout() {
        if (!this.getFlavor().isExternalPlugInInvocation()) {
            return "";
        }
        return this.stdout;
    }

    public void setStderr(String stderr) {
        CfmUtil.myAssert("PlugInInvocationState.setStderr: valid only for EXTERNAL invocation, not for " + this.getFlavor(), this.getFlavor().isExternalPlugInInvocation());
        this.stderr = stderr;
    }

    @Override
    public String getStderr() {
        if (!this.getFlavor().isExternalPlugInInvocation()) {
            return "";
        }
        return this.stderr;
    }

    public void setExitCode(long exitCode) {
        CfmUtil.myAssert("PlugInInvocationState.setErrorcode: valid only for EXTERNAL invocation, not for " + this.getFlavor(), this.getFlavor().isExternalPlugInInvocation());
        this.exitCode = exitCode;
    }

    @Override
    public long getExitCode() throws CfwException {
        if (!this.getFlavor().isExternalPlugInInvocation()) {
            throw new CfwException("PlugInInvocationState.getExitCode: valid only for EXTERNAL invocation, not for " + this.getFlavor());
        }
        return this.exitCode;
    }

    public long getExitCodeNoException() {
        CfmUtil.myAssert(this.getFlavor().isExternalPlugInInvocation());
        return this.exitCode;
    }

    public void setException(String exception) {
        CfmUtil.myAssert(this.getFlavor().isInternalPlugInInvocation());
        this.exception = exception;
    }

    @Override
    public String getException() throws CfwException {
        if (!this.getFlavor().isInternalPlugInInvocation()) {
            throw new CfwException("PlugInInvocationState.getException: valid only for INTERNAL_INVOCATION, not for " + this.getFlavor());
        }
        return this.exception;
    }

    public String getExceptionNoException() {
        CfmUtil.myAssert(this.getFlavor().isInternalPlugInInvocation());
        return this.exception;
    }

    public String toString() {
        return "\nPlugInInvocationState: flavor=\"" + this.getFlavor() + "\" End-of-PlugInInvocationState\n";
    }

    @Override
    public String[] getNextInvocationArgsTEMP(boolean silentPlugins, boolean replaceTransientWithName, boolean replaceUninitializedWithName) throws CfwException {
        return this.microStepPair.getCurrentArgs(silentPlugins).expand(replaceTransientWithName, replaceUninitializedWithName);
    }

    @Override
    public boolean hasNonSilentInvocation() throws CfwException {
        return this.microStepPair.getCfmMicroStep().getPlugInInvocation().hasNonSilentInvocation();
    }

    @Override
    public IStateReference getReference() {
        throw new Error("This method should not currently be invoked");
    }

    @Override
    public String getSelfID() {
        throw new Error("This method should not currently be invoked");
    }

    @Override
    public String getSummary() throws CfwException {
        throw new Error("This method should not currently be invoked");
    }

    @Override
    public IStatus getStatus() throws CfwException {
        throw new Error("This method should not currently be invoked");
    }

    @Override
    public IObjectState getParent() throws CfwException {
        throw new Error("This method should not currently be invoked");
    }

    @Override
    public IObject getOriginator() throws CfwException {
        throw new Error("This method should not currently be invoked");
    }
}

