/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.emCfg.core;

import java.io.PrintStream;
import java.util.logging.Level;
import oracle.sysman.emCfg.client.CfwSession;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.CfwExceptionUninitializedParameter;
import oracle.sysman.emCfg.common.Constants;
import oracle.sysman.emCfg.common.Environment;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IInternalPlugIn;
import oracle.sysman.emCfg.common.IInternalPlugInContext;
import oracle.sysman.emCfg.core.AggregateReference;
import oracle.sysman.emCfg.core.Cfm;
import oracle.sysman.emCfg.core.CfmArguments;
import oracle.sysman.emCfg.core.CfmExpandableString;
import oracle.sysman.emCfg.core.CfmMicroStepPair;
import oracle.sysman.emCfg.core.CfmMicroStepState;
import oracle.sysman.emCfg.core.CfmSession;
import oracle.sysman.emCfg.core.PlugInInvocationState;
import oracle.sysman.emCfg.core.PlugInInvocationStateExternalProgram;
import oracle.sysman.emCfg.core.ProgressEvent;
import oracle.sysman.emCfg.core.StreamGobbler;
import oracle.sysman.emCfg.logger.CfmLogger;
import oracle.sysman.emCfg.support.CfmUtil;
import oracle.sysman.emCfg.support.Shell;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.emCfg.types.MicroStepFlavor;
import oracle.sysman.emCfg.types.MicroStepStatus;

class PerformMicroStep {
    private static final String ID_STRING = "PerformMicroStep:";
    static final boolean debug = Cfm.isDebug();
    private static final Environment systemEnv = PerformMicroStep.getSystemEnv();
    private static final String systemClassPath = System.getProperty("java.class.path");
    static final String ENV_VAR_PATH = "PATH";
    static final String SYSPROP_LIBRARY_PATH = "java.library.path";
    private final ActionType actionType;
    private final CfmMicroStepPair ms;
    private final CfmLogger cfmLogger;
    private final CfmArguments args;
    private final Environment env;
    private final CfmMicroStepState state;
    private final PlugInInvocationState pState;
    private final boolean useCommandArray;
    private final boolean attached;
    private Shell shell = null;
    private IInternalPlugIn theObject;
    private boolean canBeAborted = false;
    private boolean plugInDone = false;
    boolean plugInEndReported = false;
    boolean abortPlugIn = false;
    private static final Class[] constuctorParamTypes1 = new Class[]{IInternalPlugInContext.class};
    private static final Class[] constuctorParamTypes2 = new Class[]{IAggregate.class};
    static final String ARGV_LOG_DELIMITER = "\narg: ";

    private static Environment getSystemEnv() {
        try {
            return Environment.getSystemEnv();
        }
        catch (CfwException e) {
            return new Environment();
        }
    }

    private Environment populateEnv(Environment newProperties, boolean appendJavaLibPath) throws CfwException {
        Environment thisEnv = new Environment(systemEnv);
        thisEnv.addAndExpandEnv(newProperties);
        if (appendJavaLibPath) {
            String path = thisEnv.getProperty(ENV_VAR_PATH, "");
            String libPath = System.getProperty(SYSPROP_LIBRARY_PATH, "");
            thisEnv.setProperty(ENV_VAR_PATH, CfmUtil.combinePaths(path, libPath));
        }
        return thisEnv;
    }

    PerformMicroStep(CfmMicroStepPair ms, boolean nonSilent, ActionType actionType) throws CfwException {
        this.ms = ms;
        this.args = ms.getCurrentArgs(!nonSilent);
        this.env = this.populateEnv(ms.getAggregateHolder().getOracleHomeEnvironmentVariables(), ms.getFlavor().isJavaPlugInInvocation());
        this.actionType = actionType;
        this.state = ms.getCfmMicroStepState();
        this.pState = this.state.getPlugInInvocationState();
        this.pState.setArguments(this.args.expandForDisplay());
        this.attached = ms.getCfmMicroStep().getPlugInInvocation().isAttached();
        this.useCommandArray = ms.getCfmMicroStep().getPlugInInvocation().isUseCommandArray();
        this.cfmLogger = CfmUtil.getCfmLogger(this.ms.getAggregateHolder());
    }

    void executeMicroStep() {
        try {
            this.cfmLogger.log(Level.INFO, "About to execute plug-in " + this.ms.getPlugInInvocationState().getPlugInID());
            if (this.abortPlugIn) {
                this.state.setStatus(MicroStepStatus.WAS_ABORTED);
            } else {
                this.reportStat(ProgressEvent.PLUGIN_START, MicroStepStatus.IS_PERFORMING);
                try {
                    if (this.ms.getFlavor().equals(MicroStepFlavor.EXTERNAL_JAVA_INVOCATION)) {
                        this.runJavaClassMethod();
                    } else if (this.ms.getFlavor().equals(MicroStepFlavor.EXTERNAL_PROGRAM_INVOCATION)) {
                        this.runCmdExec();
                    } else if (this.ms.getFlavor().equals(MicroStepFlavor.INTERNAL_INVOCATION)) {
                        this.runJavaClass();
                    }
                    this.state.setSummary("Action=" + this.ms.getOwningActionID() + " Step=" + this.ms.getCfmMicroStep().getStepIndex() + " MicroStep=" + this.ms.getCfmMicroStep().getIndex() + " have completed " + this.pState.getCommand() + " with Status=" + this.ms.getMicroStepStatus().getLocalizedBriefString());
                }
                catch (CfwExceptionUninitializedParameter e) {
                    this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.USE_OF_UNINITIALIZED_PARAMETER, e.toString());
                }
                catch (Throwable e) {
                    this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.UNSPECIFIED_ERROR, e.toString());
                }
            }
        }
        finally {
            this.plugInDone = true;
        }
    }

    private synchronized void reportEvent(ProgressEvent event) {
        if (this.ms.getCfmMicroStep().getPlugInInvocation().isDisplay()) {
            this.ms.getCfmMicroStep().getActionStep().getAction().getParentAggregate().reportEvent(event, this.ms, this.actionType);
        }
    }

    void reportStat(ProgressEvent event, MicroStepStatus stat) {
        this.reportStat(event, stat, null);
    }

    synchronized void reportStat(ProgressEvent event, MicroStepStatus stat, String details) {
        if (event == ProgressEvent.PLUGIN_END) {
            this.plugInDone = true;
            if (this.plugInEndReported) {
                return;
            }
            this.plugInEndReported = true;
            if (this.abortPlugIn) {
                stat = MicroStepStatus.WAS_ABORTED;
                details = null;
            }
        }
        if (stat == MicroStepStatus.PERFORMED_FAILED) {
            if (!this.ms.getCfmMicroStep().getActionStep().isRequired()) {
                this.state.setStatus(MicroStepStatus.FAILED_NOTREQUIRED, details);
            } else {
                this.state.setStatus(MicroStepStatus.PERFORMED_FAILED, details);
            }
        } else {
            this.state.setStatus(stat, details);
            if (stat == MicroStepStatus.IS_PERFORMING) {
                this.pState.resetStatus();
            }
        }
        this.reportEvent(event);
        this.cfmLogger.log(Level.INFO, this.state.getLocalizedStatusString());
    }

    void abortDetached() {
        new Thread(){

            @Override
            public void run() {
                PerformMicroStep.this.abort();
            }
        }.start();
    }

    synchronized void abort() {
        this.abortPlugIn = true;
        while (!this.plugInDone && !this.canBeAborted) {
            try {
                this.wait(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.plugInDone) {
            this.cfmLogger.log(Level.INFO, "PlugInInvocation in " + this.ms.toString() + " has already completed; it will not be aborted");
            return;
        }
        this.cfmLogger.log(Level.INFO, "Aborting PlugInInvocation in " + this.ms.toString());
        this.state.setStatus(MicroStepStatus.IS_ABORTING);
        try {
            MicroStepFlavor flavor = this.ms.getFlavor();
            if (flavor.isInternalPlugInInvocation()) {
                try {
                    this.theObject.abort();
                    this.cfmLogger.log(Level.INFO, "abort called for internal PlugInInvocation in " + this.ms.toString());
                }
                catch (Throwable t) {
                    this.cfmLogger.log(Level.WARNING, this.theObject.getClass().getName() + ".abort() for " + this.ms.toString() + " threw an exception: " + t.toString());
                }
            } else {
                CfmUtil.myAssert(flavor.isExternalPlugInInvocation());
                this.shell.kill();
                this.cfmLogger.log(Level.INFO, "Terminated external PlugInInvocation in " + this.ms.toString());
            }
        }
        catch (Throwable t) {
            this.cfmLogger.log(Level.WARNING, "Exception encountered in AbortThread: " + t.toString());
        }
    }

    private void runCmdExec() throws CfwException {
        CfmArguments argv = new CfmArguments(this.args);
        CfmExpandableString target = ((PlugInInvocationStateExternalProgram)this.pState).getCmdExec();
        argv.prepend(target);
        String[] argvActual = argv.expandAsArgv();
        String actualTarget = argvActual[0];
        if (actualTarget == null || actualTarget.trim().length() == 0) {
            this.cfmLogger.log(Level.WARNING, "PerformMicroStep:runCmdExec: was provided an empty cmdExec");
            this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.INVALID_TARGET, "The CmdExec was empty");
            return;
        }
        String[] argvDisplay = argv.expandForDisplay();
        this.cfmLogger.info("Launching CmdExec");
        this.cfmLogger.finest("CmdExec: " + this.argsToString(argvDisplay, ARGV_LOG_DELIMITER));
        this.run(argvActual, this.env.toStringArray());
    }

    String argsToString(String[] argv, String delimiter) {
        return CfmUtil.arrayToString(argv, delimiter, "");
    }

    private String constructActualClassPath() throws CfwException {
        String classPath = this.ms.getCfmMicroStep().getPlugInInvocation().evaluateClasspath(this.ms.getAggregateHolder());
        return CfmUtil.combinePaths(systemClassPath, classPath);
    }

    void runJavaClassMethod() throws CfwException {
        String actualClassPath;
        try {
            actualClassPath = this.constructActualClassPath();
        }
        catch (CfwException e) {
            this.cfmLogger.log(Level.WARNING, "PerformMicroStep:runJavaClassMethod: couldn't expand classpath: " + e);
            this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.USE_OF_UNINITIALIZED_PARAMETER, "Couldn't expand classpath: " + e);
            return;
        }
        String target = this.pState.getCommand();
        String[] classAndMethod = target.split(":");
        CfmArguments argv = new CfmArguments(this.args);
        argv.prepend(classAndMethod[1]).prepend(classAndMethod[0]).prepend(Constants.EXT_JVM_CLASS_SPAWNER).prepend(actualClassPath).prepend("-cp").prepend("java");
        String[] argvActual = argv.expandAsArgv();
        this.cfmLogger.info("Launching Java Command");
        this.cfmLogger.finest("Java Command: " + this.argsToString(argv.expandForDisplay(), ARGV_LOG_DELIMITER));
        this.run(argvActual, this.env.toStringArray());
    }

    private void run(String[] argv, String[] env) {
        int stat;
        this.shell = new Shell(this.attached);
        try {
            if (this.useCommandArray) {
                this.shell.run(argv, env);
            } else {
                this.shell.run(this.argsToString(argv, " "), env);
            }
            this.canBeAborted = true;
        }
        catch (CfwException e) {
            this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.INVALID_TARGET, e.toString());
        }
        if (this.attached) {
            Cfm cfm = this.ms.getAggregateHolder().getCfm();
            StreamGobbler outStreamGobbler = StreamGobbler.processOutputStream(this.shell.getProcessOutputChannel(), cfm.getCfmout(), cfm.getCfmerr());
            StreamGobbler errStreamGobbler = StreamGobbler.processOutputStream(this.shell.getProcessErrorOutputChannel(), cfm.getCfmerr());
            this.shell.waitForProcess();
            outStreamGobbler.waitFor();
            errStreamGobbler.waitFor();
            stat = this.shell.getExitStatusCode();
            String stdOut = outStreamGobbler.getStream();
            String stdErr = errStreamGobbler.getStream();
            this.cfmLogger.info("ExitCode=" + stat);
            this.cfmLogger.finest("Stdout=" + stdOut);
            this.cfmLogger.finest("Stderr=" + stdErr);
            this.pState.setStdout(stdOut);
            this.pState.setStderr(stdErr);
        } else {
            stat = 0;
        }
        this.pState.setExitCode(stat);
        this.cfmLogger.log(Level.INFO, "The plug-in " + this.ms.getPlugInInvocationState().getPlugInID() + " executed as attached=" + this.attached + " in separate process with exitcode=" + stat);
        if (stat == 0) {
            this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.PERFORMED_SUCCESS);
        } else if (stat == -1) {
            this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.WAS_ABORTED);
        } else {
            this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.PERFORMED_FAILED);
        }
    }

    private Object getInstanceOfPlugIn(String target, Class[] argTypes, Object[] argValues, String classPath) throws CfwException {
        return CfmUtil.getTheObject(target, argTypes, argValues, classPath, this.cfmLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJavaClass() {
        String target = this.pState.getCommand();
        this.cfmLogger.info("Internal PlugIn Class: " + target);
        this.cfmLogger.finest("Internal PlugIn Arguments: " + this.javaClassArgString());
        Cfm cfm = this.ms.getAggregateHolder().getCfm();
        PrintStream cfmOut = cfm.getCfmout();
        PrintStream cfmErr = cfm.getCfmerr();
        try {
            CfwTempSession session = CfwTempSession.getInstance(this.ms.getAggregateHolder().getCfm(), this.cfmLogger);
            try {
                boolean result;
                Object newObject;
                String classPath;
                try {
                    classPath = this.ms.getCfmMicroStep().getPlugInInvocation().evaluateClasspath(this.ms.getAggregateHolder());
                }
                catch (CfwException e) {
                    this.cfmLogger.log(Level.WARNING, "PerformMicroStep:runJavaClass: couldn't expand classpath: " + e);
                    this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.USE_OF_UNINITIALIZED_PARAMETER, "Couldn't expand classpath: " + e);
                    session.endTempSession();
                    return;
                }
                this.cfmLogger.log(Level.INFO, "Classpath = " + classPath);
                final IAggregate iagr = session.getAggregate(new AggregateReference(this.ms.getInstance().getInstanceIdentifier().getFamilyIdentWithLocation(), true));
                final PrintStream contextOutStream = CfmUtil.noNullPrintStream(cfmOut);
                final PrintStream contextErrStream = CfmUtil.noNullPrintStream(cfmErr);
                IInternalPlugInContext context = new IInternalPlugInContext(){

                    @Override
                    public PrintStream getOutStream() {
                        return contextOutStream;
                    }

                    @Override
                    public PrintStream getErrStream() {
                        return contextErrStream;
                    }

                    @Override
                    public IAggregate getAggregate() {
                        return iagr;
                    }

                    @Override
                    public Environment getEnv() {
                        return PerformMicroStep.this.env;
                    }
                };
                try {
                    Object[] constructorParamValues1 = new Object[]{context};
                    newObject = this.getInstanceOfPlugIn(target, constuctorParamTypes1, constructorParamValues1, classPath);
                }
                catch (CfwException e) {
                    try {
                        Object[] constructorParamValues2 = new Object[]{iagr};
                        newObject = this.getInstanceOfPlugIn(target, constuctorParamTypes2, constructorParamValues2, classPath);
                    }
                    catch (CfwException e2) {
                        String message = "Unable to instantiate InternalPlugIn." + CfmUtil.getLineSeparator() + "For new constructor: " + e.toString() + CfmUtil.getLineSeparator() + "For old constructor: " + e2.toString();
                        this.cfmLogger.warning(message);
                        this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.INVALID_TARGET, message);
                        session.endTempSession();
                        return;
                    }
                }
                if (!(newObject instanceof IInternalPlugIn)) {
                    this.cfmLogger.warning("PerformMicroStep:runJavaClass: The specified class (" + target + ") was found, but it doesn't implement IInternalPlugIn");
                    this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.INVALID_TARGET);
                    return;
                }
                this.theObject = (IInternalPlugIn)newObject;
                this.canBeAborted = true;
                int howLong = this.theObject.getWeight();
                this.state.setDuration(howLong);
                this.ms.getStepPair().getCfmActionStepState().addWeight(howLong);
                String actionID = this.ms.getCfmMicroStep().getActionStep().getActionID();
                int stepIndex = this.ms.getCfmMicroStep().getActionStep().getIndex();
                int selfIndex = this.ms.getCfmMicroStep().getIndex();
                try {
                    result = this.theObject.invoke(actionID, stepIndex, selfIndex, this.args.expandAsArgv());
                }
                catch (Throwable t) {
                    result = false;
                    this.cfmLogger.info("Internal PlugIn for " + this.state.toString() + " failed with an unhandled exception:\n" + CfmUtil.throwableToStackTrace(t));
                    this.pState.setException(t.toString());
                }
                if (result) {
                    this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.PERFORMED_SUCCESS);
                } else {
                    this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.PERFORMED_FAILED);
                }
            }
            finally {
                session.endTempSession();
            }
        }
        catch (CfwException e) {
            this.cfmLogger.log(Level.SEVERE, e.toString());
            this.reportStat(ProgressEvent.PLUGIN_END, MicroStepStatus.UNSPECIFIED_ERROR, e.toString());
            return;
        }
    }

    private String javaClassArgString() {
        String[] displayArgs = this.args.expandForDisplay();
        if (displayArgs.length == 0) {
            return "";
        }
        return ARGV_LOG_DELIMITER + this.argsToString(displayArgs, ARGV_LOG_DELIMITER);
    }

    static class CfwTempSession
    extends CfwSession {
        protected CfwTempSession(String cfmSessionID) {
            super(cfmSessionID);
        }

        protected static CfwTempSession getInstance(Cfm cfm, CfmLogger logger) throws CfwException {
            String cfmSessionID = CfmSession.newSession(cfm);
            if (cfmSessionID == null) {
                throw new CfwException("unable to obtain CfmSession ID");
            }
            if (debug) {
                logger.log(Level.INFO, "CfwTempSession.getInstance: obtained cfmSessionID = " + cfmSessionID);
            }
            return new CfwTempSession(cfmSessionID);
        }

        protected void endTempSession() {
            super.endSession();
        }
    }
}

